/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.uv.UVTransformation;
import cofh.core.render.ShaderHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.item.DuctUnitItemEnder;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.render.RenderDuctItems;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.render.shader.ShaderStarfield;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.ARBShaderObjects;

public class RenderDuctItemsEnder
extends RenderDuctItems {
    public static final TileEntitySpecialRenderer<TileGrid> INSTANCE = new RenderDuctItemsEnder();
    private final ShaderHelper.ShaderCallback shaderCallback = new ShaderHelper.ShaderCallback(){

        public void call(int shader, boolean newFrame) {
            if (!newFrame) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            float fov = mc.field_71474_y.field_74334_X * 2.0f;
            ARBShaderObjects.glUniform1fARB((int)ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"xpos"), (float)(mc.field_71439_g.field_70177_z / fov));
            ARBShaderObjects.glUniform1fARB((int)ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"zpos"), (float)(-mc.field_71439_g.field_70125_A / fov));
        }
    };

    @Override
    public void render(TileGrid tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        DuctUnitItemEnder duct = (DuctUnitItemEnder)tile.getDuct(DuctToken.ITEMS);
        if (duct != null && duct.powered) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.preRenderWorld((IBlockAccess)tile.func_145831_w(), tile.func_174877_v());
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int[] connections = RenderDuct.INSTANCE.getDuctConnections(tile);
            RenderDuctItemsEnder.drawEnderStarfield(ccrs, x, y, z, connections, partialTicks, duct.centerLine, duct.centerLineSub);
            ccrs.reset();
        } else {
            super.render(tile, x, y, z, partialTicks, destroyStage, alpha);
        }
    }

    public static void drawEnderStarfield(CCRenderState ccrs, double x, double y, double z, int[] connections, float frame, int alpha, int[] alphaSub) {
        if (ShaderHelper.useShaders() || ShaderStarfield.starfieldShader == 0) {
            TextureUtils.changeTexture((ResourceLocation)ShaderStarfield.starsTexture);
        } else {
            TextureUtils.changeTexture((ResourceLocation)RenderHelper.MC_BLOCK_SHEET);
        }
        CCModel[] models = RenderDuct.modelFluid[5];
        if (alpha == 0) {
            ShaderStarfield.alpha = 0.0f;
            ShaderHelper.useShader((int)ShaderStarfield.starfieldShader, (ShaderHelper.ShaderCallback)ShaderStarfield.callback);
            ccrs.startDrawing(7, DefaultVertexFormats.field_176600_a);
            for (int s = 0; s < 6; ++s) {
                if (!BlockDuct.ConnectionType.values()[connections[s]].renderDuct() || connections[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal()) continue;
                models[s].render(ccrs, x, y, z, (UVTransformation)RenderUtils.getIconTransformation((TextureAtlasSprite)TextureUtils.getBlockTexture((ResourceLocation)TFFluids.fluidEnder.getStill())));
            }
            models[6].render(ccrs, x, y, z, (UVTransformation)RenderUtils.getIconTransformation((TextureAtlasSprite)TextureUtils.getBlockTexture((ResourceLocation)TFFluids.fluidEnder.getStill())));
            ccrs.draw();
            ShaderHelper.releaseShader();
        } else {
            for (int s = 0; s < 6; ++s) {
                if (!BlockDuct.ConnectionType.values()[connections[s]].renderDuct() || connections[s] == BlockDuct.ConnectionType.STRUCTURE_CONNECTION.ordinal()) continue;
                ShaderStarfield.alpha = (float)RenderDuctItemsEnder.getAlphaLevel(alphaSub[s], frame) / 255.0f;
                ShaderHelper.useShader((int)ShaderStarfield.starfieldShader, (ShaderHelper.ShaderCallback)ShaderStarfield.callback);
                ccrs.startDrawing(7, DefaultVertexFormats.field_176600_a);
                models[s].render(ccrs, x, y, z, (UVTransformation)RenderUtils.getIconTransformation((TextureAtlasSprite)TextureUtils.getBlockTexture((ResourceLocation)TFFluids.fluidEnder.getStill())));
                ccrs.draw();
                ShaderHelper.releaseShader();
            }
            ShaderStarfield.alpha = (float)RenderDuctItemsEnder.getAlphaLevel(alpha, frame) / 255.0f;
            ShaderHelper.useShader((int)ShaderStarfield.starfieldShader, (ShaderHelper.ShaderCallback)ShaderStarfield.callback);
            ccrs.startDrawing(7, DefaultVertexFormats.field_176600_a);
            models[6].render(ccrs, x, y, z, (UVTransformation)RenderUtils.getIconTransformation((TextureAtlasSprite)TextureUtils.getBlockTexture((ResourceLocation)TFFluids.fluidEnder.getStill())));
            ccrs.draw();
            ShaderHelper.releaseShader();
        }
    }
}

