/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.client;

import cofh.core.gui.GuiCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementSlider;
import cofh.core.gui.element.listbox.SliderHorizontal;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.gui.container.ContainerRelay;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiRelay
extends GuiCore {
    static final String TEX_PATH = "thermaldynamics:textures/gui/relay.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermaldynamics:textures/gui/relay.png");
    private final Relay relay;
    public ElementButton buttonType;
    public ElementSlider slider;
    private ElementButton buttonInvert;
    ContainerRelay container;

    public GuiRelay(Relay relay) {
        super((Container)new ContainerRelay(relay), TEXTURE);
        this.relay = relay;
        this.drawInventory = false;
        this.name = "item.thermaldynamics.relay.name";
        this.container = (ContainerRelay)this.field_147002_h;
        this.field_147000_g = 74;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!"".equals(this.myInfo)) {
            this.addTab((TabBase)new TabInfo((GuiCore)this, this.myInfo));
        }
        this.buttonType = new ElementButton((GuiCore)this, 8, 16, "ButtonType", 0, 204, 0, 224, 20, 20, TEX_PATH);
        this.addElement((ElementBase)this.buttonType);
        this.buttonInvert = new ElementButton((GuiCore)this, 34, 16, "ButtonInvert", 0, 204, 0, 224, 20, 20, TEX_PATH);
        this.addElement((ElementBase)this.buttonInvert);
        this.slider = new SliderHorizontal(this, 62, 16, 100, 20, 15){

            public void onValueChanged(int value) {
                GuiRelay.this.relay.setThreshold((byte)value);
                GuiRelay.this.relay.sendUpdatePacket();
            }

            public void onStopDragging() {
                GuiRelay.this.relay.sendUpdatePacket();
            }

            public void addTooltip(List<String> list) {
                list.add(StringHelper.localize((String)"info.thermaldynamics.relay.threshold") + " " + this._value);
            }
        }.setValue((int)this.relay.threshold);
        this.addElement((ElementBase)this.slider);
        this.update();
    }

    private void update() {
        this.slider.setEnabled(this.relay.shouldThreshold());
        this.slider.setVisible(this.relay.shouldThreshold());
        this.buttonType.setSheetX(20 * this.relay.type);
        this.buttonType.setHoverX(20 * this.relay.type);
        this.buttonType.setToolTip("info.thermaldynamics.relay.type." + this.relay.type);
        this.buttonInvert.setSheetX(60 + 20 * this.relay.invert);
        this.buttonInvert.setHoverX(60 + 20 * this.relay.invert);
        this.buttonInvert.setToolTip("info.thermaldynamics.relay.invert." + this.relay.invert);
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        int v;
        super.handleElementButtonClick(buttonName, mouseButton);
        int n = v = mouseButton == 0 ? 1 : -1;
        if ("ButtonInvert".equals(buttonName)) {
            this.relay.invert = (byte)((this.relay.invert + 4 + v) % 4);
            this.relay.sendUpdatePacket();
        } else if ("ButtonType".equals(buttonName)) {
            this.relay.type = (byte)((this.relay.type + 3 + v) % 3);
            this.relay.sendUpdatePacket();
        }
        this.update();
    }

    protected void func_146979_b(int x, int y) {
        int gY;
        int rY;
        super.func_146979_b(x, y);
        if (this.relay.isInput()) {
            rY = 45;
            gY = 58;
        } else {
            gY = 45;
            rY = 58;
        }
        this.field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermaldynamics.relay.relayRS") + ": " + this.container.relayPower, 8, rY, 0x404040);
        this.field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermaldynamics.relay.gridRS") + ": " + this.container.gridPower, 8, gY, 0x404040);
    }
}

