/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.client;

import cofh.api.tileentity.IRedstoneControl;
import cofh.core.gui.GuiCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabRedstoneControl;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.gui.container.ContainerDuctConnection;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiDuctConnection
extends GuiCore {
    static final String TEX_PATH = "thermaldynamics:textures/gui/connection.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermaldynamics:textures/gui/connection.png");
    public String myInfo = "";
    InventoryPlayer inventory;
    ConnectionBase conBase;
    ContainerDuctConnection container;
    public ElementButton[] flagButtons = new ElementButton[0];
    public ElementButton[] levelButtons = new ElementButton[FilterLogic.defaultLevels.length];
    boolean isItemServo;
    boolean isAdvItemFilter;
    public ElementButton decStackSize;
    public ElementButton incStackSize;
    public ElementButton decRetainSize;
    public ElementButton incRetainSize;
    int minStackSize;
    int maxStackSize;
    int minRetainSize;
    int maxRetainSize;
    public int buttonSize;
    private static final int[][] levelButtonPos = new int[][]{{-1, -1}, {0, 204}, {80, 204}};
    private static final int[][] flagButtonsPos = new int[][]{{176, 0}, {176, 60}, {216, 0}, {216, 60}, {176, 120}, {216, 120}, {176, 180}, {216, 180}};

    public GuiDuctConnection(InventoryPlayer inventory, ConnectionBase conBase) {
        super((Container)new ContainerDuctConnection(inventory, conBase), TEXTURE);
        this.conBase = conBase;
        this.inventory = inventory;
        this.container = (ContainerDuctConnection)this.field_147002_h;
        this.name = conBase.getName();
        this.field_147000_g = 204;
        this.isItemServo = conBase.getId() == 2 || conBase.getId() == 6;
        this.isAdvItemFilter = (conBase.getId() == 4 || conBase.getId() == 6) && conBase.filter.canAlterFlag(3);
        switch (conBase.getId()) {
            case 2: {
                this.generateInfo("tab.thermaldynamics.servoItem");
                break;
            }
            case 4: {
                this.generateInfo("tab.thermaldynamics.filterItem");
                break;
            }
            case 6: {
                this.generateInfo("tab.thermaldynamics.retrieverItem");
                break;
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.myInfo.isEmpty()) {
            this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermaldynamics.conChange");
            this.addTab((TabBase)new TabInfo((GuiCore)this, this.myInfo));
        }
        if (this.conBase.canAlterRS()) {
            this.addTab((TabBase)new TabRedstoneControl((GuiCore)this, (IRedstoneControl)this.conBase));
        }
        int[] flagNums = this.container.filter.validFlags();
        this.flagButtons = new ElementButton[this.container.filter.numFlags()];
        int[] levelNums = this.container.filter.getValidLevels();
        this.levelButtons = new ElementButton[FilterLogic.defaultLevels.length];
        int buttonNo = flagNums.length + levelNums.length;
        if (buttonNo != 0) {
            int j;
            int i;
            this.buttonSize = 20;
            int button_offset = this.buttonSize + 6;
            int x0 = this.field_146999_f / 2 - buttonNo * (button_offset / 2) + 3;
            int y0 = this.container.gridY0 + this.container.gridHeight * 18 + 8;
            for (i = 0; i < flagNums.length; ++i) {
                j = flagNums[i];
                this.flagButtons[j] = new ElementButton((GuiCore)this, x0 + button_offset * i, y0, this.container.filter.flagType(j), flagButtonsPos[j][0], flagButtonsPos[j][1], flagButtonsPos[j][0], flagButtonsPos[j][1] + this.buttonSize, flagButtonsPos[j][0], flagButtonsPos[j][1] + this.buttonSize * 2, this.buttonSize, this.buttonSize, TEX_PATH);
                this.addElement((ElementBase)this.flagButtons[j]);
            }
            for (i = 0; i < levelNums.length; ++i) {
                j = levelNums[i];
                this.levelButtons[j] = new ElementButton((GuiCore)this, x0 + button_offset * (i + flagNums.length), y0, FilterLogic.levelNames[j], levelButtonPos[j][0], levelButtonPos[j][1], levelButtonPos[j][0], levelButtonPos[j][1] + this.buttonSize, this.buttonSize, this.buttonSize, TEX_PATH);
                this.addElement((ElementBase)this.levelButtons[j]);
            }
        }
        this.decStackSize = new ElementButton((GuiCore)this, 137, 57, "DecStackSize", 216, 120, 216, 134, 216, 148, 14, 14, TEX_PATH).setToolTip("info.thermaldynamics.servo.decStackSize");
        this.incStackSize = new ElementButton((GuiCore)this, 153, 57, "IncStackSize", 230, 120, 230, 134, 230, 148, 14, 14, TEX_PATH).setToolTip("info.thermaldynamics.servo.incStackSize");
        this.decRetainSize = new ElementButton((GuiCore)this, 137, 28, "DecRetainSize", 216, 120, 216, 134, 216, 148, 14, 14, TEX_PATH).setToolTip("info.thermaldynamics.filter.decRetainSize");
        this.incRetainSize = new ElementButton((GuiCore)this, 153, 28, "IncRetainSize", 230, 120, 230, 134, 230, 148, 14, 14, TEX_PATH).setToolTip("info.thermaldynamics.filter.incRetainSize");
        if (this.isAdvItemFilter) {
            this.addElement((ElementBase)this.decRetainSize);
            this.addElement((ElementBase)this.incRetainSize);
            this.minRetainSize = FilterLogic.minLevels[this.conBase.filter.type][3];
            this.maxRetainSize = FilterLogic.maxLevels[this.conBase.filter.type][3];
        }
        if (this.isItemServo) {
            this.addElement((ElementBase)this.decStackSize);
            this.addElement((ElementBase)this.incStackSize);
            this.minStackSize = FilterLogic.minLevels[this.conBase.filter.type][0];
            this.maxStackSize = FilterLogic.maxLevels[this.conBase.filter.type][0];
        }
        this.setButtons();
    }

    private void setButtons() {
        int x;
        int i;
        for (i = 0; i < this.flagButtons.length; ++i) {
            if (this.flagButtons[i] == null) continue;
            boolean b = this.container.filter.getFlag(i);
            x = flagButtonsPos[i][0] + (b ? this.buttonSize : 0);
            this.flagButtons[i].setSheetX(x);
            this.flagButtons[i].setHoverX(x);
            this.flagButtons[i].setToolTip("info.thermaldynamics.filter." + this.flagButtons[i].getName() + (b ? ".on" : ".off"));
        }
        for (i = 0; i < this.levelButtons.length; ++i) {
            if (this.levelButtons[i] == null) continue;
            int level = this.container.filter.getLevel(i);
            x = levelButtonPos[i][0] + level * this.buttonSize;
            this.levelButtons[i].setSheetX(x);
            this.levelButtons[i].setHoverX(x);
            this.levelButtons[i].setToolTip("info.thermaldynamics.filter." + this.levelButtons[i].getName() + "." + level);
        }
    }

    protected void updateElementInformation() {
        int qty;
        super.updateElementInformation();
        if (this.isAdvItemFilter) {
            qty = this.conBase.filter.getLevel(3);
            if (qty > this.minRetainSize) {
                this.decRetainSize.setActive();
            } else {
                this.decRetainSize.setDisabled();
            }
            if (qty < this.maxRetainSize) {
                this.incRetainSize.setActive();
            } else {
                this.incRetainSize.setDisabled();
            }
        }
        if (this.isItemServo) {
            qty = this.conBase.filter.getLevel(0);
            if (qty > this.minStackSize) {
                this.decStackSize.setActive();
            } else {
                this.decStackSize.setDisabled();
            }
            if (qty < this.maxStackSize) {
                this.incStackSize.setActive();
            } else {
                this.incStackSize.setDisabled();
            }
        }
        this.setButtons();
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        ElementButton button;
        int i;
        for (i = 0; i < this.flagButtons.length; ++i) {
            button = this.flagButtons[i];
            if (button == null || !button.getName().equals(buttonName)) continue;
            if (this.container.filter.setFlag(i, !this.container.filter.getFlag(i))) {
                if (this.container.filter.getFlag(i)) {
                    GuiDuctConnection.playClickSound((float)0.8f);
                } else {
                    GuiDuctConnection.playClickSound((float)0.6f);
                }
            }
            this.setButtons();
            return;
        }
        for (i = 0; i < this.levelButtons.length; ++i) {
            button = this.levelButtons[i];
            if (button == null || !button.getName().equals(buttonName)) continue;
            if (mouseButton == 0) {
                this.container.filter.incLevel(i);
                GuiDuctConnection.playClickSound((float)0.8f);
            } else if (mouseButton == 1) {
                this.container.filter.decLevel(i);
                GuiDuctConnection.playClickSound((float)0.6f);
            }
            this.setButtons();
            return;
        }
        int change = 1;
        float pitch = 0.7f;
        if (GuiScreen.func_146272_n()) {
            change = 16;
            pitch = 0.9f;
            if (mouseButton == 1) {
                change = 4;
                pitch = 0.8f;
            }
        }
        if (buttonName.equalsIgnoreCase("DecStackSize")) {
            this.container.filter.decLevel(0, change, false);
            pitch -= 0.1f;
        } else if (buttonName.equalsIgnoreCase("IncStackSize")) {
            this.container.filter.incLevel(0, change, false);
            pitch += 0.1f;
        }
        if (buttonName.equalsIgnoreCase("DecRetainSize")) {
            this.container.filter.decLevel(3, change, false);
            pitch -= 0.1f;
        } else if (buttonName.equalsIgnoreCase("IncRetainSize")) {
            this.container.filter.incLevel(3, change, false);
            pitch += 0.1f;
        }
        GuiDuctConnection.playClickSound((float)pitch);
    }

    protected void func_146979_b(int x, int y) {
        int qty;
        int xQty;
        if (this.isAdvItemFilter) {
            xQty = 146;
            qty = this.conBase.filter.getLevel(3);
            if (qty == 0) {
                this.field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermaldynamics.filter.zeroRetainSize"), xQty -= 9, 18, 0x404040);
            } else {
                if (qty < 10) {
                    xQty += 6;
                } else if (qty >= 100) {
                    xQty -= 3;
                }
                this.field_146289_q.func_78276_b("" + qty, xQty, 18, 0x404040);
            }
        }
        if (this.isItemServo) {
            xQty = 146;
            qty = this.conBase.filter.getLevel(0);
            if (qty < 10) {
                xQty += 6;
            }
            this.field_146289_q.func_78276_b("" + qty, xQty, 46, 0x404040);
        }
        super.func_146979_b(x, y);
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        super.func_146976_a(partialTick, x, y);
        this.drawSlots();
    }

    private void drawSlots() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(TEXTURE);
        int x0 = this.container.gridX0 - 1;
        int y0 = this.container.gridY0 - 1;
        int w = this.container.gridWidth * 18;
        int h = this.container.gridHeight * 18;
        int x1 = x0 + w;
        int y1 = y0 + h;
        for (int dx = x0; dx < x1; dx += 162) {
            for (int dy = y0; dy < y1; dy += 54) {
                int dw = Math.min(x1 - dx, 162);
                int dh = Math.min(y1 - dy, 54);
                this.func_73729_b(this.field_147003_i + dx, this.field_147009_r + dy, 7, 122, dw, dh);
            }
        }
    }
}

