/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.tiles;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import cofh.api.core.IPortableData;
import cofh.api.tileentity.ITileInfo;
import cofh.core.block.TileCore;
import cofh.core.network.ITileInfoPacketHandler;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.core.util.RayTracer;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.WrenchHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.AttachmentRegistry;
import cofh.thermaldynamics.duct.ConnectionType;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.duct.energy.DuctUnitEnergy;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.util.TickHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public abstract class TileGrid
extends TileCore
implements IDuctHolder,
IPortableData,
ITileInfoPacketHandler,
ITilePacketHandler,
ICustomHitBox,
ITileInfo {
    public static final boolean isDebug = true;
    static final int ATTACHMENT_SUB_HIT = 14;
    static final int COVER_SUB_HIT = 20;
    public static Cuboid6[] subSelection = new Cuboid6[12];
    public static Cuboid6 selection;
    public static Cuboid6[] subSelection_large;
    public static Cuboid6 selectionlarge;
    @Nullable
    private LinkedList<WeakReference<Chunk>> neighborChunks;
    @Nullable
    public AttachmentData attachmentData;
    @Nullable
    public BlockDuct.ConnectionType[] clientConnections;
    @Nullable
    private ConnectionType[] connectionTypes;

    public static void genSelectionBoxes(Cuboid6[] subSelection, int i, double min, double min2, double max2) {
        subSelection[i] = new Cuboid6(min2, 0.0, min2, max2, min, max2);
        subSelection[i + 1] = new Cuboid6(min2, 1.0 - min, min2, max2, 1.0, max2);
        subSelection[i + 2] = new Cuboid6(min2, min2, 0.0, max2, max2, min);
        subSelection[i + 3] = new Cuboid6(min2, min2, 1.0 - min, max2, max2, 1.0);
        subSelection[i + 4] = new Cuboid6(0.0, min2, min2, min, max2, max2);
        subSelection[i + 5] = new Cuboid6(1.0 - min, min2, min2, 1.0, max2, max2);
    }

    public String getDataType() {
        return "tile.thermaldynamics.duct";
    }

    public abstract Iterable<DuctUnit> getDuctUnits();

    @Override
    public boolean isSideBlocked(int side) {
        Attachment attachment = this.getAttachment(side);
        return attachment != null && !attachment.allowDuctConnection() || this.connectionTypes != null && !this.connectionTypes[side].allowTransfer;
    }

    public void onLoad() {
    }

    public void onChunkUnload() {
        if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            for (DuctUnit unit : this.getDuctUnits()) {
                unit.onChunkUnload();
            }
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            for (DuctUnit unit : this.getDuctUnits()) {
                unit.invalidate();
            }
        }
        super.func_145843_s();
    }

    protected void onAttachmentsChanged() {
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            Object grid = ductUnit.getGrid();
            if (grid == null) continue;
            ((MultiBlockGrid)grid).destroyAndRecreate();
        }
    }

    public void blockPlaced() {
    }

    public void onNeighborBlockChange() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.func_145837_r()) {
            return;
        }
        TileEntity[] tiles = new TileEntity[6];
        IDuctHolder[] holders = new IDuctHolder[6];
        for (int i = 0; i < 6; ++i) {
            TileEntity adjacentTileEntity;
            tiles[i] = adjacentTileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)i);
            if (adjacentTileEntity instanceof IDuctHolder) {
                holders[i] = (IDuctHolder)adjacentTileEntity;
                continue;
            }
            if (adjacentTileEntity != null || this.connectionTypes == null || this.getConnectionType(i) != ConnectionType.BLOCKED) continue;
            this.setConnectionType(i, ConnectionType.NORMAL);
        }
        int renderHash = this.getRenderHash();
        int tileHash = this.getTileHash();
        if (this.attachmentData != null) {
            for (Attachment attachment : this.attachmentData.attachments) {
                if (attachment == null) continue;
                attachment.onNeighborChange();
            }
        }
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            ductUnit.updateAllSides(tiles, holders);
        }
        if (renderHash != this.getRenderHash()) {
            this.callBlockUpdate();
        }
        if (tileHash != this.getTileHash()) {
            this.callNeighborStateChange();
            this.rebuildChunkCache();
        }
    }

    public void onNeighborTileChange(BlockPos pos) {
        TileEntity adjacentTileEntity;
        Attachment attachment;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        int renderHash = this.getRenderHash();
        int tileHash = this.getTileHash();
        byte side = (byte)this.getNeighborDirection(this.func_174877_v(), pos).ordinal();
        if (this.attachmentData != null && (attachment = this.attachmentData.attachments[side]) != null) {
            attachment.onNeighborChange();
        }
        IDuctHolder holder = (adjacentTileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)side)) instanceof IDuctHolder ? (IDuctHolder)adjacentTileEntity : null;
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            ductUnit.updateSide(adjacentTileEntity, holder, side);
        }
        if (renderHash != this.getRenderHash()) {
            this.callBlockUpdate();
        }
        if (tileHash != this.getTileHash()) {
            this.rebuildChunkCache();
        }
    }

    public EnumFacing getNeighborDirection(BlockPos pos, BlockPos neighbor) {
        int dx = pos.func_177958_n() - neighbor.func_177958_n();
        if (dx == 0) {
            int dz = pos.func_177952_p() - neighbor.func_177952_p();
            if (dz == 0) {
                int dy = pos.func_177956_o() - neighbor.func_177956_o();
                if (dy == 1) {
                    return EnumFacing.UP;
                }
                if (dy == -1) {
                    return EnumFacing.DOWN;
                }
            } else {
                if (dz == 1) {
                    return EnumFacing.SOUTH;
                }
                if (dz == -1) {
                    return EnumFacing.NORTH;
                }
            }
        } else {
            if (dx == 1) {
                return EnumFacing.EAST;
            }
            if (dx == -1) {
                return EnumFacing.WEST;
            }
        }
        throw new IllegalStateException("Positions " + pos + " and " + neighbor + " are not adjacent");
    }

    private int getTileHash() {
        int hash = 0;
        for (int i = 0; i < 6; ++i) {
            for (DuctUnit unit : this.getDuctUnits()) {
                hash = hash * 31 + (unit.isInput(i) || unit.isOutput(i) ? 1 : 0);
            }
        }
        return hash;
    }

    private int getRenderHash() {
        int prev = 0;
        for (int i = 0; i < 6; ++i) {
            BlockDuct.ConnectionType type = this.getVisualConnectionType(i);
            prev = prev * 31 + type.ordinal();
        }
        return prev;
    }

    public void setConnectionType(int i, ConnectionType type) {
        if (this.connectionTypes == null) {
            if (type == ConnectionType.NORMAL) {
                return;
            }
            this.connectionTypes = new ConnectionType[]{ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL};
            this.connectionTypes[i] = type;
        } else {
            this.connectionTypes[i] = type;
            if (type == ConnectionType.NORMAL) {
                for (ConnectionType connectionType : this.connectionTypes) {
                    if (connectionType == ConnectionType.NORMAL) continue;
                    return;
                }
                this.connectionTypes = null;
            }
        }
    }

    public ConnectionType getConnectionType(int i) {
        Attachment attachment;
        if (this.attachmentData != null && (attachment = this.attachmentData.attachments[i]) != null) {
            return attachment.allowDuctConnection() ? ConnectionType.NORMAL : (attachment.allowEnergyConnection() ? ConnectionType.ENERGY : ConnectionType.BLOCKED);
        }
        ConnectionType[] connectionTypes = this.connectionTypes;
        if (connectionTypes == null) {
            return ConnectionType.NORMAL;
        }
        return connectionTypes[i];
    }

    public boolean checkForChunkUnload() {
        LinkedList<WeakReference<Chunk>> neighborChunks = this.neighborChunks;
        if (neighborChunks == null || neighborChunks.isEmpty()) {
            return false;
        }
        for (WeakReference weakReference : neighborChunks) {
            Object chunk = weakReference.get();
            if (chunk == null || ((Chunk)chunk).field_76636_d) continue;
            neighborChunks.clear();
            this.onNeighborBlockChange();
            return true;
        }
        return false;
    }

    public void rebuildChunkCache() {
        BlockPos pos = this.func_174877_v();
        if (this.neighborChunks != null && !this.neighborChunks.isEmpty()) {
            this.neighborChunks.clear();
        }
        Chunk base = this.field_145850_b.func_175726_f(pos);
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            EnumFacing facing;
            Chunk chunk;
            boolean important = false;
            for (DuctUnit ductUnit : this.getDuctUnits()) {
                if (!ductUnit.shouldTrackChunk(i)) continue;
                important = true;
                break;
            }
            if (!important || (chunk = this.field_145850_b.func_175726_f(pos.func_177972_a(facing = EnumFacing.field_82609_l[i]))) == base) continue;
            if (this.neighborChunks == null) {
                this.neighborChunks = new LinkedList();
            }
            this.neighborChunks.add(new WeakReference<Chunk>(chunk));
        }
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            Collection<BlockPos> additionalImportantPositions = ductUnit.getAdditionalImportantPositions();
            if (additionalImportantPositions.isEmpty()) continue;
            for (BlockPos p2 : additionalImportantPositions) {
                Chunk otherChunk = this.field_145850_b.func_175726_f(p2);
                if (otherChunk == base) continue;
                if (this.neighborChunks == null) {
                    this.neighborChunks = new LinkedList();
                } else if (this.neighborChunks.stream().anyMatch(chunkWeakReference -> chunkWeakReference.get() == otherChunk)) continue;
                this.neighborChunks.add(new WeakReference<Chunk>(otherChunk));
            }
        }
        if (this.neighborChunks != null && this.neighborChunks.isEmpty()) {
            this.neighborChunks = null;
        }
    }

    public boolean addAttachment(Attachment attachment) {
        if (this.attachmentData != null && this.attachmentData.attachments[attachment.side] != null) {
            return false;
        }
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return true;
        }
        if (this.attachmentData == null) {
            this.attachmentData = new AttachmentData();
        }
        this.attachmentData.attachments[attachment.side] = attachment;
        this.callNeighborStateChange();
        this.onNeighborBlockChange();
        this.onAttachmentsChanged();
        this.callBlockUpdate();
        return true;
    }

    public boolean removeAttachment(Attachment attachment) {
        if (attachment == null || this.attachmentData == null) {
            return false;
        }
        this.attachmentData.attachments[attachment.side] = null;
        this.callNeighborStateChange();
        this.onNeighborBlockChange();
        this.onAttachmentsChanged();
        this.callBlockUpdate();
        return true;
    }

    public boolean addCover(Cover cover) {
        if (this.attachmentData != null && this.attachmentData.covers[cover.side] != null) {
            return false;
        }
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return true;
        }
        if (this.attachmentData == null) {
            this.attachmentData = new AttachmentData();
        }
        this.attachmentData.covers[cover.side] = cover;
        this.callBlockUpdate();
        return true;
    }

    public boolean removeCover(byte side) {
        if (this.attachmentData == null || this.attachmentData.covers[side] == null) {
            return false;
        }
        this.attachmentData.covers[side] = null;
        this.callBlockUpdate();
        return true;
    }

    Attachment getAttachmentSelected(EntityPlayer player) {
        if (this.attachmentData == null) {
            return null;
        }
        RayTraceResult rayTrace = RayTracer.retraceBlock((World)this.field_145850_b, (EntityPlayer)player, (BlockPos)this.func_174877_v());
        if (rayTrace == null) {
            return null;
        }
        int subHit = rayTrace.subHit;
        if (subHit >= 14 && subHit < 20) {
            return this.attachmentData.attachments[subHit - 14];
        }
        if (subHit >= 20 && subHit < 26) {
            return this.attachmentData.covers[subHit - 20];
        }
        return null;
    }

    public int getLightValue() {
        int light = 0;
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            light = Math.max(light, ductUnit.getLightValue());
        }
        return light;
    }

    public void updateLighting() {
        super.updateLighting();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readAttachmentsFromNBT(nbt);
        this.readCoversFromNBT(nbt);
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            String key = ductUnit.getToken().key;
            if (!nbt.func_150297_b(key, 10)) continue;
            ductUnit.readFromNBT(nbt.func_74775_l(key));
        }
        if (nbt.func_150297_b("Connections", 7)) {
            this.connectionTypes = new ConnectionType[6];
            byte[] connections = nbt.func_74770_j("Connections");
            boolean flag = false;
            for (int i = 0; i < 6; ++i) {
                ConnectionType connectionType = ConnectionType.values()[connections[i]];
                if (connectionType != ConnectionType.NORMAL) {
                    flag = true;
                }
                this.connectionTypes[i] = connectionType;
            }
            if (!flag) {
                this.connectionTypes = null;
            }
        }
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            TickHandler.addMultiBlockToCalculate(ductUnit);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeAttachmentsToNBT(nbt);
        this.writeCoversToNBT(nbt);
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            NBTTagCompound tag = ductUnit.saveToNBT();
            if (tag == null) continue;
            nbt.func_74782_a(ductUnit.getToken().key, (NBTBase)tag);
        }
        if (this.connectionTypes != null) {
            byte[] connections = new byte[6];
            for (int i = 0; i < 6; ++i) {
                connections[i] = (byte)this.connectionTypes[i].ordinal();
            }
            nbt.func_74773_a("Connections", connections);
        }
        return nbt;
    }

    public void readAttachmentsFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Attachments", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Attachment attachment;
            NBTTagCompound tag = list.func_150305_b(i);
            byte side = tag.func_74771_c("side");
            if (this.attachmentData == null) {
                this.attachmentData = new AttachmentData();
            }
            int id = tag.func_74762_e("id");
            this.attachmentData.attachments[side] = attachment = AttachmentRegistry.createAttachment(this, side, id);
            attachment.readFromNBT(tag);
        }
    }

    public void writeAttachmentsToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        if (this.attachmentData != null) {
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                Attachment attachment = this.attachmentData.attachments[i];
                if (attachment == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("side", i);
                tag.func_74768_a("id", (int)((byte)attachment.getId()));
                attachment.writeToNBT(tag);
                list.func_74742_a((NBTBase)tag);
            }
        }
        nbt.func_74782_a("Attachments", (NBTBase)list);
    }

    public void readCoversFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Covers", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            byte side = tag.func_74771_c("side");
            if (this.attachmentData == null) {
                this.attachmentData = new AttachmentData();
            }
            this.attachmentData.covers[side] = new Cover(this, side);
            this.attachmentData.covers[side].readFromNBT(tag);
        }
    }

    public void writeCoversToNBT(NBTTagCompound nbt) {
        if (this.attachmentData == null) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (this.attachmentData.covers[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("side", i);
            this.attachmentData.covers[i].writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Covers", (NBTBase)list);
    }

    public PacketCoFHBase getTilePacket() {
        int i;
        int i2;
        PacketCoFHBase payload = super.getTilePacket();
        for (int i3 = 0; i3 < 6; ++i3) {
            payload.addByte(this.getVisualConnectionType(i3).ordinal());
        }
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            ductUnit.writeToTilePacket(payload);
        }
        if (this.attachmentData == null) {
            payload.addByte(0);
            payload.addByte(0);
            return payload;
        }
        int attachmentMask = 0;
        for (i2 = 0; i2 < 6; i2 = (int)((byte)(i2 + 1))) {
            if (this.attachmentData.attachments[i2] == null) continue;
            attachmentMask |= 1 << i2;
        }
        payload.addByte(attachmentMask);
        for (i2 = 0; i2 < 6; i2 = (int)((byte)(i2 + 1))) {
            if (this.attachmentData.attachments[i2] == null) continue;
            payload.addByte(this.attachmentData.attachments[i2].getId());
            this.attachmentData.attachments[i2].addDescriptionToPacket(payload);
        }
        int coverMask = 0;
        for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (this.attachmentData.covers[i] == null) continue;
            coverMask |= 1 << i;
        }
        payload.addByte(coverMask);
        for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (this.attachmentData.covers[i] == null) continue;
            this.attachmentData.covers[i].addDescriptionToPacket(payload);
        }
        return payload;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        if (this.clientConnections == null) {
            this.clientConnections = new BlockDuct.ConnectionType[6];
        }
        for (int i = 0; i < 6; ++i) {
            BlockDuct.ConnectionType connectionType;
            this.clientConnections[i] = connectionType = BlockDuct.ConnectionType.values()[payload.getByte()];
        }
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            ductUnit.handleTilePacket(payload);
        }
        byte attachmentMask = payload.getByte();
        for (byte i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            if ((attachmentMask & 1 << i) != 0) {
                if (this.attachmentData == null) {
                    this.attachmentData = new AttachmentData();
                }
                byte id = payload.getByte();
                this.attachmentData.attachments[i] = AttachmentRegistry.createAttachment(this, i, id);
                this.attachmentData.attachments[i].getDescriptionFromPacket(payload);
                continue;
            }
            if (this.attachmentData == null) continue;
            this.attachmentData.attachments[i] = null;
        }
        byte coverMask = payload.getByte();
        for (byte i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            if ((coverMask & 1 << i) != 0) {
                if (this.attachmentData == null) {
                    this.attachmentData = new AttachmentData();
                }
                this.attachmentData.covers[i] = new Cover(this, i);
                this.attachmentData.covers[i].getDescriptionFromPacket(payload);
                continue;
            }
            if (this.attachmentData == null) continue;
            this.attachmentData.covers[i] = null;
        }
        if (coverMask == 0 && attachmentMask == 0) {
            this.attachmentData = null;
        }
        this.callBlockUpdate();
    }

    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        Attachment attachment = this.getAttachmentSelected(player);
        if (attachment instanceof IPortableData) {
            ((IPortableData)attachment).readPortableData(player, tag);
        }
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        Attachment attachment = this.getAttachmentSelected(player);
        if (attachment instanceof IPortableData) {
            ((IPortableData)attachment).writePortableData(player, tag);
        }
    }

    @Nullable
    public Attachment getAttachment(int side) {
        AttachmentData attachmentData = this.attachmentData;
        if (attachmentData == null) {
            return null;
        }
        return attachmentData.attachments[side];
    }

    @SideOnly(value=Side.CLIENT)
    public CoverHoleRender.ITransformer[] getHollowMask(byte side) {
        BlockDuct.ConnectionType connectionType = this.getVisualConnectionType(side);
        if (connectionType == BlockDuct.ConnectionType.TILE_CONNECTION) {
            return CoverHoleRender.hollowDuctTile;
        }
        if (connectionType == BlockDuct.ConnectionType.NONE) {
            return null;
        }
        return CoverHoleRender.hollowDuct;
    }

    @Nonnull
    public BlockDuct.ConnectionType getVisualConnectionType(int side) {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            if (this.clientConnections == null) {
                return BlockDuct.ConnectionType.NONE;
            }
            return this.clientConnections[side];
        }
        Attachment attachment = this.getAttachment(side);
        if (attachment != null) {
            return attachment.getNeighborType();
        }
        BlockDuct.ConnectionType connectionType = BlockDuct.ConnectionType.NONE;
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            BlockDuct.ConnectionType ductType = ductUnit.getRenderConnectionType(side);
            connectionType = BlockDuct.ConnectionType.getPriority(connectionType, ductType);
        }
        return connectionType;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    public abstract Duct getDuctType();

    @Nullable
    public Cover getCover(int side) {
        if (this.attachmentData == null) {
            return null;
        }
        return this.attachmentData.covers[side];
    }

    public int x() {
        return this.func_174877_v().func_177958_n();
    }

    public int y() {
        return this.func_174877_v().func_177956_o();
    }

    public int z() {
        return this.func_174877_v().func_177952_p();
    }

    public World world() {
        return this.func_145831_w();
    }

    public boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public boolean openGui(EntityPlayer player) {
        Attachment attachment;
        RayTraceResult movingObjectPosition = RayTracer.retrace((EntityPlayer)player);
        if (movingObjectPosition == null) {
            return false;
        }
        int subHit = movingObjectPosition.subHit;
        if (subHit > 13 && subHit < 20 && (attachment = this.getAttachment(subHit - 14)) != null) {
            return attachment.openGui(player);
        }
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            if (!ductUnit.openGui(player)) continue;
            return true;
        }
        return false;
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        if (!this.getDuctType().isLargeTube()) {
            this.addTraceableCuboids(cuboids, selection, subSelection);
        } else {
            this.addTraceableCuboids(cuboids, selectionlarge, subSelection_large);
        }
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids, Cuboid6 centerSelection, Cuboid6[] subSelection) {
        block5: for (int i = 0; i < 6; ++i) {
            Cover cover;
            BlockDuct.ConnectionType renderConnectionType = this.getVisualConnectionType(i);
            Attachment attachment = this.getAttachment(i);
            if (attachment != null) {
                cuboids.add(new IndexedCuboid6((Object)(i + 14), attachment.getCuboid()));
                if (renderConnectionType != BlockDuct.ConnectionType.NONE) {
                    cuboids.add(new IndexedCuboid6((Object)(i + 14), subSelection[i + 6].copy()));
                }
            }
            if ((cover = this.getCover(i)) != null) {
                cuboids.add(new IndexedCuboid6((Object)(i + 20), cover.getCuboid()));
            }
            switch (renderConnectionType) {
                case TILE_CONNECTION: {
                    cuboids.add(new IndexedCuboid6((Object)i, subSelection[i].copy()));
                    continue block5;
                }
                case DUCT: 
                case CLEAN_DUCT: {
                    cuboids.add(new IndexedCuboid6((Object)(i + 6), subSelection[i + 6].copy()));
                    continue block5;
                }
                case STRUCTURE_CONNECTION: 
                case STRUCTURE_CLEAN: {
                    cuboids.add(new IndexedCuboid6((Object)i, subSelection[i + 6].copy()));
                }
            }
        }
        cuboids.add(new IndexedCuboid6((Object)13, centerSelection.copy()));
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        RayTraceResult rayTrace = RayTracer.retraceBlock((World)this.field_145850_b, (EntityPlayer)player, (BlockPos)this.func_174877_v());
        if (WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)rayTrace)) {
            if (rayTrace == null) {
                return false;
            }
            int subHit = rayTrace.subHit;
            if (subHit >= 0 && subHit <= 13) {
                int i = subHit == 13 ? side.ordinal() : (subHit < 6 ? subHit : subHit - 6);
                this.onNeighborBlockChange();
                for (DuctUnit ductUnit : this.getDuctUnits()) {
                    if (!ductUnit.onWrench(player, i, rayTrace)) continue;
                    this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), false);
                    for (DuctUnit ductUnit2 : this.getDuctUnits()) {
                        if (ductUnit2.grid == null) continue;
                        ((MultiBlockGrid)ductUnit2.grid).destroyAndRecreate();
                    }
                    this.callBlockUpdate();
                    return true;
                }
                this.setConnectionType((byte)i, this.getConnectionType(i).next());
                TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)i);
                if (tile instanceof TileGrid) {
                    ((TileGrid)tile).setConnectionType((byte)(i ^ 1), this.getConnectionType(i));
                }
                for (DuctUnit ductUnit : this.getDuctUnits()) {
                    if (ductUnit.grid == null) continue;
                    ((MultiBlockGrid)ductUnit.grid).destroyAndRecreate();
                }
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), false);
                this.callBlockUpdate();
                return true;
            }
            if (subHit > 13 && subHit < 20) {
                return this.getAttachment(subHit - 14).onWrenched();
            }
            if (subHit >= 20 && subHit < 26) {
                return this.getCover(subHit - 20).onWrenched();
            }
        }
        return false;
    }

    public void handleTileInfoPacket(PacketCoFHBase payload, boolean isServer, EntityPlayer thePlayer) {
        byte b = payload.getByte();
        if (b == 0) {
            byte t = payload.getByte();
            DuctToken token = DuctToken.TOKENS[t];
            DuctUnit duct = (DuctUnit)Validate.notNull((Object)this.getDuct(token));
            duct.handleInfoPacket(payload, isServer, thePlayer);
        } else if (b >= 1 && b <= 6) {
            ((Attachment)Validate.notNull((Object)this.getAttachment(b - 1))).handleInfoPacket(payload, isServer, thePlayer);
        }
    }

    public boolean shouldRenderCustomHitBox(int subHit, EntityPlayer thePlayer) {
        return subHit == 13 || subHit > 5 && subHit < 13 && !WrenchHelper.isHoldingUsableWrench((EntityPlayer)thePlayer, (RayTraceResult)RayTracer.retrace((EntityPlayer)thePlayer));
    }

    public CustomHitBox getCustomHitBox(int subHit, EntityPlayer thePlayer) {
        double v1 = this.getDuctType().isLargeTube() ? 0.075 : 0.3;
        double v = 1.0 - v1 * 2.0;
        CustomHitBox hb = new CustomHitBox(v, v, v, (double)this.field_174879_c.func_177958_n() + v1, (double)this.field_174879_c.func_177956_o() + v1, (double)this.field_174879_c.func_177952_p() + v1);
        for (int i = 0; i < 6; ++i) {
            BlockDuct.ConnectionType renderConnectionType = this.getVisualConnectionType(i);
            if (renderConnectionType == BlockDuct.ConnectionType.DUCT) {
                hb.drawSide(i, true);
                hb.setSideLength(i, v1);
                continue;
            }
            if (renderConnectionType == BlockDuct.ConnectionType.NONE) continue;
            hb.drawSide(i, true);
            hb.setSideLength(i, 0.04);
        }
        return hb;
    }

    public void onPlacedBy(EntityLivingBase living, ItemStack stack) {
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            ductUnit.onPlaced(living, stack);
        }
        if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            for (DuctUnit ductUnit : this.getDuctUnits()) {
                TickHandler.addMultiBlockToCalculate(ductUnit);
            }
        }
    }

    public void randomDisplayTick() {
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            ductUnit.randomDisplayTick();
        }
    }

    public ItemStack getDrop() {
        ItemStack stack = new ItemStack(this.func_145838_q(), 1, this.func_145832_p());
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            stack = ductUnit.addNBTToItemStackDrop(stack);
        }
        return stack;
    }

    public void dropAdditional(ArrayList<ItemStack> ret) {
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            ductUnit.dropAdditional(ret);
        }
    }

    public TextureAtlasSprite getBaseIcon() {
        return this.getDuctType().iconBaseTexture;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            Object object = ductUnit.getGuiClient(inventory);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            Object object = ductUnit.getGuiServer(inventory);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Object getConfigGuiServer(InventoryPlayer inventory) {
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            Object object = ductUnit.getConfigGuiServer(inventory);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Object getConfigGuiClient(InventoryPlayer inventory) {
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            Object object = ductUnit.getConfigGuiClient(inventory);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public int getType() {
        return this.getDuctType().type;
    }

    public String getTileName() {
        return this.getDuctType().unlocalizedName;
    }

    public int getEnergyStored(EnumFacing from) {
        return ((DuctUnitEnergy)Validate.notNull((Object)this.getDuct(DuctToken.ENERGY))).getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return ((DuctUnitEnergy)Validate.notNull((Object)this.getDuct(DuctToken.ENERGY))).getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return from != null && this.getVisualConnectionType(from.ordinal()).renderDuct();
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return ((DuctUnitEnergy)Validate.notNull((Object)this.getDuct(DuctToken.ENERGY))).receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return ((DuctUnitEnergy)Validate.notNull((Object)this.getDuct(DuctToken.ENERGY))).extractEnergy(maxExtract, simulate);
    }

    public void getTileInfo(List<ITextComponent> info, EnumFacing side, EntityPlayer player, boolean debug) {
        for (DuctUnit ductUnit : this.getDuctUnits()) {
            int i;
            StringBuilder builder;
            info.add((ITextComponent)new TextComponentString(ductUnit.toString()));
            Object grid = ductUnit.getGrid();
            if (grid != null) {
                info.add((ITextComponent)new TextComponentTranslation("info.thermaldynamics.info.duct", new Object[0]));
                if (!debug) {
                    // empty if block
                }
                ((MultiBlockGrid)grid).addInfo(info, player, true);
            } else {
                info.add((ITextComponent)new TextComponentString("No Grid"));
            }
            if (this.connectionTypes != null) {
                builder = new StringBuilder("  Con={");
                for (i = 0; i < 6; ++i) {
                    builder.append(this.getConnectionType(i).name().substring(0, 1));
                }
                info.add((ITextComponent)new TextComponentString(builder.toString()));
            }
            builder = new StringBuilder("  Vis={");
            for (i = 0; i < 6; ++i) {
                builder.append(this.getVisualConnectionType(i).name().substring(0, 1));
            }
            info.add((ITextComponent)new TextComponentString(builder.append("}").toString()));
            builder = new StringBuilder("  Tiles={");
            for (i = 0; i < 6; ++i) {
                if (ductUnit.tileCache[i] == null) continue;
                builder.append(i).append("=").append(ductUnit.tileCache[i]).append(",");
            }
            info.add((ITextComponent)new TextComponentString(builder.append("}").toString()));
            builder = new StringBuilder("  Ducts={");
            for (i = 0; i < 6; ++i) {
                if (ductUnit.ductCache[i] == null) continue;
                builder.append(i).append("=").append(ductUnit.ductCache[i]).append(",");
            }
            info.add((ITextComponent)new TextComponentString(builder.append("}").toString()));
            builder = new StringBuilder("  Attach={");
            if (this.attachmentData != null) {
                for (i = 0; i < 6; ++i) {
                    Attachment attachment = this.attachmentData.attachments[i];
                    if (attachment == null) continue;
                    builder.append(i).append("=").append(attachment.getId()).append(",");
                }
            }
            info.add((ITextComponent)new TextComponentString(builder.append("}").toString()));
        }
        Attachment attachment = this.getAttachmentSelected(player);
        if (attachment != null) {
            info.add((ITextComponent)new TextComponentTranslation("info.thermaldynamics.info.attachment", new Object[0]));
            int v = info.size();
            attachment.addInfo(info, player, debug);
            if (info.size() == v) {
                info.remove(v - 1);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing != null && this.getVisualConnectionType(facing.ordinal()).renderDuct()) {
            for (DuctUnit ductUnit : this.getDuctUnits()) {
                if (!ductUnit.hasCapability(capability, facing)) continue;
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && this.getVisualConnectionType(facing.ordinal()).renderDuct()) {
            for (DuctUnit ductUnit : this.getDuctUnits()) {
                T cap;
                if (!ductUnit.hasCapability(capability, facing) || (cap = ductUnit.getCapability(capability, facing)) == null) continue;
                return (T)capability.cast(cap);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    static {
        subSelection_large = new Cuboid6[12];
        TileGrid.genSelectionBoxes(subSelection, 0, 0.25, 0.2, 0.8);
        TileGrid.genSelectionBoxes(subSelection, 6, 0.3, 0.3, 0.7);
        selection = new Cuboid6(0.3, 0.3, 0.3, 0.7, 0.7, 0.7);
        TileGrid.genSelectionBoxes(subSelection_large, 0, 0.1, 0.1, 0.9);
        TileGrid.genSelectionBoxes(subSelection_large, 6, 0.1, 0.1, 0.9);
        selectionlarge = new Cuboid6(0.1, 0.1, 0.1, 0.9, 0.9, 0.9);
        GameRegistry.registerTileEntity(TileGrid.class, (String)"thermaldynamics:duct");
    }

    public static class AttachmentData {
        public final Attachment[] attachments = new Attachment[6];
        public final Cover[] covers = new Cover[6];
    }
}

