/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.tiles;

import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.DuctItem;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.energy.DuctUnitEnergy;
import cofh.thermaldynamics.duct.energy.DuctUnitEnergyStorage;
import cofh.thermaldynamics.duct.energy.GridEnergy;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.DuctUnitItemEnder;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGridStructureBase;

public class TileDuctItem
extends TileGridStructureBase {
    public static final int NODE_TRANSFER = 4000;

    public TileDuctItem() {
    }

    public TileDuctItem(Duct duct) {
        this.addDuctUnits(DuctToken.ITEMS, new DuctUnitItem(this, duct));
    }

    @Override
    protected DuctToken getPrimaryDuctToken() {
        return DuctToken.ITEMS;
    }

    public static class Warp
    extends TileDuctItem
    implements IEnergyReceiver {
        public Warp(DuctItem duct) {
            DuctUnitEnergyStorage energyStorage = new DuctUnitEnergyStorage(this, duct, 400, 1000){

                @Override
                public boolean canConnectToOtherDuct(DuctUnit<DuctUnitEnergy, GridEnergy, IEnergyReceiver> adjDuct, byte side, byte oppositeSide) {
                    return super.canConnectToOtherDuct(adjDuct, side, oppositeSide);
                }
            };
            this.addDuctUnits(DuctToken.ENERGY, energyStorage);
            this.addDuctUnits(DuctToken.ITEMS, new DuctUnitItemEnder(this, duct, energyStorage));
        }

        public static class Opaque
        extends Warp {
            public Opaque() {
                super(TDDucts.itemEnderOpaque);
            }
        }

        public static class Transparent
        extends Warp {
            public Transparent() {
                super(TDDucts.itemEnder);
            }
        }
    }

    public static class EnergyFast
    extends TileDuctItem
    implements IEnergyReceiver {
        public EnergyFast(Duct duct) {
            super(duct);
            this.addDuctUnits(DuctToken.ENERGY, new DuctUnitEnergy(this, duct, 4000, 20000));
        }

        public static class Opaque
        extends EnergyFast {
            public Opaque() {
                super(TDDucts.itemEnergyFastOpaque);
            }
        }

        public static class Transparent
        extends EnergyFast {
            public Transparent() {
                super(TDDucts.itemEnergyFast);
            }
        }
    }

    public static class Energy
    extends TileDuctItem
    implements IEnergyReceiver {
        public Energy(Duct duct) {
            super(duct);
            this.addDuctUnits(DuctToken.ENERGY, new DuctUnitEnergy(this, duct, 4000, 20000));
        }

        public static class Opaque
        extends Energy {
            public Opaque() {
                super(TDDucts.itemEnergyOpaque);
            }
        }

        public static class Transparent
        extends Energy {
            public Transparent() {
                super(TDDucts.itemEnergy);
            }
        }
    }

    public static class Fast
    extends TileDuctItem {
        public Fast(Duct duct) {
            super(duct);
        }

        public static class Opaque
        extends Fast {
            public Opaque() {
                super(TDDucts.itemFastOpaque);
            }
        }

        public static class Transparent
        extends Fast {
            public Transparent() {
                super(TDDucts.itemFast);
            }
        }
    }

    public static class Basic
    extends TileDuctItem {
        public Basic(Duct duct) {
            super(duct);
        }

        public static class Opaque
        extends Basic {
            public Opaque() {
                super(TDDucts.itemBasicOpaque);
            }
        }

        public static class Transparent
        extends Basic {
            public Transparent() {
                super(TDDucts.itemBasic);
            }
        }
    }
}

