/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.tiles;

import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.energy.DuctUnitEnergy;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGridStructureBase;

public class TileDuctEnergy
extends TileGridStructureBase
implements IEnergyReceiver {
    public TileDuctEnergy(Duct duct) {
        this.addDuctUnits(DuctToken.ENERGY, new DuctUnitEnergy(this, duct));
    }

    @Override
    protected DuctToken getPrimaryDuctToken() {
        return DuctToken.ENERGY;
    }

    public static class Resonant
    extends TileDuctEnergy {
        public Resonant() {
            super(TDDucts.energyResonant);
        }
    }

    public static class Signalum
    extends TileDuctEnergy {
        public Signalum() {
            super(TDDucts.energySignalum);
        }
    }

    public static class Hardened
    extends TileDuctEnergy {
        public Hardened() {
            super(TDDucts.energyHardened);
        }
    }

    public static class Reinforced
    extends TileDuctEnergy {
        public Reinforced() {
            super(TDDucts.energyReinforced);
        }
    }

    public static class Basic
    extends TileDuctEnergy {
        public Basic() {
            super(TDDucts.energyBasic);
        }
    }
}

