/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.servo;

import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.InventoryHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.RouteInfo;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import cofh.thermaldynamics.util.ListWrapper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ServoItem
extends ServoBase {
    public static int[] range = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public static int[] maxSize = new int[]{8, 16, 32, 64, 64};
    public static boolean[] multiStack = new boolean[]{false, false, false, true, true};
    public static int[] tickDelays = new int[]{60, 40, 20, 10, 10};
    public static byte[] speedBoost = new byte[]{1, 1, 1, 2, 3};
    public RouteCache<DuctUnitItem, GridItem> cache = null;
    public ListWrapper<Route<DuctUnitItem, GridItem>> routeList = new ListWrapper();
    public LinkedList<ItemStack> stuffedItems = new LinkedList();
    public DuctUnitItem itemDuct;

    public ServoItem(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        this.itemDuct = (DuctUnitItem)tile.getDuct(DuctToken.ITEMS);
    }

    public ServoItem(TileGrid tile, byte side) {
        super(tile, side);
        this.itemDuct = (DuctUnitItem)tile.getDuct(DuctToken.ITEMS);
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.stuffedItems.clear();
        if (tag.func_150297_b("StuffedInv", 9)) {
            NBTTagList tlist = tag.func_150295_c("StuffedInv", 10);
            for (int j = 0; j < tlist.func_74745_c(); ++j) {
                ItemStack item = ItemHelper.readItemStackFromNBT((NBTTagCompound)tlist.func_150305_b(j));
                if (item.func_190926_b()) continue;
                this.stuffedItems.add(item);
            }
        }
        this.stuffed = this.isStuffed();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.isStuffed()) {
            NBTTagList list = new NBTTagList();
            for (ItemStack item : this.stuffedItems) {
                NBTTagCompound newTag = new NBTTagCompound();
                ItemHelper.writeItemStackToNBT((ItemStack)item, (NBTTagCompound)newTag);
                list.func_74742_a((NBTBase)newTag);
            }
            tag.func_74782_a("StuffedInv", (NBTBase)list);
        }
    }

    @Override
    public boolean canStuff() {
        return true;
    }

    @Override
    public void stuffItem(ItemStack item) {
        for (ItemStack stuffed : this.stuffedItems) {
            if (!ItemHelper.itemsEqualWithMetadata((ItemStack)item, (ItemStack)stuffed, (boolean)true)) continue;
            stuffed.func_190917_f(item.func_190916_E());
            if (stuffed.func_190916_E() < 0) {
                stuffed.func_190920_e(Integer.MAX_VALUE);
            }
            return;
        }
        this.stuffedItems.add(item.func_77946_l());
        this.onNeighborChange();
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        if (this.isStuffed()) {
            block0: for (ItemStack stuffedItem : this.stuffedItems) {
                ItemStack stack = stuffedItem.func_77946_l();
                while (stack.func_190916_E() > 0 && drops.size() <= 30) {
                    if (stack.func_190916_E() <= stuffedItem.func_77976_d()) {
                        drops.add(ItemHelper.cloneStack((ItemStack)stack));
                        continue block0;
                    }
                    drops.add(stack.func_77979_a(stuffedItem.func_77976_d()));
                }
            }
        }
        return drops;
    }

    public int tickDelay() {
        return tickDelays[this.type];
    }

    @Override
    public boolean onWrenched() {
        if (this.isStuffed()) {
            for (ItemStack stack : this.stuffedItems) {
                while (stack.func_190916_E() > 0) {
                    this.dropItemStack(stack.func_77979_a(Math.min(stack.func_190916_E(), stack.func_77976_d())));
                }
            }
            this.stuffedItems.clear();
            this.onNeighborChange();
            return true;
        }
        return super.onWrenched();
    }

    @Override
    public void tick(int pass) {
        if (pass == 0) {
            if (this.isPowered && (this.isValidInput || this.isStuffed()) && this.itemDuct.world().func_82737_E() % (long)this.tickDelay() == 0L) {
                GridItem.toTick.add(this);
            }
            return;
        }
        if (!this.isPowered || this.itemDuct.world().func_82737_E() % (long)this.tickDelay() != 0L) {
            return;
        }
        if (!this.verifyCache()) {
            return;
        }
        if (this.cache.outputRoutes.isEmpty()) {
            return;
        }
        if (pass == 1) {
            if (this.isStuffed()) {
                this.handleStuffedItems();
            } else if (this.stuffed) {
                this.onNeighborChange();
            }
        } else if (pass == 2 && !this.stuffed) {
            if (!this.isValidInput) {
                return;
            }
            this.handleItemSending();
        }
    }

    public boolean verifyCache() {
        if (this.itemDuct.getGrid() == null) {
            return false;
        }
        RouteCache<DuctUnitItem, GridItem> cache1 = this.itemDuct.getCache(false);
        if (!cache1.isFinishedGenerating()) {
            return false;
        }
        if (cache1 != this.cache || this.routeList.type != this.getSortType()) {
            this.cache = cache1;
            this.routeList.setList(this.cache.outputRoutes, this.getSortType());
        }
        return true;
    }

    public void handleItemSending() {
        if (this.getCachedInv() != EmptyHandler.INSTANCE) {
            for (int slot = 0; slot < this.getCachedInv().getSlots(); ++slot) {
                TravelingItem travelingItem;
                ItemStack itemStack = this.getCachedInv().getStackInSlot(slot);
                if (itemStack.func_190926_b() || (itemStack = this.limitOutput(itemStack.func_77946_l(), this.getCachedInv(), slot, this.side)).func_190926_b() || itemStack.func_190916_E() == 0 || !this.filter.matchesFilter(itemStack) || (travelingItem = this.getRouteForItem(itemStack)) == null) continue;
                int totalSendSize = travelingItem.stack.func_190916_E();
                travelingItem.stack = this.getCachedInv().extractItem(slot, travelingItem.stack.func_190916_E(), false);
                if (travelingItem.stack.func_190926_b() || travelingItem.stack.func_190916_E() <= 0) continue;
                if (multiStack[this.type] && travelingItem.stack.func_190916_E() < totalSendSize) {
                    ++slot;
                    while (slot < this.getCachedInv().getSlots() && travelingItem.stack.func_190916_E() < totalSendSize) {
                        itemStack = this.getCachedInv().getStackInSlot(slot);
                        if (ItemHelper.itemsEqualWithMetadata((ItemStack)travelingItem.stack, (ItemStack)itemStack, (boolean)true) && !(itemStack = this.getCachedInv().extractItem(slot, totalSendSize - travelingItem.stack.func_190916_E(), false)).func_190926_b()) {
                            travelingItem.stack.func_190917_f(itemStack.func_190916_E());
                        }
                        ++slot;
                    }
                }
                this.itemDuct.insertNewItem(travelingItem);
                return;
            }
        }
    }

    public void handleStuffedItems() {
        Iterator iterator = this.stuffedItems.iterator();
        while (iterator.hasNext()) {
            ItemStack stuffedItem = (ItemStack)iterator.next();
            ItemStack send = stuffedItem.func_77946_l();
            send.func_190920_e(Math.min(send.func_190916_E(), send.func_77976_d()));
            TravelingItem travelingItem = this.getRouteForItem(send);
            if (travelingItem == null) continue;
            stuffedItem.func_190918_g(travelingItem.stack.func_190916_E());
            if (stuffedItem.func_190916_E() <= 0) {
                iterator.remove();
            }
            this.itemDuct.insertNewItem(travelingItem);
            return;
        }
    }

    public byte getSpeed() {
        return speedBoost[this.type];
    }

    public static TravelingItem findRouteForItem(ItemStack item, Iterable<Route<DuctUnitItem, GridItem>> routes, DuctUnitItem duct, int side, int maxRange, byte speed) {
        if (item.func_190926_b() || item.func_190916_E() == 0) {
            return null;
        }
        if ((item = item.func_77946_l()).func_190916_E() == 0) {
            return null;
        }
        for (Route<DuctUnitItem, GridItem> outputRoute : routes) {
            int stackSize;
            if (outputRoute.pathDirections.size() > maxRange) continue;
            RouteInfo routeInfo = outputRoute.endPoint.canRouteItem(item);
            if (!routeInfo.canRoute || (stackSize = item.func_190916_E() - routeInfo.stackSize) <= 0) continue;
            Route itemRoute = outputRoute.copy();
            itemRoute.pathDirections.add(routeInfo.side);
            item.func_190918_g(routeInfo.stackSize);
            return new TravelingItem(item, duct, itemRoute, (byte)(side ^ 1), speed);
        }
        return null;
    }

    public int getMaxRange() {
        return range[this.type];
    }

    public ItemStack limitOutput(ItemStack itemStack, IItemHandler cachedInv, int slot, byte side) {
        itemStack.func_190920_e(Math.min(itemStack.func_190916_E(), this.filter.getLevel(0)));
        return itemStack;
    }

    @Override
    public void onNeighborChange() {
        if (this.stuffed != this.isStuffed()) {
            this.stuffed = this.isStuffed();
            BlockHelper.callBlockUpdate((World)this.baseTile.func_145831_w(), (BlockPos)this.baseTile.func_174877_v());
        }
        super.onNeighborChange();
    }

    @Override
    public DuctToken tickUnit() {
        return DuctToken.ITEMS;
    }

    @Override
    public boolean isStuffed() {
        return !this.stuffedItems.isEmpty();
    }

    @Override
    public boolean isValidTile(TileEntity tile) {
        return tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
    }

    @Override
    public void clearCache() {
        this.myTile = null;
    }

    @Override
    public void cacheTile(TileEntity tile) {
        this.myTile = tile;
    }

    public ItemStack insertItem(ItemStack item, boolean simulate) {
        if (!this.filter.matchesFilter(item)) {
            return item;
        }
        ItemStack sending = this.limitOutput(item.func_77946_l(), null, -1, (byte)0);
        TravelingItem routeForItem = this.getRouteForItem(sending);
        if (routeForItem == null) {
            return item;
        }
        if (!simulate) {
            this.itemDuct.insertNewItem(routeForItem);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)(item.func_190916_E() - routeForItem.stack.func_190916_E()));
    }

    public TravelingItem getRouteForItem(ItemStack item) {
        if (!this.verifyCache()) {
            return null;
        }
        return ServoItem.findRouteForItem(item, this.routeList, this.itemDuct, this.side, this.getMaxRange(), this.getSpeed());
    }

    public ListWrapper.SortType getSortType() {
        int level = this.filter.getLevel(1);
        return ListWrapper.SortType.values()[level];
    }

    @Override
    public FilterLogic createFilterLogic() {
        return new FilterLogic(this.type, Duct.Type.ITEM, this);
    }

    public IItemHandler getCachedInv() {
        if (this.myTile == null) {
            return EmptyHandler.INSTANCE;
        }
        IItemHandler handler = InventoryHelper.getItemHandlerCap((TileEntity)this.myTile, (EnumFacing)EnumFacing.field_82609_l[this.side ^ 1]);
        return handler == null ? EmptyHandler.INSTANCE : handler;
    }
}

