/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.servo;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.init.TDItems;
import cofh.thermaldynamics.init.TDTextures;
import cofh.thermaldynamics.render.RenderDuct;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ServoBase
extends ConnectionBase {
    public static final String[] NAMES = new String[]{"basic", "hardened", "reinforced", "signalum", "resonant"};
    static boolean[] redstoneControl = new boolean[]{true, true, true, true, true};
    protected TileEntity myTile;

    public static void initialize() {
        String category = "Attachment.Servo.";
        for (int i = 0; i < NAMES.length; ++i) {
            ServoBase.redstoneControl[i] = ThermalDynamics.CONFIG.get(category + StringHelper.titleCase((String)NAMES[i]), "RedstoneControl", redstoneControl[i]);
        }
    }

    public static boolean canAlterRS(int type) {
        return redstoneControl[type % redstoneControl.length];
    }

    public ServoBase(TileGrid tile, byte side) {
        super(tile, side);
    }

    public ServoBase(TileGrid tile, byte side, int type) {
        super(tile, side, type);
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.servo." + this.type + ".name";
    }

    @Override
    public boolean allowDuctConnection() {
        return false;
    }

    @Override
    public boolean canAlterRS() {
        return ServoBase.canAlterRS(this.type);
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)TDItems.itemServo, 1, this.type);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.isPowered = tag.func_74767_n("power");
        if (this.canAlterRS()) {
            this.rsMode = IRedstoneControl.ControlMode.values()[tag.func_74771_c("rsMode")];
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("power", this.isPowered);
        if (this.canAlterRS()) {
            tag.func_74774_a("rsMode", (byte)this.rsMode.ordinal());
        }
    }

    @Override
    public void addDescriptionToPacket(PacketCoFHBase packet) {
        super.addDescriptionToPacket(packet);
        packet.addBool(this.isPowered);
        if (this.canAlterRS()) {
            packet.addByte(this.rsMode.ordinal());
        }
    }

    @Override
    public void getDescriptionFromPacket(PacketCoFHBase packet) {
        super.getDescriptionFromPacket(packet);
        this.isPowered = packet.getBool();
        if (this.canAlterRS()) {
            this.rsMode = IRedstoneControl.ControlMode.values()[packet.getByte()];
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        IconTransformation iconTrans = new IconTransformation(TDTextures.SERVO_BASE[this.stuffed ? 1 : 0][this.type]);
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, iconTrans});
        return true;
    }

    @Override
    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        tag.func_74778_a("DisplayType", "item.thermaldynamics.servo.0.name");
    }
}

