/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.retriever;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.FluidTankGrid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.init.TDItems;
import cofh.thermaldynamics.init.TDTextures;
import cofh.thermaldynamics.render.RenderDuct;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RetrieverFluid
extends ServoFluid {
    public RetrieverFluid(TileGrid tile, byte side) {
        super(tile, side);
    }

    public RetrieverFluid(TileGrid tile, byte side, int type) {
        super(tile, side, type);
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    public void tick(int pass) {
        GridFluid grid = (GridFluid)this.fluidDuct.getGrid();
        if (pass != 1 || grid == null || !this.isPowered || !this.isValidInput) {
            return;
        }
        FluidTankGrid ductGridTank = grid.myTank;
        int maxInput = (int)Math.ceil((float)ductGridTank.fluidThroughput * throttle[this.type]);
        if (ductGridTank.getFluid() != null && !this.fluidPassesFiltering(ductGridTank.getFluid())) {
            return;
        }
        Iterator iterator = grid.nodeSet.iterator();
        while (iterator.hasNext() && maxInput > 0) {
            DuctUnitFluid fluidDuct = (DuctUnitFluid)iterator.next();
            for (int k = 0; k < 6 && maxInput > 0; ++k) {
                GridFluid otherGrid;
                FluidStack fluid;
                int input;
                IFluidHandler handler;
                Attachment attachment;
                int i = (k + fluidDuct.internalSideCounter) % 6;
                DuctUnitFluid.Cache cache = ((DuctUnitFluid.Cache[])fluidDuct.tileCache)[i];
                if (cache == null || !fluidDuct.isOutput(i) && !fluidDuct.isInput(i) || (attachment = fluidDuct.parent.getAttachment(this.side)) != null && attachment.getId() == this.getId() || (handler = cache.getHandler(this.side ^ 1)) == null || (input = ductGridTank.fill(handler.drain(maxInput, false), false)) == 0 || (fluid = handler.drain(input, false)) == null || fluid.amount <= 0 || !this.fluidPassesFiltering(fluid) || !handler.getTankProperties()[0].canDrainFluidType(fluid)) continue;
                fluid = handler.drain(input, true);
                maxInput -= ductGridTank.fill(fluid, true);
                if (((GridFluid)this.fluidDuct.getGrid()).toDistribute <= 0 || ((GridFluid)this.fluidDuct.getGrid()).myTank.getFluid() == null || (otherGrid = (GridFluid)fluidDuct.getGrid()) == null) continue;
                this.fluidDuct.transfer(this.side, Math.min(otherGrid.myTank.getFluid().amount, otherGrid.toDistribute), false, otherGrid.myTank.getFluid(), true);
            }
        }
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)TDItems.itemRetriever, 1, this.type);
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.retriever." + this.type + ".name";
    }

    @Override
    public boolean allowDuctConnection() {
        return true;
    }

    @Override
    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TDTextures.RETRIEVER_BASE[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    @Override
    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        tag.func_74778_a("DisplayType", "item.thermaldynamics.retriever.0.name");
    }
}

