/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.render.CCQuad;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.consumer.CCRSConsumer;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.duct.attachments.cover.CoverBlockAccess;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.init.TDTextures;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;

public class CoverRenderer {
    static final int[] sideOffsets = new int[]{1, 1, 2, 2, 0, 0};
    static final float[] sideSoftBounds = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    private static final float FACADE_RENDER_OFFSET = 0.001953125f;
    private static final float FACADE_RENDER_OFFSET2 = 0.9980469f;
    private static final ThreadLocal<VertexLighterFlat> lighterFlat = ThreadLocal.withInitial(() -> new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()));
    private static final ThreadLocal<VertexLighterFlat> lighterSmooth = ThreadLocal.withInitial(() -> new VertexLighterSmoothAo(Minecraft.func_71410_x().func_184125_al()));
    public static final Cache<String, List<CCQuad>> itemQuadCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static final int[][] sides = new int[][]{{4, 5}, {0, 1}, {2, 3}};

    private static VertexLighterFlat setupLighter(CCRenderState ccrs, IBlockState state, IBlockAccess access, BlockPos pos, IBakedModel model) {
        boolean renderAO = Minecraft.func_71379_u() && state.getLightValue(access, pos) == 0 && model.func_177555_b();
        VertexLighterFlat lighter = renderAO ? lighterSmooth.get() : lighterFlat.get();
        CCRSConsumer consumer = new CCRSConsumer(ccrs);
        lighter.setParent((IVertexConsumer)consumer);
        consumer.setOffset(pos);
        return lighter;
    }

    public static boolean renderBlockQuads(VertexLighterFlat lighter, IBlockAccess access, IBlockState state, List<CCQuad> quads, BlockPos pos) {
        if (!quads.isEmpty()) {
            lighter.setWorld(access);
            lighter.setState(state);
            lighter.setBlockPos(pos);
            for (CCQuad quad : quads) {
                lighter.updateBlockInfo();
                quad.pipe((IVertexConsumer)lighter);
            }
            return true;
        }
        return false;
    }

    public static List<CCQuad> applyItemTint(List<CCQuad> quads, ItemStack stack) {
        LinkedList<CCQuad> retQuads = new LinkedList<CCQuad>();
        for (CCQuad quad : quads) {
            int colour = -1;
            if (quad.hasTint()) {
                colour = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.tintIndex);
                if (EntityRenderer.field_78517_a) {
                    colour = TextureUtil.func_177054_c((int)colour);
                }
                colour |= 0xFF000000;
            }
            CCQuad copyQuad = quad.copy();
            ColourARGB c = new ColourARGB(colour);
            for (Colour qC : copyQuad.colours) {
                qC.multiply((Colour)c);
            }
            retQuads.add(copyQuad);
        }
        return retQuads;
    }

    public static boolean renderBlockCover(CCRenderState ccrs, IBlockAccess world, BlockPos pos, int side, IBlockState state, Cuboid6 bounds, CoverHoleRender.ITransformer[] hollowCover) {
        EnumFacing face = EnumFacing.field_82609_l[side];
        CoverBlockAccess coverAccess = CoverBlockAccess.getInstance(world, pos, face, state);
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        try {
            state = state.func_185899_b((IBlockAccess)coverAccess, pos);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        IBakedModel model = dispatcher.func_184389_a(state);
        try {
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)coverAccess, pos);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        LinkedList bakedQuads = new LinkedList();
        long posRand = MathHelper.func_180186_a((Vec3i)pos);
        bakedQuads.addAll(model.func_188616_a(state, null, posRand));
        for (EnumFacing face2 : EnumFacing.field_82609_l) {
            bakedQuads.addAll(model.func_188616_a(state, face2, posRand));
        }
        List<CCQuad> quads = CCQuad.fromArray(bakedQuads);
        if (hollowCover != null) {
            quads = CoverHoleRender.holify(quads, side, hollowCover);
        }
        if (!(quads = CoverRenderer.sliceQuads(quads, side, bounds)).isEmpty()) {
            VertexLighterFlat lighter = CoverRenderer.setupLighter(ccrs, state, coverAccess, pos, model);
            return CoverRenderer.renderBlockQuads(lighter, coverAccess, state, quads, pos);
        }
        return false;
    }

    public static void renderItemCover(CCRenderState ccrs, int side, IBlockState state, Cuboid6 bounds) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        IBakedModel model = renderItem.func_184393_a(stack, null, null);
        String cacheKey = state.func_177230_c().getRegistryName() + "|" + state.func_177230_c().func_176201_c(state);
        List<CCQuad> renderQuads = (List<CCQuad>)itemQuadCache.getIfPresent((Object)cacheKey);
        if (renderQuads == null) {
            ArrayList quads = new ArrayList();
            quads.addAll(model.func_188616_a(null, null, 0L));
            for (EnumFacing face : EnumFacing.field_82609_l) {
                quads.addAll(model.func_188616_a(null, face, 0L));
            }
            renderQuads = CoverRenderer.applyItemTint(CoverRenderer.sliceQuads(CCQuad.fromArray(quads), side, bounds), stack);
            itemQuadCache.put((Object)cacheKey, renderQuads);
        }
        CCRSConsumer consumer = new CCRSConsumer(ccrs);
        consumer.setOffset(Vector3.center.copy().subtract(bounds.center()));
        for (CCQuad quad : renderQuads) {
            quad.pipe((IVertexConsumer)consumer);
        }
    }

    public static List<CCQuad> sliceQuads(List<CCQuad> quads, int side, Cuboid6 bounds) {
        float[][] quadPos = new float[4][3];
        float[] vecPos = new float[3];
        boolean[] flat = new boolean[3];
        TextureAtlasSprite icon = TDTextures.COVER_SIDE;
        int verticesPerFace = 4;
        LinkedList<CCQuad> finalQuads = new LinkedList<CCQuad>();
        for (CCQuad quad : quads) {
            int vi;
            boolean flag2 = false;
            boolean flag = false;
            for (int i = 0; i < 3; ++i) {
                flat[i] = true;
            }
            for (int v = 0; v < 4; ++v) {
                quadPos[v][0] = (float)quad.vertices[v].vec.x;
                quadPos[v][1] = (float)quad.vertices[v].vec.y;
                quadPos[v][2] = (float)quad.vertices[v].vec.z;
                flag = flag || quadPos[v][sideOffsets[side]] != sideSoftBounds[side];
                boolean bl = flag2 = flag2 || quadPos[v][sideOffsets[side]] != 1.0f - sideSoftBounds[side];
                if (v == 0) {
                    System.arraycopy(quadPos[v], 0, vecPos, 0, 3);
                    continue;
                }
                for (vi = 0; vi < 3; ++vi) {
                    flat[vi] = flat[vi] && quadPos[v][vi] == vecPos[vi];
                }
            }
            int s = -1;
            if (flag && flag2) {
                for (vi = 0; vi < 3; ++vi) {
                    if (!flat[vi]) continue;
                    if (vi != sideOffsets[side]) {
                        s = vi;
                        break;
                    }
                    flag = false;
                }
            }
            for (int k2 = 0; k2 < 4; ++k2) {
                boolean flag3 = quadPos[k2][sideOffsets[side]] != sideSoftBounds[side];
                for (int j = 0; j < 3; ++j) {
                    if (j == sideOffsets[side]) {
                        quadPos[k2][j] = CoverRenderer.clampF(quadPos[k2][j], bounds, j);
                        continue;
                    }
                    if (!flag || !flag2 || !flag3) continue;
                    quadPos[k2][j] = cofh.core.util.helpers.MathHelper.clamp((float)quadPos[k2][j], (float)0.001953125f, (float)0.9980469f);
                }
                if (s != -1) {
                    float v;
                    float u;
                    if (s == 0) {
                        u = quadPos[k2][1];
                        v = quadPos[k2][2];
                    } else if (s == 1) {
                        u = quadPos[k2][0];
                        v = quadPos[k2][2];
                    } else {
                        u = quadPos[k2][0];
                        v = quadPos[k2][1];
                    }
                    u = cofh.core.util.helpers.MathHelper.clamp((float)u, (float)0.0f, (float)1.0f) * 16.0f;
                    v = cofh.core.util.helpers.MathHelper.clamp((float)v, (float)0.0f, (float)1.0f) * 16.0f;
                    u = icon.func_94214_a((double)u);
                    v = icon.func_94207_b((double)v);
                    quad.vertices[k2].uv.set((double)u, (double)v);
                    quad.tintIndex = -1;
                }
                quad.vertices[k2].vec.set(quadPos[k2]);
            }
            finalQuads.add(quad);
        }
        return finalQuads;
    }

    private static float clampF(float x, Cuboid6 b, int j) {
        float l = (float)b.getSide(sides[j][0]);
        float u = (float)b.getSide(sides[j][1]);
        if (x < l) {
            return l - (l - x) * 0.001953125f;
        }
        if (x > u) {
            return u + (x - u) * 0.001953125f;
        }
        return x;
    }
}

