/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import codechicken.lib.render.CCQuad;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import cofh.core.util.helpers.MathHelper;
import cofh.thermaldynamics.init.TDProps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CoverHoleRender {
    public static final ITransformer[] hollowDuct = CoverHoleRender.hollowCover(0.3125f);
    public static final ITransformer[] hollowDuctLarge = CoverHoleRender.hollowCover(0.28125f);
    public static final ITransformer[] hollowDuctTile = CoverHoleRender.hollowCover(0.25f);
    public static final ITransformer[] hollowDuctCryo = CoverHoleRender.octaCover(0.125f, 0.1812f);
    public static final ITransformer[] hollowDuctTransport = CoverHoleRender.octaCover(0.5f * (1.0f - TDProps.largeInnerModelScaling), 0.1812f);

    public static List<CCQuad> holify(List<CCQuad> quads, int side, ITransformer[] transformers) {
        List<Quad> tessQuads = CoverHoleRender.loadFromQuads(quads);
        ArrayList<CCQuad> transformedQuads = new ArrayList<CCQuad>();
        for (Quad tessQuad : tessQuads) {
            transformedQuads.addAll(tessQuad.sliceStretchDraw(side, transformers));
        }
        return transformedQuads;
    }

    public static List<Quad> loadFromQuads(List<CCQuad> ccQuads) {
        ArrayList<Quad> quads = new ArrayList<Quad>();
        for (CCQuad quad : ccQuads) {
            Vertex8[] verts = new Vertex8[4];
            for (int v = 0; v < 4; ++v) {
                Vertex5 vert = quad.vertices[v];
                verts[v] = new Vertex8((float)vert.vec.x, (float)vert.vec.y, (float)vert.vec.z, (float)vert.uv.u, (float)vert.uv.v, quad.colours[v].rgba(), quad.normals[v].copy(), quad.lightMaps[v]);
            }
            quads.add(new Quad(verts, quad.copy()));
        }
        return quads;
    }

    public static ITransformer[] hollowCover(float w) {
        return new ITransformer[]{new TransformSquare(0.0f, w, 0.0f, 1.0f), new TransformSquare(1.0f - w, 1.0f, 0.0f, 1.0f), new TransformSquare(w, 1.0f - w, 0.0f, w), new TransformSquare(w, 1.0f - w, 1.0f - w, 1.0f)};
    }

    public static ITransformer[] octaCover(float w, float k) {
        return new ITransformer[]{new TransformSquare(0.0f, w, 0.0f, 1.0f), new TransformSquare(1.0f - w, 1.0f, 0.0f, 1.0f), new TransformSquare(w, 1.0f - w, 0.0f, w), new TransformSquare(w, 1.0f - w, 1.0f - w, 1.0f), new TriTransformer(w, w + 0.5f - k, false, false), new TriTransformer(w, w + 0.5f - k, false, true), new TriTransformer(w, w + 0.5f - k, true, false), new TriTransformer(w, w + 0.5f - k, true, true)};
    }

    public static ITransformer[] octaCover(float k) {
        return new ITransformer[]{new TriTransformer(0.0f, 0.5f - k, false, false), new TriTransformer(0.0f, 0.5f - k, false, true), new TriTransformer(0.0f, 0.5f - k, true, false), new TriTransformer(0.0f, 0.5f - k, true, true)};
    }

    @Deprecated
    public static class Vertex8 {
        public static final int TEX_NUM = 8;
        float x;
        float y;
        float z;
        float u;
        float v;
        int color;
        Vector3 normal;
        int brightness;

        public String toString() {
            return String.format("V8{{%s,%s,%s},{%s,%s},c=%d,n=%s,b=%d}", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.u), Float.valueOf(this.v), this.color, this.normal.toString(), this.brightness);
        }

        public Vertex8(float x, float y, float z, float u, float v, int color, Vector3 normal, int brightness) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
            this.color = color;
            this.normal = normal;
            this.brightness = brightness;
        }

        public Vertex8 copy() {
            return new Vertex8(this.x, this.y, this.z, this.u, this.v, this.color, this.normal, this.brightness);
        }

        public void draw(CCQuad quad, int i) {
            quad.vertices[i].vec.set((double)this.x, (double)this.y, (double)this.z);
            quad.vertices[i].uv.set((double)this.u, (double)this.v);
            quad.colours[i].set(this.color);
            quad.normals[i].set(this.normal);
            quad.lightMaps[i] = this.brightness;
        }

        public float[] buildTex() {
            return new float[]{this.u, this.v, this.color >> 24 & 0xFF, this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF, this.brightness & 0xFFFF, this.brightness >>> 16 & 0xFFFF};
        }

        public void reloadTex(float[] tex) {
            this.u = tex[0];
            this.v = tex[1];
            this.color = (int)MathHelper.clamp((float)tex[2], (float)0.0f, (float)255.0f) << 24 | (int)MathHelper.clamp((float)tex[3], (float)0.0f, (float)255.0f) << 16 | (int)MathHelper.clamp((float)tex[4], (float)0.0f, (float)255.0f) << 8 | (int)MathHelper.clamp((float)tex[5], (float)0.0f, (float)255.0f);
            this.brightness = (int)MathHelper.clamp((float)tex[6], (float)0.0f, (float)65535.0f) | (int)MathHelper.clamp((float)tex[7], (float)0.0f, (float)65535.0f) << 16;
        }
    }

    public static class TriTransformer
    implements ITransformer {
        float m;
        float k;
        boolean flipX;
        boolean flipY;

        public String toString() {
            return "TriTransformer{m=" + this.m + ", k=" + this.k + ", flipX=" + this.flipX + ", flipY=" + this.flipY + '}';
        }

        public TriTransformer(float m, float k, boolean flipX, boolean flipY) {
            this.m = m;
            this.k = k;
            this.flipX = flipX;
            this.flipY = flipY;
        }

        @Override
        public boolean shouldTransform(float dx, float dy) {
            if (this.flipX) {
                dx = 1.0f - dx;
            }
            if (this.flipY) {
                dy = 1.0f - dy;
            }
            return dx < this.m || dy < this.m || dx + dy > this.k;
        }

        @Override
        public float transformX(float dx, float dy) {
            if (this.flipX) {
                dx = 1.0f - dx;
            }
            if (dx < this.m) {
                return this.flipX ? 1.0f - this.m : this.m;
            }
            if (this.flipY) {
                dy = 1.0f - dy;
            }
            if (dy < this.m) {
                float d = MathHelper.clamp((float)dx, (float)this.m, (float)(this.k - this.m));
                return this.flipX ? 1.0f - d : d;
            }
            float d = this.k * dx / (dx + dy);
            return this.flipX ? 1.0f - d : d;
        }

        @Override
        public float transformY(float dx, float dy) {
            if (this.flipY) {
                dy = 1.0f - dy;
            }
            if (dy < this.m) {
                return this.flipY ? 1.0f - this.m : this.m;
            }
            if (this.flipX) {
                dx = 1.0f - dx;
            }
            if (dx < this.m) {
                float d = MathHelper.clamp((float)dy, (float)this.m, (float)(this.k - this.m));
                return this.flipY ? 1.0f - d : d;
            }
            float d = this.k * dy / (dy + dx);
            return this.flipY ? 1.0f - d : d;
        }
    }

    public static class TransformSquare
    implements ITransformer {
        float x0;
        float x1;
        float y0;
        float y1;

        public TransformSquare(float x0, float x1, float y0, float y1) {
            this.x0 = x0;
            this.x1 = x1;
            this.y0 = y0;
            this.y1 = y1;
        }

        @Override
        public boolean shouldTransform(float dx, float dy) {
            return dx < this.x0 || dx > this.x1 || dy < this.y0 || dy > this.y1;
        }

        @Override
        public float transformX(float dx, float dy) {
            return MathHelper.clamp((float)dx, (float)this.x0, (float)this.x1);
        }

        @Override
        public float transformY(float dx, float dy) {
            return MathHelper.clamp((float)dy, (float)this.y0, (float)this.y1);
        }

        public String toString() {
            return "TransformSquare{x0=" + this.x0 + ", x1=" + this.x1 + ", y0=" + this.y0 + ", y1=" + this.y1 + '}';
        }
    }

    public static interface ITransformer {
        public boolean shouldTransform(float var1, float var2);

        public float transformX(float var1, float var2);

        public float transformY(float var1, float var2);
    }

    public static class Quad {
        Vertex8[] verts;
        CCQuad originalQuad;

        public Quad(Vertex8[] verts, CCQuad quad) {
            this.originalQuad = quad;
            this.verts = verts;
        }

        public List<CCQuad> sliceStretchDraw(int side, ITransformer[] transformers) {
            float[][] uvTransform = this.getUVTransform(this.verts, side);
            ArrayList<CCQuad> quads = new ArrayList<CCQuad>();
            if (uvTransform == null) {
                quads.add(this.draw());
                return quads;
            }
            for (ITransformer transformer : transformers) {
                Quad slice = this.slice(side, transformer, uvTransform);
                if (!slice.notEmpty()) continue;
                quads.add(slice.draw());
            }
            return quads;
        }

        private boolean notEmpty() {
            Vertex8 a = this.verts[0];
            int f = 0;
            boolean flagX = true;
            boolean flagY = true;
            boolean flagZ = true;
            for (int i = 1; i < 4; ++i) {
                Vertex8 b = this.verts[i];
                if (flagX && Math.abs(a.x - b.x) > 1.0E-4f) {
                    flagX = false;
                    f = (byte)(f + 1);
                }
                if (flagY && Math.abs(a.y - b.y) > 1.0E-4f) {
                    flagY = false;
                    f = (byte)(f + 1);
                }
                if (flagZ && Math.abs(a.z - b.z) > 1.0E-4f) {
                    flagZ = false;
                    f = (byte)(f + 1);
                }
                if (f <= true) continue;
                return true;
            }
            return false;
        }

        public Quad slice(int side, ITransformer transformer, float[][] uvTransform) {
            Vertex8[] v = new Vertex8[this.verts.length];
            int s = side >> 1;
            for (int i = 0; i < this.verts.length; ++i) {
                float dy;
                float dx;
                Vertex8 copy = this.verts[i].copy();
                if (s == 0) {
                    dx = copy.x;
                    dy = copy.z;
                } else if (s == 1) {
                    dx = copy.x;
                    dy = copy.y;
                } else {
                    dx = copy.z;
                    dy = copy.y;
                }
                if (transformer.shouldTransform(dx, dy)) {
                    float dx2 = transformer.transformX(dx, dy);
                    float dy2 = transformer.transformY(dx, dy);
                    if (s == 0) {
                        copy.x = dx2;
                        copy.z = dy2;
                    } else if (s == 1) {
                        copy.x = dx2;
                        copy.y = dy2;
                    } else {
                        copy.z = dx2;
                        copy.y = dy2;
                    }
                    if (uvTransform != null) {
                        float[] newTex = new float[8];
                        for (int j = 0; j < 8; ++j) {
                            newTex[j] = uvTransform[0][j] + uvTransform[1][j] * dx2 + uvTransform[2][j] * dy2;
                        }
                        copy.reloadTex(newTex);
                    }
                }
                v[i] = copy;
            }
            return new Quad(v, this.originalQuad.copy());
        }

        public CCQuad draw() {
            CCQuad quad = this.originalQuad.copy();
            for (int i = 0; i < this.verts.length; ++i) {
                Vertex8 vertex = this.verts[i];
                vertex.draw(quad, i);
            }
            return quad;
        }

        public float[][] getUVTransform(Vertex8[] quads, int side) {
            int s = side >> 1;
            float n = 0.0f;
            float sx = 0.0f;
            float sy = 0.0f;
            float sxy = 0.0f;
            float sxx = 0.0f;
            float syy = 0.0f;
            float[][] XY = new float[3][8];
            for (Vertex8 vertex : quads) {
                float dy;
                float dx;
                n += 1.0f;
                if (s == 0) {
                    dx = vertex.x;
                    dy = vertex.z;
                } else if (s == 1) {
                    dx = vertex.x;
                    dy = vertex.y;
                } else {
                    dx = vertex.z;
                    dy = vertex.y;
                }
                sx += dx;
                sy += dy;
                sxy += dx * dy;
                syy += dy * dy;
                sxx += dx * dx;
                float[] tex = vertex.buildTex();
                for (int j = 0; j < tex.length; ++j) {
                    float[] fArray = XY[0];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + tex[j];
                    float[] fArray2 = XY[1];
                    int n3 = j;
                    fArray2[n3] = fArray2[n3] + tex[j] * dx;
                    float[] fArray3 = XY[2];
                    int n4 = j;
                    fArray3[n4] = fArray3[n4] + tex[j] * dy;
                }
            }
            float v = sxx * syy - sxy * sxy;
            float determinant = n * v - (sxx * sy * sy + syy * sx * sx) + 2.0f * (sxy * sx * sy);
            if (Math.abs(determinant) <= 1.0E-4f) {
                return null;
            }
            determinant = 1.0f / determinant;
            float cy_xy = (sxy * sy - syy * sx) * determinant;
            float cx_xy = (sxy * sx - sxx * sy) * determinant;
            float cx_y = (sx * sy - sxy * n) * determinant;
            float[][] XXI = new float[][]{{v * determinant, cy_xy, cx_xy}, {cy_xy, (syy * n - sy * sy) * determinant, cx_y}, {cx_xy, cx_y, (sxx * n - sx * sx) * determinant}};
            float[][] beta = new float[3][8];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 8; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        float[] fArray = beta[i];
                        int n5 = j;
                        fArray[n5] = fArray[n5] + XXI[i][k] * XY[k][j];
                    }
                }
            }
            return beta;
        }

        public String toString() {
            return String.format("Quad{%s}", Arrays.toString(this.verts));
        }
    }
}

