/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import cofh.core.render.IBlockAppearance;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CoverBlockAccess
implements IBlockAccess {
    IBlockAccess world;
    public static ThreadLocal<CoverBlockAccess> instances = ThreadLocal.withInitial(CoverBlockAccess::new);
    public BlockPos pos;
    public EnumFacing side;
    IBlockState state;

    public static CoverBlockAccess getInstance(IBlockAccess world, BlockPos pos, EnumFacing side, IBlockState state) {
        CoverBlockAccess instance = instances.get();
        instance.world = world;
        instance.pos = pos;
        instance.side = side;
        instance.state = state;
        return instance;
    }

    public Result getAction(BlockPos pos) {
        if (this.pos == pos) {
            return Result.BASE;
        }
        if (pos == this.pos.func_177972_a(this.side)) {
            return Result.ORIGINAL;
        }
        if (this.side == EnumFacing.DOWN && pos.func_177956_o() > this.pos.func_177956_o() || this.side == EnumFacing.UP && pos.func_177956_o() < this.pos.func_177956_o() || this.side == EnumFacing.NORTH && pos.func_177952_p() > this.pos.func_177952_p() || this.side == EnumFacing.SOUTH && pos.func_177952_p() < this.pos.func_177952_p() || this.side == EnumFacing.WEST && pos.func_177958_n() > this.pos.func_177958_n() || this.side == EnumFacing.EAST && pos.func_177958_n() < this.pos.func_177958_n()) {
            return Result.AIR;
        }
        IBlockState worldState = this.world.func_180495_p(pos);
        Block worldBlock = worldState.func_177230_c();
        if (worldBlock instanceof IBlockAppearance) {
            IBlockAppearance blockAppearance = (IBlockAppearance)worldBlock;
            if (blockAppearance.supportsVisualConnections()) {
                return Result.COVER;
            }
            if (blockAppearance.getVisualState(this.world, pos, this.side).equals(this.state)) {
                return this.state.func_185915_l() ? Result.BEDROCK : Result.AIR;
            }
            return Result.COVER;
        }
        if (worldState.equals(this.state)) {
            return this.state.func_185915_l() ? Result.BEDROCK : Result.AIR;
        }
        return Result.ORIGINAL;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        Result action = this.getAction(pos);
        return action == Result.ORIGINAL ? this.world.func_180495_p(pos) : (action == Result.AIR ? Blocks.field_150350_a.func_176223_P() : (action == Result.BEDROCK ? Blocks.field_150357_h.func_176223_P() : (action == Result.COVER ? ((IBlockAppearance)this.world.func_180495_p(pos).func_177230_c()).getVisualState(this.world, pos, this.side) : this.state)));
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.getAction(pos) == Result.ORIGINAL ? this.world.func_175625_s(pos) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(BlockPos pos, int t) {
        if (this.side == EnumFacing.DOWN && pos.func_177956_o() > this.pos.func_177956_o() || this.side == EnumFacing.UP && pos.func_177956_o() < this.pos.func_177956_o() || this.side == EnumFacing.NORTH && pos.func_177952_p() > this.pos.func_177952_p() || this.side == EnumFacing.SOUTH && pos.func_177952_p() < this.pos.func_177952_p() || this.side == EnumFacing.WEST && pos.func_177958_n() > this.pos.func_177958_n() || this.side == EnumFacing.EAST && pos.func_177958_n() < this.pos.func_177958_n()) {
            return this.world.func_175626_b(this.pos, t);
        }
        return this.world.func_175626_b(pos, t);
    }

    public int func_175627_a(BlockPos pos, EnumFacing side) {
        return this.world.func_175627_a(pos, side);
    }

    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean func_175623_d(BlockPos pos) {
        Result action = this.getAction(pos);
        return action == Result.AIR || action == Result.ORIGINAL && this.world.func_175623_d(pos) || action == Result.COVER && this.func_180495_p(pos).func_177230_c().isAir(this.func_180495_p(pos), (IBlockAccess)this, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public Biome func_180494_b(BlockPos pos) {
        return this.world.func_180494_b(pos);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        if (pos.func_177958_n() < -30000000 || pos.func_177952_p() < -30000000 || pos.func_177958_n() >= 30000000 || pos.func_177952_p() >= 30000000) {
            return _default;
        }
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }

    public static enum Result {
        ORIGINAL,
        AIR,
        BASE,
        BEDROCK,
        COVER;

    }
}

