/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import codechicken.lib.texture.TextureUtils;
import cofh.thermaldynamics.duct.IDuctFactory;
import cofh.thermaldynamics.render.TextureOverlay;
import cofh.thermaldynamics.render.TextureTransparent;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class Duct
implements TextureUtils.IIconRegister,
Comparable<Duct> {
    public static final String REDSTONE_BLOCK = "thermaldynamics:blocks/duct/base/redstone_background";
    public static final String SIDE_DUCTS = "sideDucts";
    public ItemStack itemStack = ItemStack.field_190927_a;
    public TextureAtlasSprite iconBaseTexture;
    public TextureAtlasSprite iconConnectionTexture;
    public TextureAtlasSprite iconFluidTexture;
    public TextureAtlasSprite iconFrameTexture;
    public TextureAtlasSprite iconFrameBandTexture;
    public TextureAtlasSprite iconFrameFluidTexture;
    public byte frameType = 0;
    public final int id;
    public final String unlocalizedName;
    public final int pathWeight;
    public final Type ductType;
    public final IDuctFactory factory;
    public final String baseTexture;
    public final String connectionTexture;
    public final String fluidTexture;
    public final byte fluidTransparency;
    public final String frameTexture;
    public final String frameFluidTexture;
    public final byte frameFluidTransparency;
    public final boolean opaque;
    public final int type;
    public EnumRarity rarity = EnumRarity.COMMON;

    public Duct(int id, boolean opaque, int pathWeight, int type, String name, Type ductType, IDuctFactory factory, String baseTexture, String connectionTexture, String fluidTexture, int fluidTransparency, String frameTexture, String frameFluidTexture, int frameFluidTransparency) {
        this.id = id;
        this.pathWeight = pathWeight;
        this.ductType = ductType;
        this.opaque = opaque;
        this.type = type;
        this.unlocalizedName = name;
        this.factory = factory;
        this.baseTexture = baseTexture;
        this.connectionTexture = connectionTexture;
        this.fluidTexture = fluidTexture;
        this.fluidTransparency = (byte)fluidTransparency;
        this.frameTexture = frameTexture;
        this.frameFluidTexture = frameFluidTexture;
        this.frameFluidTransparency = (byte)frameFluidTransparency;
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            TextureUtils.addIconRegister((TextureUtils.IIconRegister)this);
        }
    }

    public Duct setRarity(int rarity) {
        this.rarity = EnumRarity.values()[rarity %= EnumRarity.values().length];
        return this;
    }

    public boolean isLargeTube() {
        return this.frameType == 2 || this.frameType == 4;
    }

    public void registerIcons(TextureMap ir) {
        if (this.baseTexture != null) {
            this.iconBaseTexture = TextureOverlay.generateBaseTexture(ir, this.baseTexture, this.opaque ? null : "trans", null);
        }
        if (this.connectionTexture != null) {
            this.iconConnectionTexture = TextureOverlay.generateConnectionTexture(ir, this.connectionTexture);
        }
        if (this.fluidTexture != null) {
            this.iconFluidTexture = TextureTransparent.registerTransparentIcon(ir, this.fluidTexture, this.fluidTransparency);
        }
        if (this.frameTexture != null) {
            if (this.frameTexture.endsWith("_large")) {
                this.frameType = (byte)3;
                this.iconFrameTexture = ir.func_174942_a(new ResourceLocation("thermaldynamics:blocks/duct/base/" + this.frameTexture));
            } else if (SIDE_DUCTS.equals(this.frameTexture)) {
                this.frameType = 1;
            } else {
                this.iconFrameTexture = TextureOverlay.generateFrameTexture(ir, this.frameTexture);
                this.iconFrameBandTexture = TextureOverlay.generateFrameBandTexture(ir, this.frameTexture);
                this.frameType = (byte)2;
            }
        }
        if (this.frameFluidTexture != null) {
            if (this.frameType == 0) {
                this.frameType = (byte)2;
            }
            this.iconFrameFluidTexture = TextureTransparent.registerTransparentIcon(ir, this.frameFluidTexture, this.frameFluidTransparency);
        }
    }

    @Override
    public int compareTo(@Nonnull Duct other) {
        return Integer.compare(this.id, other.id);
    }

    public TextureAtlasSprite getBaseTexture(ItemStack itemStack) {
        return this.iconBaseTexture;
    }

    public static enum Type {
        ENERGY,
        FLUID,
        ITEM,
        TRANSPORT,
        STRUCTURAL,
        CRAFTING;

    }
}

