/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.network.PacketDispatcher;
import the_fireplace.overlord.network.packets.SetSquadsMessage;
import the_fireplace.overlord.tools.SquadData;

public class Squads
implements Serializable {
    private static Squads instance = null;
    private static final String dataFileName = "overlordplayersquads.dat";
    private static File saveDir = DimensionManager.getCurrentSaveRootDirectory();
    private ArrayList<SquadData> squads = new ArrayList();

    public static Squads getInstance() {
        return instance;
    }

    @SideOnly(value=Side.CLIENT)
    public static void makeClientInstance(EntityPlayer player, ArrayList<String> squadNames) {
        if (instance == null) {
            instance = new Squads();
            Overlord.logDebug("Created a new client instance for squads. If you are not on a server, this is an issue.", new Object[0]);
        }
        if (player != null) {
            instance.setPlayerSquadNames(player.func_110124_au(), squadNames);
            Overlord.logDebug("Setting client squad names " + squadNames + " to player " + player.func_70005_c_(), new Object[0]);
        } else if (Minecraft.func_71410_x().field_71439_g != null) {
            instance.setPlayerSquadNames(Minecraft.func_71410_x().field_71439_g.func_110124_au(), squadNames);
            Overlord.logInfo("Passed player was null, setting client player squad names to " + squadNames, new Object[0]);
        } else {
            Overlord.logError("Unable to set client squads due to null client player.", new Object[0]);
        }
    }

    private Squads() {
        instance = this;
    }

    public ArrayList<SquadData> getSquads() {
        return this.squads;
    }

    public ArrayList<String> getSquadsFor(UUID player) {
        ArrayList<String> allies = new ArrayList<String>();
        for (SquadData data : this.squads) {
            if (!UUID.fromString(data.getUUID()).equals(player)) continue;
            allies = data.getSquads();
            break;
        }
        return allies;
    }

    public void setPlayerSquadNames(UUID player, ArrayList<String> names) {
        for (SquadData data : this.squads) {
            if (!data.getUUID().equals(player.toString())) continue;
            data.setSquads(names);
            Squads.save();
            return;
        }
        this.squads.add(new SquadData(player.toString(), names));
        Squads.save();
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            EntityPlayer playerMp = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_152378_a(player);
            if (playerMp != null) {
                if (!playerMp.field_70170_p.field_72995_K && playerMp instanceof EntityPlayerMP) {
                    PacketDispatcher.sendTo(new SetSquadsMessage(this.getSquadsFor(player)), (EntityPlayerMP)playerMp);
                }
            } else {
                Overlord.logError("Could not find player with UUID " + player, new Object[0]);
            }
        }
    }

    public static void save() {
        Overlord.logDebug("Squads saving...", new Object[0]);
        Squads.saveToFile();
    }

    public static void load() {
        Overlord.logDebug("Squads loading...", new Object[0]);
        Squads.readFromFile();
    }

    private static void readFromFile() {
        if (saveDir == null) {
            saveDir = DimensionManager.getCurrentSaveRootDirectory();
        }
        if (saveDir == null) {
            Overlord.logError("Could not get save directory. Either you are connected to a server or Squads will not load properly.", new Object[0]);
            instance = new Squads();
            return;
        }
        File f = new File(saveDir, dataFileName);
        if (f.exists()) {
            try {
                ObjectInputStream stream = new ObjectInputStream(new FileInputStream(f));
                instance = (Squads)stream.readObject();
                stream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                instance = new Squads();
                f.delete();
            }
        }
        if (instance == null) {
            instance = new Squads();
        }
    }

    private static void saveToFile() {
        try {
            if (saveDir == null) {
                saveDir = DimensionManager.getCurrentSaveRootDirectory();
            }
            if (saveDir == null) {
                Overlord.logError("Could not get save directory. Either you are connected to a server or Squads will not save properly.", new Object[0]);
            }
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(saveDir, dataFileName)));
            out.writeObject(instance);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

