/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.overlord.Overlord;

@SideOnly(value=Side.CLIENT)
public final class SkinTools {
    public static final File cachedir = new File(Minecraft.func_71410_x().field_71412_D, "cachedImages/skins/");
    public static final HashMap<String, BufferedImage> skins = Maps.newHashMap();
    public static final HashMap<BufferedImage, DynamicTexture> skintextures = Maps.newHashMap();
    public static final ArrayList<File> nonexistants = Lists.newArrayList();

    public static boolean cacheSkin(String username) {
        Overlord.logTrace("Attempting to cache skin for " + username, new Object[0]);
        try {
            int length;
            File file = new File(cachedir, username + ".png");
            URL url = new URL(String.format("http://skins.minecraft.net/MinecraftSkins/%s.png", username));
            InputStream is = url.openStream();
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream os = new FileOutputStream(file);
            byte[] b = new byte[2048];
            while ((length = is.read(b)) != -1) {
                ((OutputStream)os).write(b, 0, length);
            }
            is.close();
            ((OutputStream)os).close();
            BufferedImage skin = ImageIO.read(file);
            if (skin.getHeight() < 63) {
                SkinTools.convertOldSkin(file);
            }
            return true;
        }
        catch (Exception e) {
            Overlord.logWarn(e.getLocalizedMessage(), new Object[0]);
            return false;
        }
    }

    public static void convertOldSkin(File file) throws IOException {
        Overlord.logTrace("Converting " + file + " to 64x64 skin.", new Object[0]);
        BufferedImage newSkin = new BufferedImage(64, 64, 2);
        BufferedImage original = new BufferedImage(64, 32, 2);
        BufferedImage current = ImageIO.read(file);
        original.getGraphics().drawImage(current, 0, 0, 64, 32, 0, 0, 64, 32, null);
        newSkin.getGraphics().drawImage(original, 0, 0, 64, 64, 0, 0, 64, 64, null);
        BufferedImage[] skinparts = SkinTools.skinParts(current);
        newSkin.getGraphics().drawImage(skinparts[0], 0, 0, 64, 64, -32, -52, 32, 12, null);
        newSkin.getGraphics().drawImage(skinparts[1], 0, 0, 64, 64, -44, -52, 20, 12, null);
        newSkin.getGraphics().drawImage(skinparts[2], 0, 0, 64, 64, -36, -48, 28, 16, null);
        newSkin.getGraphics().drawImage(skinparts[3], 0, 0, 64, 64, -40, -48, 24, 16, null);
        newSkin.getGraphics().drawImage(skinparts[4], 0, 0, 64, 64, -16, -52, 48, 12, null);
        newSkin.getGraphics().drawImage(skinparts[5], 0, 0, 64, 64, -28, -52, 36, 12, null);
        newSkin.getGraphics().drawImage(skinparts[6], 0, 0, 64, 64, -20, -48, 44, 16, null);
        newSkin.getGraphics().drawImage(skinparts[7], 0, 0, 64, 64, -24, -48, 40, 16, null);
        ImageIO.write((RenderedImage)newSkin, "PNG", file);
    }

    public static BufferedImage[] skinParts(BufferedImage inputSkin) {
        BufferedImage arm_front = new BufferedImage(12, 12, 2);
        arm_front.getGraphics().drawImage(inputSkin, 0, 0, 12, 12, 40, 20, 52, 32, null);
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-arm_front.getWidth(null), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        arm_front = op.filter(arm_front, null);
        BufferedImage arm_back = new BufferedImage(4, 12, 2);
        arm_back.getGraphics().drawImage(inputSkin, 0, 0, 4, 12, 52, 20, 56, 32, null);
        AffineTransform txab = AffineTransform.getScaleInstance(-1.0, 1.0);
        txab.translate(-arm_back.getWidth(null), 0.0);
        AffineTransformOp opab = new AffineTransformOp(txab, 1);
        arm_back = opab.filter(arm_back, null);
        BufferedImage arm_top = new BufferedImage(4, 4, 2);
        arm_top.getGraphics().drawImage(inputSkin, 0, 0, 4, 4, 44, 16, 48, 20, null);
        AffineTransform txat = AffineTransform.getScaleInstance(-1.0, 1.0);
        txat.translate(-arm_top.getWidth(null), 0.0);
        AffineTransformOp opat = new AffineTransformOp(txat, 1);
        arm_top = opat.filter(arm_top, null);
        BufferedImage arm_bottom = new BufferedImage(4, 4, 2);
        arm_bottom.getGraphics().drawImage(inputSkin, 0, 0, 4, 4, 48, 16, 52, 20, null);
        arm_bottom = opat.filter(arm_bottom, null);
        BufferedImage leg_front = new BufferedImage(12, 12, 2);
        leg_front.getGraphics().drawImage(inputSkin, 0, 0, 12, 12, 0, 20, 12, 32, null);
        leg_front = op.filter(leg_front, null);
        BufferedImage leg_back = new BufferedImage(4, 12, 2);
        leg_back.getGraphics().drawImage(inputSkin, 0, 0, 4, 12, 12, 20, 16, 32, null);
        leg_back = opab.filter(leg_back, null);
        BufferedImage leg_top = new BufferedImage(4, 4, 2);
        leg_top.getGraphics().drawImage(inputSkin, 0, 0, 4, 4, 4, 16, 8, 20, null);
        leg_top = opat.filter(leg_top, null);
        BufferedImage leg_bottom = new BufferedImage(4, 4, 2);
        leg_bottom.getGraphics().drawImage(inputSkin, 0, 0, 4, 4, 8, 16, 12, 20, null);
        leg_bottom = opab.filter(leg_bottom, null);
        return new BufferedImage[]{arm_front, arm_back, arm_top, arm_bottom, leg_front, leg_back, leg_top, leg_bottom};
    }
}

