/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraftforge.common.DimensionManager;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.tools.Alliance;
import the_fireplace.overlord.tools.StringPair;

@MethodsReturnNonnullByDefault
public class Enemies
implements Serializable {
    private static Enemies instance = null;
    private static final String dataFileName = "overlordenemies.dat";
    private static File saveDir = DimensionManager.getCurrentSaveRootDirectory();
    private ArrayList<Alliance> enemies = new ArrayList();

    public static Enemies getInstance() {
        return instance;
    }

    private Enemies() {
        instance = this;
    }

    public ArrayList<Alliance> getEnemies() {
        return this.enemies;
    }

    public boolean isNotEnemiesWith(UUID uuid1, UUID uuid2) {
        for (Alliance playerPair : this.enemies) {
            if ((!UUID.fromString(playerPair.getUser1().getUUID()).equals(uuid1) || !UUID.fromString(playerPair.getUser2().getUUID()).equals(uuid2)) && (!UUID.fromString(playerPair.getUser1().getUUID()).equals(uuid2) || !UUID.fromString(playerPair.getUser2().getUUID()).equals(uuid1))) continue;
            return false;
        }
        return true;
    }

    public boolean considersPlayerEnemy(UUID main, UUID other) {
        for (Alliance playerPair : this.enemies) {
            if (!UUID.fromString(playerPair.getUser1().getUUID()).equals(main) || !UUID.fromString(playerPair.getUser2().getUUID()).equals(other)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<StringPair> getAllEnemies(UUID player) {
        ArrayList<StringPair> enemies = new ArrayList<StringPair>();
        for (Alliance playerPair : this.enemies) {
            if (UUID.fromString(playerPair.getUser1().getUUID()).equals(player)) {
                enemies.add(playerPair.getUser2());
                continue;
            }
            if (!UUID.fromString(playerPair.getUser2().getUUID()).equals(player)) continue;
            enemies.add(playerPair.getUser1());
        }
        return enemies;
    }

    public ArrayList<StringPair> getMyEnemies(UUID player) {
        ArrayList enemies = this.enemies.stream().filter(playerPair -> UUID.fromString(playerPair.getUser1().getUUID()).equals(player)).map(Alliance::getUser2).collect(Collectors.toCollection(ArrayList::new));
        return enemies;
    }

    public ArrayList<StringPair> getWhoEnemied(UUID player) {
        ArrayList enemies = this.enemies.stream().filter(playerPair -> UUID.fromString(playerPair.getUser2().getUUID()).equals(player)).map(Alliance::getUser1).collect(Collectors.toCollection(ArrayList::new));
        return enemies;
    }

    public void addEnemies(Alliance playerPair) {
        for (Alliance pair1 : this.enemies) {
            if (!pair1.equals(playerPair)) continue;
            return;
        }
        this.enemies.add(playerPair);
        Enemies.save();
    }

    public void removeEnemies(Alliance playerPair) {
        for (int i = 0; i < this.enemies.size(); ++i) {
            if (!this.enemies.get(i).equals(playerPair)) continue;
            this.enemies.remove(i);
        }
        Enemies.save();
    }

    public static void save() {
        Overlord.logDebug("Enemies saving...", new Object[0]);
        Enemies.saveToFile();
    }

    public static void load() {
        Overlord.logDebug("Enemies loading...", new Object[0]);
        Enemies.readFromFile();
    }

    private static void readFromFile() {
        if (saveDir == null) {
            saveDir = DimensionManager.getCurrentSaveRootDirectory();
        }
        if (saveDir == null) {
            Overlord.logError("Could not get save directory. Enemies will not load properly.", new Object[0]);
            instance = new Enemies();
            return;
        }
        File f = new File(saveDir, dataFileName);
        if (f.exists()) {
            try {
                ObjectInputStream stream = new ObjectInputStream(new FileInputStream(f));
                instance = (Enemies)stream.readObject();
                stream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                instance = new Enemies();
                f.delete();
            }
        }
        if (instance == null) {
            instance = new Enemies();
        }
    }

    private static void saveToFile() {
        try {
            if (saveDir == null) {
                saveDir = DimensionManager.getCurrentSaveRootDirectory();
            }
            if (saveDir == null) {
                Overlord.logError("Could not get save directory. Enemies will not save properly.", new Object[0]);
                return;
            }
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(saveDir, dataFileName)));
            out.writeObject(instance);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

