/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraftforge.common.DimensionManager;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.tools.Alliance;
import the_fireplace.overlord.tools.StringPair;

@MethodsReturnNonnullByDefault
public class Alliances
implements Serializable {
    private static Alliances instance = null;
    private static final String dataFileName = "overlordalliances.dat";
    private static File saveDir = DimensionManager.getCurrentSaveRootDirectory();
    private ArrayList<Alliance> alliances = new ArrayList();

    public static Alliances getInstance() {
        return instance;
    }

    private Alliances() {
        instance = this;
    }

    public ArrayList<Alliance> getAlliances() {
        return this.alliances;
    }

    public boolean isAlliedTo(UUID uuid1, UUID uuid2) {
        for (Alliance alliance : this.alliances) {
            if ((!UUID.fromString(alliance.getUser1().getUUID()).equals(uuid1) || !UUID.fromString(alliance.getUser2().getUUID()).equals(uuid2)) && (!UUID.fromString(alliance.getUser1().getUUID()).equals(uuid2) || !UUID.fromString(alliance.getUser2().getUUID()).equals(uuid1))) continue;
            return true;
        }
        return false;
    }

    public ArrayList<StringPair> getAllies(UUID player) {
        ArrayList<StringPair> allies = new ArrayList<StringPair>();
        for (Alliance alliance : this.alliances) {
            if (UUID.fromString(alliance.getUser1().getUUID()).equals(player)) {
                allies.add(alliance.getUser2());
                continue;
            }
            if (!UUID.fromString(alliance.getUser2().getUUID()).equals(player)) continue;
            allies.add(alliance.getUser1());
        }
        return allies;
    }

    public void addAlliance(Alliance alliance) {
        for (Alliance alliance1 : this.alliances) {
            if (!alliance1.equals(alliance)) continue;
            return;
        }
        this.alliances.add(alliance);
        Alliances.save();
    }

    public void removeAlliance(Alliance alliance) {
        for (int i = 0; i < this.alliances.size(); ++i) {
            if (!this.alliances.get(i).equals(alliance)) continue;
            this.alliances.remove(i);
        }
        Alliances.save();
    }

    public static void save() {
        Overlord.logDebug("Alliances saving...", new Object[0]);
        Alliances.saveToFile();
    }

    public static void load() {
        Overlord.logDebug("Alliances loading...", new Object[0]);
        Alliances.readFromFile();
    }

    private static void readFromFile() {
        if (saveDir == null) {
            saveDir = DimensionManager.getCurrentSaveRootDirectory();
        }
        if (saveDir == null) {
            Overlord.logError("Could not get save directory. Alliances will not load properly.", new Object[0]);
            instance = new Alliances();
            return;
        }
        File f = new File(saveDir, dataFileName);
        if (f.exists()) {
            try {
                ObjectInputStream stream = new ObjectInputStream(new FileInputStream(f));
                instance = (Alliances)stream.readObject();
                stream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                instance = new Alliances();
                f.delete();
            }
        }
        if (instance == null) {
            instance = new Alliances();
        }
    }

    private static void saveToFile() {
        try {
            if (saveDir == null) {
                saveDir = DimensionManager.getCurrentSaveRootDirectory();
            }
            if (saveDir == null) {
                Overlord.logError("Could not get save directory. Alliances will not save properly.", new Object[0]);
            }
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(saveDir, dataFileName)));
            out.writeObject(instance);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

