/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.tileentity;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.config.ConfigValues;
import the_fireplace.overlord.entity.EntityBabySkeleton;
import the_fireplace.overlord.items.ItemOverlordsSeal;
import the_fireplace.overlord.registry.MilkRegistry;
import the_fireplace.overlord.tileentity.ISkeletonMaker;
import the_fireplace.overlord.tools.SkinType;

public class TileEntityBabySkeletonMaker
extends TileEntity
implements ISidedInventory,
ISkeletonMaker {
    private ItemStack[] inventory;
    public static final int[] clearslots = new int[]{4, 5, 6, 7, 8, 9};
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileEntityBabySkeletonMaker() {
        this.inventory = new ItemStack[10];
    }

    @Override
    public void spawnSkeleton(EntityPlayer player) {
        if (!this.canSpawnSkeleton() || this.field_145850_b.field_72995_K) {
            return;
        }
        UUID owner = null;
        if (!this.func_70301_a(0).func_190926_b() && this.func_70301_a(0).func_77978_p() != null) {
            owner = UUID.fromString(this.func_70301_a(0).func_77978_p().func_74779_i("Owner"));
            if (this.func_70301_a(0).func_77973_b() instanceof ItemOverlordsSeal && ((ItemOverlordsSeal)this.func_70301_a(0).func_77973_b()).isConsumable()) {
                this.func_70301_a(0).func_190918_g(1);
            }
        }
        EntityBabySkeleton babySkeleton = new EntityBabySkeleton(this.field_145850_b, owner);
        babySkeleton.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, 1.0f, 0.0f);
        babySkeleton.func_184201_a(EntityEquipmentSlot.HEAD, this.func_70301_a(7));
        babySkeleton.func_184201_a(EntityEquipmentSlot.CHEST, this.func_70301_a(6));
        babySkeleton.func_184201_a(EntityEquipmentSlot.LEGS, this.func_70301_a(5));
        babySkeleton.func_184201_a(EntityEquipmentSlot.FEET, this.func_70301_a(4));
        babySkeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, this.func_70301_a(8));
        this.field_145850_b.func_72838_d((Entity)babySkeleton);
        if (player != null && player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192133_m.func_192229_a((EntityPlayerMP)player, (Entity)babySkeleton);
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, Overlord.CREATE_SKELETON_SOUND, SoundCategory.BLOCKS, 1.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat());
        if (!this.func_70301_a(9).func_190926_b()) {
            babySkeleton.setSkinsuit(this.func_70301_a(9), SkinType.getSkinTypeFromStack(this.func_70301_a(9)));
        }
        for (int i : clearslots) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        if (MilkRegistry.getInstance().isMilk(this.func_70301_a(2))) {
            if (!this.func_70301_a(3).func_190926_b() && !MilkRegistry.getInstance().getEmptiedStack(this.func_70301_a(2)).func_190926_b()) {
                if (this.func_70301_a(3).func_77973_b() == MilkRegistry.getInstance().getEmptiedStack(this.func_70301_a(2)).func_77973_b() && this.func_70301_a(3).func_190916_E() < this.func_70301_a(3).func_77976_d()) {
                    this.func_70301_a(3).func_190917_f(1);
                } else {
                    babySkeleton.func_70099_a(MilkRegistry.getInstance().getEmptiedStack(this.func_70301_a(2)), 0.1f);
                }
            } else if (this.func_70301_a(3).func_190926_b()) {
                this.func_70299_a(3, MilkRegistry.getInstance().getEmptiedStack(this.func_70301_a(2)));
            }
        }
        this.func_70301_a(2).func_190918_g(1);
        if (this.func_70301_a(2).func_190926_b()) {
            this.func_70299_a(2, ItemStack.field_190927_a);
        }
        if (!this.func_70301_a(1).func_190926_b()) {
            if (this.func_70301_a(1).func_190916_E() <= ConfigValues.BONEREQ_BABY) {
                this.func_70299_a(1, ItemStack.field_190927_a);
            } else {
                this.func_70301_a(1).func_190918_g(ConfigValues.BONEREQ_BABY);
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public String func_70005_c_() {
        return Overlord.proxy.translateToLocal("tile.baby_skeleton_maker.name", new Object[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.baby_skeleton_maker.name", new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        if (this.inventory[index] != null) {
            return this.inventory[index];
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        ItemStack is = this.func_70301_a(index);
        if (!is.func_190926_b()) {
            if (is.func_190916_E() <= count) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            } else {
                is = is.func_77979_a(count);
                this.func_70296_d();
            }
        }
        return is;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack is = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return is;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.inventory[index] = stack;
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return index == 0 && stack.func_77973_b() instanceof ItemOverlordsSeal || index == 1 && stack.func_77973_b() == Items.field_151103_aS || index == 2 && (stack.func_77973_b() == Items.field_151117_aB || stack.func_77973_b() == Overlord.milk_bottle) || index > 3 && index < 8 && stack.func_77973_b().isValidArmor(stack, this.getSlotEquipmentType(index), null) || index == 9 && stack.func_77973_b() == Overlord.skinsuit;
    }

    private EntityEquipmentSlot getSlotEquipmentType(int index) {
        if (index == 4) {
            return EntityEquipmentSlot.FEET;
        }
        if (index == 5) {
            return EntityEquipmentSlot.LEGS;
        }
        if (index == 6) {
            return EntityEquipmentSlot.CHEST;
        }
        if (index == 7) {
            return EntityEquipmentSlot.HEAD;
        }
        if (index == 8) {
            return EntityEquipmentSlot.MAINHAND;
        }
        return EntityEquipmentSlot.OFFHAND;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack is = this.func_70301_a(i);
            if (is.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("SlotSkeletonMaker", (byte)i);
            is.func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("ItemsSkeletonMaker", (NBTBase)list);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList list = (NBTTagList)compound.func_74781_a("ItemsSkeletonMaker");
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound item = (NBTTagCompound)list.func_179238_g(i);
                byte slot = item.func_74771_c("SlotSkeletonMaker");
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.func_70299_a(slot, new ItemStack(item));
            }
        } else {
            Overlord.logWarn("List was null when reading TileEntityBabySkeletonMaker NBTTagCompound", new Object[0]);
        }
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == EnumFacing.EAST || side == EnumFacing.WEST || side == EnumFacing.NORTH || side == EnumFacing.SOUTH || side == EnumFacing.UP) {
            return new int[]{1, 2, 4, 5, 6, 7, 9};
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{3};
        }
        throw new IllegalArgumentException("Invalid side: " + side);
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return !stack.func_190926_b() && (index >= 1 && index < 3 || index >= 4 && index < 8 || index == 9) && this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return !stack.func_190926_b() && index == 3;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean canSpawnSkeleton() {
        return !this.func_70301_a(1).func_190926_b() && !this.func_70301_a(2).func_190926_b() && MilkRegistry.getInstance().isMilk(this.func_70301_a(2)) && this.func_70301_a(1).func_190916_E() >= ConfigValues.SERVER_BONEREQ_BABY;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

