/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.items.ItemOverlordsSeal;

public class SealRecipe
extends ShapedOreRecipe {
    private static final Field eventHandlerField = ReflectionHelper.findField(InventoryCrafting.class, (String[])new String[]{"eventHandler", "field_70465_c"});
    private static final Field containerPlayerPlayerField = ReflectionHelper.findField(ContainerPlayer.class, (String[])new String[]{"player", "field_82862_h"});
    private static final Field slotCraftingPlayerField = ReflectionHelper.findField(SlotCrafting.class, (String[])new String[]{"player", "field_75238_b"});

    public SealRecipe(ResourceLocation loc, Block result, Object ... recipe) {
        super(loc, result, recipe);
    }

    public SealRecipe(ResourceLocation loc, Item result, Object ... recipe) {
        super(loc, result, recipe);
    }

    public SealRecipe(ResourceLocation loc, @Nonnull ItemStack result, Object ... recipe) {
        super(loc, result, recipe);
    }

    public SealRecipe(ResourceLocation loc, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer recipe) {
        super(loc, result, recipe);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack output = super.func_77572_b(inv);
        EntityPlayer user = SealRecipe.findPlayer(inv);
        if (output.func_77973_b() instanceof ItemOverlordsSeal && user != null) {
            if (output.func_77978_p() == null) {
                output.func_77982_d(new NBTTagCompound());
            }
            if (!output.func_77978_p().func_74764_b("Owner")) {
                output.func_77978_p().func_74778_a("Owner", user.func_110124_au().toString());
                output.func_77978_p().func_74778_a("OwnerName", user.getDisplayNameString());
            }
        }
        return output;
    }

    @Nullable
    private static EntityPlayer findPlayer(@Nonnull InventoryCrafting inv) {
        try {
            Container container = (Container)eventHandlerField.get(inv);
            if (container instanceof ContainerPlayer) {
                return (EntityPlayer)containerPlayerPlayerField.get(container);
            }
            if (container instanceof ContainerWorkbench) {
                return (EntityPlayer)slotCraftingPlayerField.get(container.func_75139_a(0));
            }
            Overlord.logWarn("Unable to find player for crafting inventory: " + inv.func_70005_c_(), new Object[0]);
            return null;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            HashMap ingMap = Maps.newHashMap();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
            }
            ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
            JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
            if (patternJ.size() == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            String[] pattern = new String[patternJ.size()];
            for (int x = 0; x < pattern.length; ++x) {
                String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
                if (x > 0 && pattern[0].length() != line.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
                }
                pattern[x] = line;
            }
            CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
            primer.width = pattern[0].length();
            primer.height = pattern.length;
            primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
            primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
            HashSet keys = Sets.newHashSet(ingMap.keySet());
            keys.remove(Character.valueOf(' '));
            int x = 0;
            for (String line : pattern) {
                for (char chr : line.toCharArray()) {
                    Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                    if (ing == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                    }
                    primer.input.set(x++, (Object)ing);
                    keys.remove(Character.valueOf(chr));
                }
            }
            if (!keys.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new SealRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, primer);
        }
    }
}

