/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import the_fireplace.overlord.network.packets.AttackModeMessage;
import the_fireplace.overlord.network.packets.CreateSkeletonMessage;
import the_fireplace.overlord.network.packets.DebugSkeletonMessage;
import the_fireplace.overlord.network.packets.MovementModeMessage;
import the_fireplace.overlord.network.packets.RequestAugmentMessage;
import the_fireplace.overlord.network.packets.SetAugmentMessage;
import the_fireplace.overlord.network.packets.SetConfigsMessage;
import the_fireplace.overlord.network.packets.SetSquadMessage;
import the_fireplace.overlord.network.packets.SetSquadsMessage;
import the_fireplace.overlord.network.packets.UpdateArmyMessage;
import the_fireplace.overlord.network.packets.UpdateClientSquadsMessage;
import the_fireplace.overlord.network.packets.UpdateSquadsMessage;

public final class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("overlord");

    public static void registerPackets() {
        PacketDispatcher.registerMessage(CreateSkeletonMessage.Handler.class, CreateSkeletonMessage.class, Side.SERVER);
        PacketDispatcher.registerMessage(DebugSkeletonMessage.Handler.class, DebugSkeletonMessage.class, Side.SERVER);
        PacketDispatcher.registerMessage(AttackModeMessage.Handler.class, AttackModeMessage.class, Side.SERVER);
        PacketDispatcher.registerMessage(MovementModeMessage.Handler.class, MovementModeMessage.class, Side.SERVER);
        PacketDispatcher.registerMessage(UpdateArmyMessage.Handler.class, UpdateArmyMessage.class, Side.SERVER);
        PacketDispatcher.registerMessage(UpdateSquadsMessage.Handler.class, UpdateSquadsMessage.class, Side.SERVER);
        PacketDispatcher.registerMessage(UpdateClientSquadsMessage.Handler.class, UpdateClientSquadsMessage.class, Side.CLIENT);
        PacketDispatcher.registerMessage(SetSquadMessage.Handler.class, SetSquadMessage.class, Side.SERVER);
        PacketDispatcher.registerMessage(SetConfigsMessage.Handler.class, SetConfigsMessage.class, Side.CLIENT);
        PacketDispatcher.registerMessage(RequestAugmentMessage.Handler.class, RequestAugmentMessage.class, Side.SERVER);
        PacketDispatcher.registerMessage(SetAugmentMessage.Handler.class, SetAugmentMessage.class, Side.CLIENT);
        PacketDispatcher.registerMessage(SetSquadsMessage.Handler.class, SetSquadsMessage.class, Side.CLIENT);
    }

    private static void registerMessage(Class handlerClass, Class messageClass, Side side) {
        byte by = packetId;
        packetId = (byte)(by + 1);
        dispatcher.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range));
    }

    public static void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }
}

