/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.items;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.overlord.Overlord;

public class ItemOverlordsSeal
extends Item {
    private boolean canOpenGui;
    private boolean consumable;

    public ItemOverlordsSeal() {
        this(true, false);
    }

    public ItemOverlordsSeal(boolean canOpenGui, boolean consumedOnUse) {
        this.canOpenGui = canOpenGui;
        this.consumable = consumedOnUse;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("Owner")) {
            stack.func_77978_p().func_74778_a("Owner", playerIn.func_110124_au().toString());
            stack.func_77978_p().func_74778_a("OwnerName", playerIn.getDisplayNameString());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (this.canOpenGui) {
            if (stack.func_77978_p().func_74779_i("Owner").equals(playerIn.func_110124_au().toString())) {
                FMLNetworkHandler.openGui((EntityPlayer)playerIn, (Object)Overlord.instance, (int)-1, (World)worldIn, (int)((int)playerIn.field_70165_t), (int)((int)playerIn.field_70163_u), (int)((int)playerIn.field_70161_v));
                if (this.consumable) {
                    stack.func_190918_g(1);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Owner")) {
            tooltip.add(Overlord.proxy.translateToLocal(this.func_77658_a() + ".tooltip", stack.func_77978_p().func_74779_i("OwnerName"), stack.func_190916_E() > 1 ? "s" : ""));
        } else {
            tooltip.add(Overlord.proxy.translateToLocal(this.func_77658_a() + ".tooltip.default", stack.func_190916_E() > 1 ? "ese" : "is", stack.func_190916_E() > 1 ? "s" : ""));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Owner");
    }

    public boolean isConsumable() {
        return this.consumable;
    }
}

