/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.items;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.entity.EntityArmyMember;
import the_fireplace.overlord.entity.EntityBabySkeleton;
import the_fireplace.overlord.entity.EntityConvertedSkeleton;
import the_fireplace.overlord.entity.EntitySkeletonWarrior;
import the_fireplace.overlord.tools.ArmyUtils;

public class ItemKeychain
extends Item {
    private boolean isOccupied;

    public boolean getIsOccupied() {
        return this.isOccupied;
    }

    public ItemKeychain(boolean isOccupied) {
        this.isOccupied = isOccupied;
        this.func_77625_d(1);
        if (!isOccupied) {
            this.func_77637_a(Overlord.tabOverlord);
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound entNbt;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        pos = pos.func_177972_a(facing);
        double offsetY = 0.0;
        if (facing == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            offsetY = 0.5;
        }
        if ((entNbt = stack.func_77978_p()) != null) {
            EntityArmyMember entity;
            if (entNbt.func_74779_i("SkeletonType").equals("skeleton_warrior")) {
                entity = new EntitySkeletonWarrior(worldIn);
            } else if (entNbt.func_74779_i("SkeletonType").equals("skeleton_converted")) {
                entity = new EntityConvertedSkeleton(worldIn);
            } else {
                entity = new EntityBabySkeleton(worldIn);
                if (!entNbt.func_74779_i("SkeletonType").equals("skeleton_baby")) {
                    Overlord.logError("Skeleton Type for keychain was " + entNbt.func_74779_i("SkeletonType"), new Object[0]);
                }
            }
            entity.func_70020_e(entNbt);
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entity.field_70759_as = entity.field_70177_z;
            entity.field_70761_aq = entity.field_70177_z;
            worldIn.func_72838_d((Entity)entity);
            entity.func_70642_aH();
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            stack.func_190918_g(1);
            if (!playerIn.field_71071_by.func_70441_a(new ItemStack(Overlord.keychain))) {
                playerIn.func_145779_a(Overlord.keychain, 1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (this.getIsOccupied() && nbt != null) {
            NBTTagList armorInv;
            if (nbt.func_74764_b("SkinsuitName") && nbt.func_74764_b("HasSkinsuit") && nbt.func_74767_n("HasSkinsuit")) {
                tooltip.add(Overlord.proxy.translateToLocal("tooltip.skin", new Object[0]) + ' ' + (nbt.func_74779_i("SkinsuitName").isEmpty() ? "Steve" : nbt.func_74779_i("SkinsuitName")));
            }
            if (nbt.func_74764_b("SkeletonType")) {
                tooltip.add(Overlord.proxy.translateToLocal("tooltip.type", new Object[0]) + ' ' + Overlord.proxy.translateToLocal("entity." + nbt.func_74779_i("SkeletonType") + ".name", new Object[0]));
            }
            if (nbt.func_74764_b("SkeletonPowerLevel")) {
                tooltip.add(Overlord.proxy.translateToLocal("tooltip.level", new Object[0]) + ' ' + nbt.func_74762_e("SkeletonPowerLevel"));
            }
            if (nbt.func_74764_b("CustomName")) {
                tooltip.add(Overlord.proxy.translateToLocal("tooltip.name", new Object[0]) + ' ' + nbt.func_74779_i("CustomName"));
            }
            if (nbt.func_74764_b("AttackMode")) {
                tooltip.add(Overlord.proxy.translateToLocal("tooltip.attack_mode", new Object[0]) + ' ' + ArmyUtils.getAttackModeString(nbt.func_74771_c("AttackMode")));
            }
            if (nbt.func_74764_b("MovementMode")) {
                tooltip.add(Overlord.proxy.translateToLocal("tooltip.movement_mode", new Object[0]) + ' ' + ArmyUtils.getMovementModeString(nbt.func_74771_c("MovementMode")));
            }
            if (nbt.func_74764_b("Squad") && !nbt.func_74779_i("Squad").isEmpty()) {
                tooltip.add(Overlord.proxy.translateToLocal("tooltip.squad", new Object[0]) + ' ' + nbt.func_74779_i("Squad"));
            }
            if ((armorInv = (NBTTagList)nbt.func_74781_a("SkeletonEquipment")) != null && armorInv.func_74745_c() > 0) {
                tooltip.add(Overlord.proxy.translateToLocal("tooltip.equipment", new Object[0]));
                for (int i = 0; i < armorInv.func_74745_c(); ++i) {
                    NBTTagCompound item = (NBTTagCompound)armorInv.func_179238_g(i);
                    tooltip.add(new ItemStack(item).func_82833_r());
                }
            }
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (!this.getIsOccupied() && !playerIn.field_70170_p.field_72995_K && target instanceof EntityArmyMember && (((EntityArmyMember)target).func_184753_b() == null || ((EntityArmyMember)target).func_184753_b().equals(playerIn.func_110124_au())) && (target instanceof EntityBabySkeleton || target instanceof EntityConvertedSkeleton || target instanceof EntitySkeletonWarrior)) {
            ItemStack occupiedItem = new ItemStack(Overlord.keychain_occupied);
            NBTTagCompound entNbt = new NBTTagCompound();
            target.func_189511_e(entNbt);
            String entityString = EntityList.func_75621_b((Entity)target);
            if (entityString == null) {
                Overlord.logError("Entity string for " + target.toString() + " was null.", new Object[0]);
                return false;
            }
            entNbt.func_74778_a("SkeletonType", entityString);
            occupiedItem.func_77982_d(entNbt);
            if (playerIn.func_184586_b(hand).func_190916_E() > 1) {
                playerIn.func_184586_b(hand).func_190918_g(1);
            } else {
                playerIn.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
            }
            if (!playerIn.field_71071_by.func_70441_a(occupiedItem)) {
                playerIn.func_71019_a(occupiedItem, false);
            }
            target.field_70170_p.func_72900_e((Entity)target);
            return true;
        }
        return false;
    }
}

