/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.entity.ai;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import the_fireplace.overlord.entity.EntityArmyMember;

public class EntityAITargetSkins<T extends EntityLivingBase>
extends EntityAITarget {
    protected final Class<T> targetClass;
    private final int targetChance;
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super T> targetEntitySelector;
    protected T targetEntity;
    public final Predicate<EntityArmyMember> CAN_ATTACK_ARMY_MEMBER = new Predicate<EntityArmyMember>(){

        public boolean apply(@Nullable EntityArmyMember p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_.shouldMobAttack((EntityLiving)EntityAITargetSkins.this.field_75299_d);
        }
    };

    public EntityAITargetSkins(EntityCreature creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public EntityAITargetSkins(EntityCreature creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby);
    }

    public EntityAITargetSkins(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby) {
        super(creature, checkSight, onlyNearby);
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate<T>(){

            public boolean apply(@Nullable T p_apply_1_) {
                return p_apply_1_ != null && EntitySelectors.field_180132_d.apply(p_apply_1_) && EntityAITargetSkins.this.func_75296_a(p_apply_1_, false) && EntityAITargetSkins.this.CAN_ATTACK_ARMY_MEMBER.apply((Object)((EntityArmyMember)((Object)p_apply_1_)));
            }
        };
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass != EntityPlayer.class && this.targetClass != EntityPlayerMP.class) {
            List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
            if (list.isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (EntityLivingBase)list.get(0);
            return true;
        }
        this.targetEntity = this.field_75299_d.field_70170_p.func_184150_a(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, this.func_111175_f(), this.func_111175_f(), (Function)new Function<EntityPlayer, Double>(){

            @Nullable
            public Double apply(@Nullable EntityPlayer p_apply_1_) {
                ItemStack itemstack = p_apply_1_.func_184582_a(EntityEquipmentSlot.HEAD);
                if (itemstack.func_77973_b() == Items.field_151144_bL) {
                    boolean flag2;
                    int i = itemstack.func_77952_i();
                    boolean flag = EntityAITargetSkins.this.field_75299_d instanceof EntitySkeleton && i == 0;
                    boolean flag1 = EntityAITargetSkins.this.field_75299_d instanceof EntityZombie && i == 2;
                    boolean bl = flag2 = EntityAITargetSkins.this.field_75299_d instanceof EntityCreeper && i == 4;
                    if (flag || flag1 || flag2) {
                        return 0.5;
                    }
                }
                return 1.0;
            }
        }, this.targetEntitySelector);
        return this.targetEntity != null;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72321_a(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

