/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.entity.ai;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import the_fireplace.overlord.config.ConfigValues;
import the_fireplace.overlord.entity.EntityArmyMember;
import the_fireplace.overlord.tools.Alliances;
import the_fireplace.overlord.tools.Enemies;

public class EntityAINearestNonTeamTarget<T extends EntityLivingBase>
extends EntityAITarget {
    protected final Class<T> targetClass;
    private final int targetChance;
    protected final Sorter theNearestAttackableTargetSorter;
    protected final com.google.common.base.Predicate<? super T> targetEntitySelector;
    protected T targetEntity;

    public EntityAINearestNonTeamTarget(EntityCreature creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public EntityAINearestNonTeamTarget(EntityCreature creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public EntityAINearestNonTeamTarget(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.func_75248_a(1);
        this.targetEntitySelector = p_apply_1_ -> p_apply_1_ != null && (targetSelector == null || targetSelector.test(p_apply_1_)) && EntitySelectors.field_180132_d.apply(p_apply_1_) && this.func_75296_a((EntityLivingBase)p_apply_1_, false);
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass != EntityPlayer.class && this.targetClass != EntityPlayerMP.class) {
            List<T> list = EntityAINearestNonTeamTarget.getEntitiesWithinAABB(this.field_75299_d.field_70170_p, this.targetClass, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
            if (list.isEmpty()) {
                return false;
            }
            list.sort(this.theNearestAttackableTargetSorter);
            if (!((EntityArmyMember)this.field_75299_d).shouldAttackEntity((EntityLivingBase)list.get(0), ((EntityArmyMember)this.field_75299_d).getOwner())) {
                return false;
            }
            this.targetEntity = (EntityLivingBase)list.get(0);
            return true;
        }
        this.targetEntity = this.getNearestAttackablePlayer(this.field_75299_d.field_70170_p, this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, this.func_111175_f(), this.func_111175_f(), new Function<EntityPlayer, Double>(){

            @Override
            @Nullable
            public Double apply(@Nullable EntityPlayer p_apply_1_) {
                return 1.0;
            }
        }, this.targetEntitySelector);
        return this.targetEntity != null;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72321_a(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    @Nullable
    public EntityPlayer getNearestAttackablePlayer(World worldObj, double posX, double posY, double posZ, double maxXZDistance, double maxYDistance, @Nullable Function<EntityPlayer, Double> playerToDouble, @Nullable com.google.common.base.Predicate<EntityPlayer> p_184150_12_) {
        double d0 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < worldObj.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)worldObj.field_73010_i.get(i);
            if (entityplayer1.func_110124_au() == ((EntityArmyMember)this.field_75299_d).func_184753_b() || Alliances.getInstance().isAlliedTo(entityplayer1.func_110124_au(), ((EntityArmyMember)this.field_75299_d).func_184753_b()) || ((EntityArmyMember)this.field_75299_d).getAttackMode() < 2 && Enemies.getInstance().isNotEnemiesWith(((EntityArmyMember)this.field_75299_d).func_184753_b(), entityplayer1.func_110124_au()) || entityplayer1.field_71075_bZ.field_75102_a || !entityplayer1.func_70089_S() || entityplayer1.func_175149_v() || p_184150_12_ != null && !p_184150_12_.apply((Object)entityplayer1)) continue;
            double d1 = entityplayer1.func_70092_e(posX, entityplayer1.field_70163_u, posZ);
            double d2 = maxXZDistance;
            if (entityplayer1.func_70093_af()) {
                d2 = maxXZDistance * (double)0.8f;
            }
            if (entityplayer1.func_82150_aj()) {
                float f = entityplayer1.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d2 *= (double)(0.7f * f);
            }
            if (playerToDouble != null) {
                d2 *= ((Double)MoreObjects.firstNonNull((Object)playerToDouble.apply(entityplayer1), (Object)1.0)).doubleValue();
            }
            if (!(maxYDistance < 0.0) && !(Math.abs(entityplayer1.field_70163_u - posY) < maxYDistance * maxYDistance) || !(maxXZDistance < 0.0) && !(d1 < d2 * d2) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public static <T> List<T> getEntitiesWithinAABB(World world, Class<T> clazz, AxisAlignedBB aabb, com.google.common.base.Predicate<? super T> predicate) {
        List entities = world.func_72872_a(Entity.class, aabb);
        ArrayList<Entity> found = Lists.newArrayList();
        for (Entity e : entities) {
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            found.add(e);
        }
        found = new ArrayList<Entity>(Collections2.filter((Collection)found, predicate));
        return found;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            double d1 = this.theEntity.func_70068_e(p_compare_2_);
            boolean b0 = false;
            boolean b1i = true;
            if (p_compare_1_ instanceof EntityArmyMember && !(b0 = ((EntityArmyMember)p_compare_1_).func_184753_b().equals(this.theEntity.func_110124_au()))) {
                b0 = Alliances.getInstance().isAlliedTo(((EntityArmyMember)p_compare_1_).func_184753_b(), this.theEntity.func_110124_au());
            }
            if (p_compare_2_ instanceof EntityArmyMember) {
                boolean bl = b1i = !((EntityArmyMember)p_compare_2_).func_184753_b().equals(this.theEntity.func_110124_au());
                if (b1i) {
                    boolean bl2 = b1i = !Alliances.getInstance().isAlliedTo(((EntityArmyMember)p_compare_2_).func_184753_b(), this.theEntity.func_110124_au());
                }
            }
            if (!ConfigValues.HUNTCREEPERS && p_compare_1_ instanceof EntityCreeper) {
                b0 = true;
            }
            if (!ConfigValues.HUNTCREEPERS && p_compare_2_ instanceof EntityCreeper) {
                b1i = false;
            }
            if (!b0 && b1i) {
                return Double.compare(d0, d1);
            }
            if (b0 && b1i) {
                return 1;
            }
            if (!b0) {
                return -1;
            }
            return 0;
        }
    }
}

