/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.entity;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.overlord.entity.EntityConvertedSkeleton;

public class EntityCuringSkeleton
extends EntitySkeleton {
    private int conversionTime;
    private UUID owner;

    public EntityCuringSkeleton(World worldIn) {
        this(worldIn, null);
    }

    public EntityCuringSkeleton(World worldIn, @Nullable UUID owner) {
        super(worldIn);
        this.owner = owner;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ConversionTime", this.conversionTime);
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("ConversionTime", 99)) {
            this.startConverting(compound.func_74762_e("ConversionTime"));
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            int i = this.getConversionProgress();
            this.conversionTime -= i;
            if (this.conversionTime <= 0) {
                this.finishConversion();
            }
        }
        super.func_70071_h_();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void startConverting(int startingTime) {
        this.conversionTime = startingTime;
        this.func_184589_d(MobEffects.field_76437_t);
        this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, startingTime, Math.min(this.field_70170_p.func_175659_aa().func_151525_a() - 1, 0)));
        this.field_70170_p.func_72960_a((Entity)this, (byte)16);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 16) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187942_hp, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected void finishConversion() {
        EntityConvertedSkeleton entityConvertedSkeleton = new EntityConvertedSkeleton(this.field_70170_p, this.owner);
        entityConvertedSkeleton.func_82149_j((Entity)this);
        entityConvertedSkeleton.func_184611_a(EnumHand.MAIN_HAND, this.func_184614_ca());
        entityConvertedSkeleton.func_184611_a(EnumHand.OFF_HAND, this.func_184592_cb());
        entityConvertedSkeleton.func_184201_a(EntityEquipmentSlot.HEAD, this.func_184582_a(EntityEquipmentSlot.HEAD));
        entityConvertedSkeleton.func_184201_a(EntityEquipmentSlot.CHEST, this.func_184582_a(EntityEquipmentSlot.CHEST));
        entityConvertedSkeleton.func_184201_a(EntityEquipmentSlot.LEGS, this.func_184582_a(EntityEquipmentSlot.LEGS));
        entityConvertedSkeleton.func_184201_a(EntityEquipmentSlot.FEET, this.func_184582_a(EntityEquipmentSlot.FEET));
        this.field_70170_p.func_72900_e((Entity)this);
        entityConvertedSkeleton.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            entityConvertedSkeleton.func_96094_a(this.func_95999_t());
            entityConvertedSkeleton.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_72838_d((Entity)entityConvertedSkeleton);
        EntityLivingBase owner = entityConvertedSkeleton.getOwner();
        if (owner != null && owner instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192133_m.func_192229_a((EntityPlayerMP)owner, (Entity)entityConvertedSkeleton);
        }
        entityConvertedSkeleton.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
        this.field_70170_p.func_180498_a(null, 1027, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
    }

    protected int getConversionProgress() {
        int i = 1;
        if (this.field_70146_Z.nextFloat() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.field_70165_t - 4; k < (int)this.field_70165_t + 4 && j < 14; ++k) {
                for (int l = (int)this.field_70163_u - 4; l < (int)this.field_70163_u + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.field_70161_v - 4; i1 < (int)this.field_70161_v + 4 && j < 14; ++i1) {
                        Block block = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k, l, i1)).func_177230_c();
                        if (block != Blocks.field_150411_aY && block != Blocks.field_150324_C) continue;
                        if (this.field_70146_Z.nextFloat() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }
}

