/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.entity;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.advancements.CriterionRegistry;
import the_fireplace.overlord.config.ConfigValues;
import the_fireplace.overlord.entity.EntityArmyMember;
import the_fireplace.overlord.tools.ISkinsuitWearer;
import the_fireplace.overlord.tools.SkinType;

public class EntityBabySkeleton
extends EntityArmyMember
implements ISkinsuitWearer {
    private static final DataParameter<String> SKINSUIT_NAME = EntityDataManager.func_187226_a(EntityBabySkeleton.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> SKINSUIT_TYPE = EntityDataManager.func_187226_a(EntityBabySkeleton.class, (DataSerializer)DataSerializers.field_187191_a);
    public final InventoryBasic equipInventory = new InventoryBasic("Equipment", false, 5){

        public boolean func_94041_b(int index, ItemStack stack) {
            return index >= 4 || !stack.func_190926_b() && stack.func_77973_b().isValidArmor(stack, EntityEquipmentSlot.values()[index], null);
        }
    };
    boolean sally = false;
    boolean armed = false;

    public EntityBabySkeleton(World world) {
        this(world, null);
    }

    public EntityBabySkeleton(World world, @Nullable UUID owner) {
        super(world, owner);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.255);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.getOwner() != null && this.getOwner().equals((Object)player)) {
            ItemStack stack;
            if (!player.func_70093_af()) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Overlord.instance, (int)this.hashCode(), (World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v));
                return true;
            }
            if (!this.field_70170_p.field_72995_K && !(stack = player.func_184586_b(hand)).func_190926_b() && stack.func_77973_b() == Overlord.baby_spawner) {
                NBTTagCompound compound = new NBTTagCompound();
                this.func_70014_b(compound);
                stack.func_77982_d(compound);
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKINSUIT_TYPE, (Object)((byte)SkinType.NONE.ordinal()));
        this.field_70180_af.func_187214_a(SKINSUIT_NAME, (Object)String.valueOf(""));
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        SoundEvent soundevent = SoundEvents.field_187868_fj;
        this.func_184185_a(soundevent, 0.15f, 1.0f);
    }

    @Nonnull
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public void func_70636_d() {
        float f;
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_72935_r()) {
                BlockPos blockpos;
                f = this.func_70013_c();
                BlockPos blockPos = blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
                if (!this.getSkinType().protectsFromSun() && f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                    boolean flag = true;
                    ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
                    if (!itemstack.func_190926_b()) {
                        if (ConfigValues.HELMETDAMAGE && itemstack.func_77984_f()) {
                            itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                            if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                                this.func_70669_a(itemstack);
                                this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                            }
                        }
                        flag = false;
                    }
                    if (flag) {
                        this.func_70015_d(6);
                    }
                }
            }
            if (!this.func_184614_ca().func_190926_b()) {
                if (this.getOwner() != null && this.getOwner() instanceof EntityPlayerMP && !this.armed) {
                    CriterionRegistry.instance.SKELETON_STATUS_UPDATE.trigger((EntityPlayerMP)this.getOwner(), (Entity)this, Items.field_151041_m, 0);
                    this.armed = true;
                }
            } else if (this.armed) {
                this.armed = false;
            }
            if (this.getSkinType().equals(SkinType.PLAYER)) {
                if (this.getOwner() != null && this.getOwner() instanceof EntityPlayerMP && !this.sally) {
                    CriterionRegistry.instance.SKELETON_STATUS_UPDATE.trigger((EntityPlayerMP)this.getOwner(), (Entity)this, Overlord.skinsuit, 0);
                    this.sally = true;
                }
            } else if (this.sally) {
                this.sally = false;
            }
        }
        this.func_70105_a(0.3f, 0.995f);
        f = this.func_70013_c();
        if (f > 0.5f && !this.getSkinType().protectsFromSun()) {
            ++this.field_70708_bq;
        }
        super.func_70636_d();
    }

    public boolean func_70631_g_() {
        return true;
    }

    @Override
    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntityCreeper && ((EntityCreeper)cause.func_76346_g()).func_70830_n() && ((EntityCreeper)cause.func_76346_g()).func_70650_aV()) {
            ((EntityCreeper)cause.func_76346_g()).func_175493_co();
            this.func_70099_a(new ItemStack(Items.field_151144_bL), 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.equipInventory.func_70302_i_(); ++i) {
                if (this.equipInventory.func_70301_a(i).func_190926_b()) continue;
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.equipInventory.func_70301_a(i));
                entityitem.func_174869_p();
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        NBTTagList armorInv;
        super.func_70037_a(compound);
        if (compound.func_74764_b("SkinsuitName")) {
            String s = compound.func_74779_i("SkinsuitName");
            this.field_70180_af.func_187227_b(SKINSUIT_NAME, (Object)s);
        }
        if (compound.func_74764_b("HasSkinsuit")) {
            boolean b = compound.func_74767_n("HasSkinsuit");
            this.field_70180_af.func_187227_b(SKINSUIT_TYPE, (Object)((byte)(b ? 1 : 0)));
        }
        if (compound.func_74764_b("SkinsuitType")) {
            byte b = compound.func_74771_c("SkinsuitType");
            this.field_70180_af.func_187227_b(SKINSUIT_TYPE, (Object)b);
        }
        if ((armorInv = (NBTTagList)compound.func_74781_a("SkeletonEquipment")) != null) {
            for (int i = 0; i < armorInv.func_74745_c(); ++i) {
                NBTTagCompound item = (NBTTagCompound)armorInv.func_179238_g(i);
                byte slot = item.func_74771_c("SlotSkeletonEquipment");
                if (slot < 0 || slot >= this.equipInventory.func_70302_i_()) continue;
                this.equipInventory.func_70299_a((int)slot, new ItemStack(item));
            }
        } else {
            Overlord.logWarn("List was null when reading Baby Skeleton's Equipment", new Object[0]);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("SkinsuitType", ((Byte)this.field_70180_af.func_187225_a(SKINSUIT_TYPE)).byteValue());
        compound.func_74778_a("SkinsuitName", (String)this.field_70180_af.func_187225_a(SKINSUIT_NAME));
        NBTTagList armorInv = new NBTTagList();
        for (int i = 0; i < this.equipInventory.func_70302_i_(); ++i) {
            ItemStack is = this.equipInventory.func_70301_a(i);
            if (is.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("SlotSkeletonEquipment", (byte)i);
            is.func_77955_b(item);
            armorInv.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("SkeletonEquipment", (NBTBase)armorInv);
    }

    public float func_70047_e() {
        return 0.93f;
    }

    @Nonnull
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.MAINHAND ? this.equipInventory.func_70301_a(4) : (slotIn == EntityEquipmentSlot.OFFHAND ? ItemStack.field_190927_a : (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR ? this.equipInventory.func_70301_a(slotIn.func_188454_b()) : ItemStack.field_190927_a));
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, @Nonnull ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            this.func_184606_a_(stack);
            this.equipInventory.func_70299_a(4, stack);
        } else if (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            this.func_184606_a_(stack);
            this.equipInventory.func_70299_a(slotIn.func_188454_b(), stack);
        }
    }

    @Nonnull
    public Iterable<ItemStack> func_184214_aD() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.func_184614_ca()});
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return Arrays.asList(this.equipInventory.func_70301_a(0), this.equipInventory.func_70301_a(1), this.equipInventory.func_70301_a(2), this.equipInventory.func_70301_a(3));
    }

    @Nonnull
    public ItemStack func_184614_ca() {
        if (this.equipInventory == null) {
            return ItemStack.field_190927_a;
        }
        return this.equipInventory.func_70301_a(4);
    }

    @Nonnull
    public ItemStack func_184592_cb() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_184586_b(EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return this.func_184614_ca();
        }
        if (hand == EnumHand.OFF_HAND) {
            return ItemStack.field_190927_a;
        }
        throw new IllegalArgumentException("Invalid hand: " + hand);
    }

    public void func_184611_a(EnumHand hand, @Nonnull ItemStack stack) {
        if (hand == EnumHand.MAIN_HAND) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        } else if (hand != EnumHand.OFF_HAND) {
            throw new IllegalArgumentException("Invalid hand: " + hand);
        }
    }

    public float func_180484_a(BlockPos pos) {
        if (!this.getSkinType().protectsFromSun()) {
            return 0.5f - this.field_70170_p.func_175724_o(pos);
        }
        return super.func_180484_a(pos);
    }

    @Override
    public boolean shouldMobAttack(@Nonnull EntityLiving mob) {
        return this.getSkinType().equals(SkinType.PLAYER) && (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() || this.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() != Items.field_151144_bL || this.func_184582_a(EntityEquipmentSlot.HEAD).func_77960_j() == 3);
    }

    @Override
    @Nonnull
    public SkinType getSkinType() {
        return SkinType.get(((Byte)this.field_70180_af.func_187225_a(SKINSUIT_TYPE)).byteValue());
    }

    @Override
    @Nonnull
    public String getSkinName() {
        return (String)this.field_70180_af.func_187225_a(SKINSUIT_NAME);
    }

    @Override
    public void setSkinsuit(@Nonnull ItemStack stack, @Nonnull SkinType type) {
        if (type.isNone()) {
            ItemStack dropStack;
            ItemStack itemStack = dropStack = this.getSkinType().equals(SkinType.PLAYER) ? new ItemStack(Overlord.skinsuit) : new ItemStack(Overlord.skinsuit_mummy);
            if (ConfigValues.SKINSUITNAMETAGS && this.func_145818_k_() && this.func_95999_t().equals(this.getSkinName())) {
                dropStack.func_151001_c(this.getSkinName());
                this.func_96094_a("");
            }
            this.func_70099_a(dropStack, 0.1f);
        }
        this.field_70180_af.func_187227_b(SKINSUIT_TYPE, (Object)((byte)type.ordinal()));
        if (stack.func_82837_s() && !type.isNone()) {
            this.field_70180_af.func_187227_b(SKINSUIT_NAME, (Object)String.valueOf(stack.func_82833_r()));
            if (ConfigValues.SKINSUITNAMETAGS && !this.func_145818_k_()) {
                this.func_96094_a(stack.func_82833_r());
            }
        } else {
            this.field_70180_af.func_187227_b(SKINSUIT_NAME, (Object)String.valueOf(""));
        }
    }
}

