/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.entity;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.overlord.config.ConfigValues;
import the_fireplace.overlord.entity.ai.EntityAIFollowMaster;
import the_fireplace.overlord.entity.ai.EntityAIHurtByNonAllied;
import the_fireplace.overlord.entity.ai.EntityAIMasterHurtByTarget;
import the_fireplace.overlord.entity.ai.EntityAIMasterHurtTarget;
import the_fireplace.overlord.entity.ai.EntityAINearestNonTeamTarget;
import the_fireplace.overlord.entity.ai.EntityAIWanderBase;
import the_fireplace.overlord.registry.AugmentRegistry;
import the_fireplace.overlord.tools.Alliances;
import the_fireplace.overlord.tools.Augment;
import the_fireplace.overlord.tools.CustomDataSerializers;
import the_fireplace.overlord.tools.Enemies;

public abstract class EntityArmyMember
extends EntityCreature
implements IEntityOwnable {
    protected static final DataParameter<UUID> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityArmyMember.class, CustomDataSerializers.UNIQUE_ID);
    protected static final DataParameter<String> SQUAD = EntityDataManager.func_187226_a(EntityArmyMember.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Byte> ATTACK_MODE = EntityDataManager.func_187226_a(EntityArmyMember.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> MOVEMENT_MODE = EntityDataManager.func_187226_a(EntityArmyMember.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityArmyMember.class, (DataSerializer)DataSerializers.field_187198_h);
    protected EntityAIAttackMelee aiAttackOnCollide = null;
    private ItemStack augmentDisplayStack = ItemStack.field_190927_a;
    private Augment clientAugment = null;
    public boolean cachedClientAugment = false;
    protected boolean isUpdatingAI = false;
    protected int raiseArmTicks;

    public EntityArmyMember(World world, @Nullable UUID owner) {
        super(world);
        if (owner != null) {
            this.setOwnerId(owner);
        } else {
            this.setOwnerId(UUID.fromString("0b1ec5ad-cb2a-43b7-995d-889320eb2e5b"));
        }
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_110163_bv();
    }

    protected void func_184651_r() {
        if (!this.isUpdatingAI) {
            this.isUpdatingAI = true;
            this.field_70714_bg.field_75782_a.clear();
            this.func_70661_as().func_75499_g();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.addMovementTasks();
            if ((Byte)this.field_70180_af.func_187225_a(ATTACK_MODE) != 0) {
                this.addAttackTasks();
            }
            this.addTargetTasks();
            this.func_184185_a(this.func_184639_G(), this.func_70599_aP() * 2.0f, this.func_70647_i() * 1.5f);
            this.isUpdatingAI = false;
        }
    }

    public void addMovementTasks() {
        switch ((Byte)this.field_70180_af.func_187225_a(MOVEMENT_MODE)) {
            case 1: {
                if (this.shouldMobAttack((EntityLiving)new EntityCreeper(this.field_70170_p))) {
                    this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 10.0f, 1.2, 1.6));
                }
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, this.getAttackMode() != 2));
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowMaster(this, 1.0, 10.0f, 2.0f));
            }
            case 0: {
                this.func_175449_a(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), -1);
                break;
            }
            default: {
                this.func_175449_a(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), 20);
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
                if (this.shouldMobAttack((EntityLiving)new EntityCreeper(this.field_70170_p))) {
                    this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 10.0f, 1.2, 1.6));
                }
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, this.getAttackMode() != 2));
                this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderBase(this, 1.0));
            }
        }
    }

    public void addAttackTasks() {
        if (this.aiAttackOnCollide == null) {
            this.aiAttackOnCollide = new EntityAIAttackMelee(this, 1.2, false){

                public void func_75251_c() {
                    super.func_75251_c();
                    EntityArmyMember.this.setSwingingArms(false);
                }

                public void func_75249_e() {
                    super.func_75249_e();
                    EntityArmyMember.this.raiseArmTicks = 0;
                }

                public void func_75246_d() {
                    if (this.func_75253_b()) {
                        ++EntityArmyMember.this.raiseArmTicks;
                        if (EntityArmyMember.this.raiseArmTicks >= 5 && this.field_75439_d < 10) {
                            EntityArmyMember.this.setSwingingArms(true);
                        } else {
                            EntityArmyMember.this.setSwingingArms(false);
                        }
                        super.func_75246_d();
                    }
                }
            };
        }
        if ((Byte)this.field_70180_af.func_187225_a(MOVEMENT_MODE) > 0) {
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public void addTargetTasks() {
        switch ((Byte)this.field_70180_af.func_187225_a(ATTACK_MODE)) {
            case 2: {
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIMasterHurtTarget(this));
            }
            case 1: {
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIMasterHurtByTarget(this));
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByNonAllied(this, true, new Class[0]));
                this.field_70715_bh.func_75776_a(2, new EntityAINearestNonTeamTarget<EntityPlayer>(this, EntityPlayer.class, true));
                this.field_70715_bh.func_75776_a(2, new EntityAINearestNonTeamTarget<EntityArmyMember>(this, EntityArmyMember.class, true));
                this.field_70715_bh.func_75776_a(3, new EntityAINearestNonTeamTarget<IMob>(this, IMob.class, true));
                break;
            }
            default: {
                this.func_70624_b(null);
                this.func_70604_c(null);
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public void func_70636_d() {
        this.func_82168_bl();
        if (this.getAugment() != null) {
            this.getAugment().onEntityTick(this);
        }
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)UUID.fromString("0b1ec5ad-cb2a-43b7-995d-889320eb2e5b"));
        this.field_70180_af.func_187214_a(SQUAD, (Object)String.valueOf(""));
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_MODE, (Object)1);
        this.field_70180_af.func_187214_a(MOVEMENT_MODE, (Object)1);
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.getOwner() instanceof EntityPlayerMP) {
            this.getOwner().func_145747_a(cause.func_151519_b((EntityLivingBase)this));
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        byte b;
        super.func_70037_a(compound);
        if (compound.func_74764_b("AttackMode")) {
            b = compound.func_74771_c("AttackMode");
            this.field_70180_af.func_187227_b(ATTACK_MODE, (Object)b);
        }
        if (compound.func_74764_b("MovementMode")) {
            b = compound.func_74771_c("MovementMode");
            this.field_70180_af.func_187227_b(MOVEMENT_MODE, (Object)b);
        }
        if (compound.func_74764_b("Squad")) {
            String s2 = compound.func_74779_i("Squad");
            this.setSquad(s2);
        }
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable var4) {
                var4.printStackTrace();
            }
        }
        this.func_184651_r();
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.isOwner((EntityLivingBase)player);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("IsMinimapHostile", (Byte)this.field_70180_af.func_187225_a(ATTACK_MODE) == 2);
        compound.func_74774_a("AttackMode", ((Byte)this.field_70180_af.func_187225_a(ATTACK_MODE)).byteValue());
        compound.func_74774_a("MovementMode", ((Byte)this.field_70180_af.func_187225_a(MOVEMENT_MODE)).byteValue());
        compound.func_74778_a("Squad", this.getSquad());
        if (this.func_184753_b() == null) {
            compound.func_74778_a("OwnerUUID", "0b1ec5ad-cb2a-43b7-995d-889320eb2e5b");
        } else {
            compound.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public void cycleAttackMode() {
        byte b = this.getAttackMode();
        if (b < 2) {
            byte b1 = b = (byte)(b + 1);
            this.field_70180_af.func_187227_b(ATTACK_MODE, (Object)b1);
            this.func_184651_r();
        } else {
            this.field_70180_af.func_187227_b(ATTACK_MODE, (Object)0);
            this.func_184651_r();
        }
    }

    public void setAttackMode(byte b) {
        this.field_70180_af.func_187227_b(ATTACK_MODE, (Object)b);
        this.func_184651_r();
    }

    public byte getAttackMode() {
        return (Byte)this.field_70180_af.func_187225_a(ATTACK_MODE);
    }

    public void cycleMovementMode() {
        byte b = this.getMovementMode();
        if (b < 2) {
            byte b1 = b = (byte)(b + 1);
            this.field_70180_af.func_187227_b(MOVEMENT_MODE, (Object)b1);
            this.func_184651_r();
        } else {
            this.field_70180_af.func_187227_b(MOVEMENT_MODE, (Object)0);
            this.func_184651_r();
        }
    }

    public void setMovementMode(byte b) {
        this.field_70180_af.func_187227_b(MOVEMENT_MODE, (Object)b);
        this.func_184651_r();
    }

    public byte getMovementMode() {
        return (Byte)this.field_70180_af.func_187225_a(MOVEMENT_MODE);
    }

    public UUID func_184753_b() {
        return (UUID)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID);
    }

    public void setOwnerId(@Nonnull UUID ownerId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)ownerId);
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            return this.field_70170_p.func_152378_a(this.func_184753_b());
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase = this.getOwner();
        if (entitylivingbase != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        EntityLivingBase entitylivingbase = this.getOwner();
        if (entityIn == entitylivingbase) {
            return true;
        }
        if (entitylivingbase instanceof EntityArmyMember) {
            return ((EntityArmyMember)entitylivingbase).func_184753_b() == this.func_184753_b();
        }
        if (entitylivingbase != null) {
            return entitylivingbase.func_184191_r(entityIn);
        }
        return super.func_184191_r(entityIn);
    }

    public String getSquad() {
        return (String)this.field_70180_af.func_187225_a(SQUAD);
    }

    public void setSquad(String s) {
        this.field_70180_af.func_187227_b(SQUAD, (Object)String.valueOf(s));
    }

    public Augment getAugment() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void setClientAugment(@Nullable String augment) {
        this.clientAugment = AugmentRegistry.getAugment(augment);
        if (!this.cachedClientAugment) {
            this.cachedClientAugment = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Augment getClientAugment() {
        return this.clientAugment;
    }

    @Nonnull
    public ItemStack getAugmentStack() {
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ItemStack getAugmentDisplayStack() {
        return this.augmentDisplayStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void setAugmentDisplayStack(@Nonnull ItemStack stack) {
        this.augmentDisplayStack = stack;
        if (!this.cachedClientAugment) {
            this.cachedClientAugment = true;
        }
    }

    @Nonnull
    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    @Nonnull
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    @Nonnull
    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    @Nonnull
    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        boolean flag;
        if (this.func_184614_ca().func_190926_b()) {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (entityIn instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            int j;
            if (knockback > 0) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
            if (!this.func_184614_ca().func_190926_b() && entityIn instanceof EntityLivingBase) {
                this.func_184614_ca().func_77973_b().func_77644_a(this.func_184614_ca(), (EntityLivingBase)entityIn, (EntityLivingBase)this);
            }
            if (this.getAugment() != null) {
                this.getAugment().onStrike(this, entityIn);
            }
        }
        if (this.func_184614_ca().func_190926_b()) {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        return flag;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean shouldAttackEntity(EntityLivingBase target, EntityLivingBase owner) {
        if (ConfigValues.HUNTCREEPERS || !(target instanceof EntityCreeper)) {
            if (target instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)target;
                if (entitywolf.func_70909_n() && entitywolf.func_70902_q() == owner) {
                    return false;
                }
                if (Alliances.getInstance().isAlliedTo(((EntityWolf)target).func_184753_b(), this.func_184753_b())) {
                    return false;
                }
            }
            if (target instanceof EntityArmyMember) {
                if (this.getAttackMode() < 2 && Enemies.getInstance().isNotEnemiesWith(((EntityArmyMember)target).func_184753_b(), this.func_184753_b()) || ((EntityArmyMember)target).func_184753_b().equals(this.func_184753_b())) {
                    return false;
                }
                if (Alliances.getInstance().isAlliedTo(((EntityArmyMember)target).func_184753_b(), this.func_184753_b())) {
                    return false;
                }
            }
            return !(target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target) || target instanceof EntityHorse && ((EntityHorse)target).func_110248_bS());
        }
        return false;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float distanceFactor) {
    }

    public boolean shouldMobAttack(EntityLiving mob) {
        return false;
    }
}

