/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.client.render;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.config.ConfigValues;
import the_fireplace.overlord.tools.ISkinsuitWearer;
import the_fireplace.overlord.tools.SkinTools;
import the_fireplace.overlord.tools.SkinType;

public class LayerSkinsuit
implements LayerRenderer<EntityLivingBase> {
    private final RenderLivingBase<?> renderer;
    private ModelBiped model;
    private boolean logErr = true;

    public LayerSkinsuit(RenderLivingBase<?> renderer, ModelBiped model) {
        this.renderer = renderer;
        this.model = model;
    }

    public void func_177141_a(@Nonnull EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!(entity instanceof ISkinsuitWearer)) {
            return;
        }
        ISkinsuitWearer skin = (ISkinsuitWearer)entity;
        if (!skin.getSkinType().isNone()) {
            block21: {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
                this.model.func_178686_a(this.renderer.func_177087_b());
                this.model.func_78086_a(entity, limbSwing, limbSwingAmount, partialTicks);
                if (skin.getSkinType().equals(SkinType.PLAYER)) {
                    if (!skin.getSkinName().isEmpty()) {
                        try {
                            if (!SkinTools.cachedir.exists() && !SkinTools.cachedir.mkdirs()) {
                                Overlord.logError("Skin cache directory creation failed.", new Object[0]);
                            }
                            File skinFile = new File(SkinTools.cachedir, skin.getSkinName() + ".png");
                            boolean skinExists = true;
                            if (!skinFile.exists()) {
                                if (!SkinTools.nonexistants.contains(skinFile)) {
                                    if (!SkinTools.cacheSkin(skin.getSkinName())) {
                                        SkinTools.nonexistants.add(skinFile);
                                        skinExists = false;
                                    }
                                } else {
                                    skinExists = false;
                                }
                            }
                            if (skinExists) {
                                DynamicTexture texture;
                                BufferedImage img;
                                if (SkinTools.skins.get(skin.getSkinName()) != null) {
                                    img = SkinTools.skins.get(skin.getSkinName());
                                } else {
                                    img = ImageIO.read(skinFile);
                                    SkinTools.skins.put(skin.getSkinName(), img);
                                }
                                if ((img.getRGB(54, 21) >> 24 & 0xFF) == 0) {
                                    // empty if block
                                }
                                if (SkinTools.skintextures.get(img) != null) {
                                    texture = SkinTools.skintextures.get(img);
                                } else {
                                    texture = new DynamicTexture(img);
                                    SkinTools.skintextures.put(img, texture);
                                }
                                this.renderer.func_110776_a(this.renderer.func_177068_d().field_78724_e.func_110578_a("overlord", texture));
                                break block21;
                            }
                            this.renderer.func_110776_a(skin.getSkinType().getTexture());
                        }
                        catch (Exception e) {
                            this.renderer.func_110776_a(skin.getSkinType().getTexture());
                            if (this.logErr) {
                                Overlord.logInfo("Spammy error:", new Object[0]);
                                Overlord.logError(e.getLocalizedMessage(), new Object[0]);
                                Overlord.logInfo("This is most likely repeatedly happening, but has only been logged once.", new Object[0]);
                                this.logErr = false;
                            }
                            break block21;
                        }
                    }
                    this.renderer.func_110776_a(skin.getSkinType().getTexture());
                } else {
                    this.renderer.func_110776_a(skin.getSkinType().getTexture());
                }
            }
            if (ConfigValues.GHOSTLYSKINS) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            this.model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, partialTicks, netHeadYaw, headPitch, scale);
            if (ConfigValues.GHOSTLYSKINS) {
                GlStateManager.func_179117_G();
                GlStateManager.func_179084_k();
            }
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

