/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.client;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;
import the_fireplace.overlord.Overlord;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class ClientEvents {
    private static Random rand = new Random();
    private static final ResourceLocation SPLASH_TEXTS = new ResourceLocation("texts/splashes.txt");
    public static int splashOffsetCount = 0;
    public static final int finalSplashOffsetCount;
    private static final List<String> mySplashes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void screenload(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof GuiMainMenu) {
            IResource iresource;
            block6: {
                iresource = null;
                try {
                    String s;
                    ArrayList defaultSplashes = Lists.newArrayList();
                    iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(SPLASH_TEXTS);
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(iresource.func_110527_b(), StandardCharsets.UTF_8));
                    while ((s = bufferedreader.readLine()) != null) {
                        if ((s = s.trim()).isEmpty()) continue;
                        defaultSplashes.add(s);
                    }
                    int splashNum = rand.nextInt(defaultSplashes.size() + finalSplashOffsetCount);
                    if (splashNum < defaultSplashes.size() + finalSplashOffsetCount - mySplashes.size()) break block6;
                    ReflectionHelper.setPrivateValue(GuiMainMenu.class, (Object)((GuiMainMenu)event.getGui()), (Object)mySplashes.get(splashNum - (defaultSplashes.size() + finalSplashOffsetCount - mySplashes.size())), (String[])new String[]{"splashText", "field_73975_c"});
                }
                catch (IOException e) {
                    try {
                        Overlord.logWarn(e.getLocalizedMessage(), new Object[0]);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(iresource);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)iresource);
                }
            }
            IOUtils.closeQuietly((Closeable)iresource);
        }
    }

    @SubscribeEvent
    public static void modelRegister(ModelRegistryEvent e) {
        Overlord.registerItemRenders();
    }

    static {
        mySplashes = Lists.newArrayList((Object[])new String[]{"Milk is good for the skeletons!", "Spooked solid!", "Do you have a moment to talk about our lord and savior, Skeletor?", "Not Boneless!"});
        if (Calendar.getInstance().get(2) == 9 && Calendar.getInstance().get(5) == 31) {
            mySplashes.add("Skeletons dressed up as humans");
        }
        if (Calendar.getInstance().get(2) == 8 && Calendar.getInstance().get(5) == 15) {
            mySplashes.add("now my brother, papyrus...");
        }
        splashOffsetCount += mySplashes.size();
        try {
            File file = new File(".splashes");
            if (file.exists()) {
                byte[] encoded = Files.readAllBytes(file.toPath());
                try {
                    splashOffsetCount += Integer.parseInt(new String(encoded, "UTF-8"));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                if (!file.delete()) {
                    Overlord.logWarn("Splashes file could not be deleted", new Object[0]);
                }
            }
            file.createNewFile();
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            fw.write(String.valueOf(splashOffsetCount));
            fw.close();
        }
        catch (IOException e) {
            Overlord.logWarn(e.getLocalizedMessage(), new Object[0]);
        }
        finalSplashOffsetCount = splashOffsetCount;
    }
}

