/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CriteriaSkeletonStatusUpdate
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("overlord", "status_update");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners milkDrinkListeners = this.listeners.get(playerAdvancementsIn);
        if (milkDrinkListeners == null) {
            milkDrinkListeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, milkDrinkListeners);
        }
        milkDrinkListeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners milkDrinkListeners = this.listeners.get(playerAdvancementsIn);
        if (milkDrinkListeners != null) {
            milkDrinkListeners.remove(listener);
            if (milkDrinkListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        ItemPredicate itemPredicate = ItemPredicate.func_192492_a((JsonElement)json.get("item"));
        EntityPredicate entitypredicate = EntityPredicate.func_192481_a((JsonElement)json.get("entity"));
        return new Instance(itemPredicate, entitypredicate);
    }

    public void trigger(EntityPlayerMP player, Entity entityIn, Item criteria, int value) {
        Listeners playerhurtentitytrigger$listeners = this.listeners.get(player.func_192039_O());
        if (playerhurtentitytrigger$listeners != null) {
            playerhurtentitytrigger$listeners.trigger(player, entityIn, criteria, value);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(EntityPlayerMP player, Entity entity, Item criteria, int value) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(player, entity, criteria, value)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final ItemPredicate item;
        private final EntityPredicate entity;

        public Instance(ItemPredicate item, EntityPredicate entity) {
            super(ID);
            this.item = item;
            this.entity = entity;
        }

        public boolean test(EntityPlayerMP player, Entity entity, Item criteria, int value) {
            if (!this.item.func_192493_a(new ItemStack(criteria, 1, value))) {
                return false;
            }
            return this.entity.func_192482_a(player, entity);
        }
    }
}

