/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import the_fireplace.overlord.CommonProxy;
import the_fireplace.overlord.advancements.CriterionRegistry;
import the_fireplace.overlord.augments.AugmentAnvil;
import the_fireplace.overlord.augments.AugmentFastRegen;
import the_fireplace.overlord.augments.AugmentIron;
import the_fireplace.overlord.augments.AugmentJitters;
import the_fireplace.overlord.augments.AugmentMummy;
import the_fireplace.overlord.augments.AugmentObsidian;
import the_fireplace.overlord.augments.AugmentSlowRegen;
import the_fireplace.overlord.augments.AugmentWither;
import the_fireplace.overlord.blocks.BlockSkeletonMaker;
import the_fireplace.overlord.command.CommandAlly;
import the_fireplace.overlord.command.CommandAllyAccept;
import the_fireplace.overlord.command.CommandAllyList;
import the_fireplace.overlord.command.CommandAllyReject;
import the_fireplace.overlord.command.CommandAllyRemove;
import the_fireplace.overlord.command.CommandEnemy;
import the_fireplace.overlord.command.CommandEnemyList;
import the_fireplace.overlord.command.CommandEnemyRemove;
import the_fireplace.overlord.compat.ICompat;
import the_fireplace.overlord.compat.ic2.IC2Compat;
import the_fireplace.overlord.config.ConfigValues;
import the_fireplace.overlord.entity.EntityBabySkeleton;
import the_fireplace.overlord.entity.EntityConvertedSkeleton;
import the_fireplace.overlord.entity.EntityCuringSkeleton;
import the_fireplace.overlord.entity.EntitySkeletonWarrior;
import the_fireplace.overlord.entity.projectile.EntityMilkBottle;
import the_fireplace.overlord.handlers.DispenseBehaviorKeychain;
import the_fireplace.overlord.items.ItemBabySpawner;
import the_fireplace.overlord.items.ItemConvertedSpawner;
import the_fireplace.overlord.items.ItemCrown;
import the_fireplace.overlord.items.ItemKeychain;
import the_fireplace.overlord.items.ItemMilkBottle;
import the_fireplace.overlord.items.ItemOverlordsSeal;
import the_fireplace.overlord.items.ItemRallyingHorn;
import the_fireplace.overlord.items.ItemSansMask;
import the_fireplace.overlord.items.ItemSkinsuit;
import the_fireplace.overlord.items.ItemSquadEditor;
import the_fireplace.overlord.items.ItemWarriorSpawner;
import the_fireplace.overlord.network.OverlordGuiHandler;
import the_fireplace.overlord.network.PacketDispatcher;
import the_fireplace.overlord.registry.AugmentRegistry;
import the_fireplace.overlord.registry.MilkRegistry;
import the_fireplace.overlord.tileentity.TileEntityBabySkeletonMaker;
import the_fireplace.overlord.tileentity.TileEntitySkeletonMaker;
import the_fireplace.overlord.tools.Alliance;
import the_fireplace.overlord.tools.Alliances;
import the_fireplace.overlord.tools.CustomDataSerializers;
import the_fireplace.overlord.tools.Enemies;
import the_fireplace.overlord.tools.SkinType;
import the_fireplace.overlord.tools.Squads;

@Mod.EventBusSubscriber
@Mod(modid="overlord", name="Overlord", guiFactory="the_fireplace.overlord.client.gui.OverlordConfigGuiFactory", updateJSON="https://bitbucket.org/The_Fireplace/minecraft-mod-updates/raw/master/overlord.json", acceptedMinecraftVersions="[1.12,)", dependencies="before:guideapi", version="2.4.4")
public final class Overlord {
    public static final String MODNAME = "Overlord";
    public static final String MODID = "overlord";
    @Mod.Instance(value="overlord")
    public static Overlord instance;
    public static Configuration config;
    public static Property HELMETDAMAGE_PROPERTY;
    public static Property GHOSTLYSKINS_PROPERTY;
    public static Property SKINSUITNAMETAGS_PROPERTY;
    public static Property HUNTCREEPERS_PROPERTY;
    public static Property SUFFOCATIONWARNING_PROPERTY;
    public static Property BONEREQ_WARRIOR_PROPERTY;
    public static Property BONEREQ_BABY_PROPERTY;
    public static Property MAXARROWDISTANCE_PROPERTY;
    @SidedProxy(clientSide="the_fireplace.overlord.client.ClientProxy", serverSide="the_fireplace.overlord.CommonProxy")
    public static CommonProxy proxy;
    private static ICompat modCompat;
    public static final CreativeTabs tabOverlord;
    public ArrayList<Alliance> pendingAlliances = new ArrayList();
    public static final ResourceLocation hornSoundLoc;
    public static final SoundEvent HORN_SOUND;
    public static final ResourceLocation createSkeletonSoundLoc;
    public static final SoundEvent CREATE_SKELETON_SOUND;
    public static final ResourceLocation createSkeleton2SoundLoc;
    public static final SoundEvent CREATE_SKELETON_2_SOUND;
    public static ItemArmor.ArmorMaterial sans;
    public static final Block skeleton_maker;
    public static final Block baby_skeleton_maker;
    public static final Item overlords_seal;
    public static final Item overlords_stamp;
    public static final Item squad_editor;
    public static final Item sans_mask;
    public static final Item skinsuit;
    public static final Item skinsuit_mummy;
    public static final Item warrior_spawner;
    public static final Item baby_spawner;
    public static final Item converted_spawner;
    public static final Item milk_bottle;
    public static final Item keychain;
    public static final Item keychain_occupied;
    public static final Item crown;
    public static final Item rallying_horn;
    private static Logger LOGGER;
    private static IForgeRegistry<Block> blockRegistry;
    private static IForgeRegistry<Item> itemRegistry;

    public static void syncConfig() {
        ConfigValues.HELMETDAMAGE = HELMETDAMAGE_PROPERTY.getBoolean();
        ConfigValues.GHOSTLYSKINS = GHOSTLYSKINS_PROPERTY.getBoolean();
        ConfigValues.SKINSUITNAMETAGS = SKINSUITNAMETAGS_PROPERTY.getBoolean();
        ConfigValues.HUNTCREEPERS = HUNTCREEPERS_PROPERTY.getBoolean();
        ConfigValues.SUFFOCATIONWARNING = SUFFOCATIONWARNING_PROPERTY.getBoolean();
        ConfigValues.BONEREQ_WARRIOR = BONEREQ_WARRIOR_PROPERTY.getInt();
        ConfigValues.BONEREQ_BABY = BONEREQ_BABY_PROPERTY.getInt();
        ConfigValues.MAXARROWDISTANCE = MAXARROWDISTANCE_PROPERTY.getDouble();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        PacketDispatcher.registerPackets();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new OverlordGuiHandler());
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        HELMETDAMAGE_PROPERTY = config.get("general", "cfg.helmet_damage", false, proxy.translateToLocal("cfg.helmet_damage.tooltip", new Object[0]));
        GHOSTLYSKINS_PROPERTY = config.get("general", "cfg.ghostly_skins", true, proxy.translateToLocal("cfg.ghostly_skins.tooltip", new Object[0]));
        SKINSUITNAMETAGS_PROPERTY = config.get("general", "cfg.skinsuitnametags", true, proxy.translateToLocal("cfg.skinsuitnametags.tooltip", new Object[0]));
        HUNTCREEPERS_PROPERTY = config.get("general", "cfg.huntcreepers", false, proxy.translateToLocal("cfg.huntcreepers.tooltip", new Object[0]));
        SUFFOCATIONWARNING_PROPERTY = config.get("general", "cfg.suffocationwarning", true, proxy.translateToLocal("cfg.suffocationwarning.tooltip", new Object[0]));
        BONEREQ_WARRIOR_PROPERTY = config.get("general", "cfg.bonereq_warrior", 32, proxy.translateToLocal("cfg.bonereq_warrior.tooltip", new Object[0]));
        BONEREQ_BABY_PROPERTY = config.get("general", "cfg.bonereq_baby", 16, proxy.translateToLocal("cfg.bonereq_baby.tooltip", new Object[0]));
        MAXARROWDISTANCE_PROPERTY = config.get("general", "cfg.max_arrow_distance", 30.0, proxy.translateToLocal("cfg.max_arrow_distance.tooltip", new Object[0]));
        BONEREQ_WARRIOR_PROPERTY.setMinValue(2);
        BONEREQ_BABY_PROPERTY.setMinValue(1);
        BONEREQ_WARRIOR_PROPERTY.setMaxValue(128);
        BONEREQ_BABY_PROPERTY.setMaxValue(64);
        MAXARROWDISTANCE_PROPERTY.setMinValue(2);
        MAXARROWDISTANCE_PROPERTY.setMaxValue(256);
        if (event.getSide().isClient()) {
            BONEREQ_WARRIOR_PROPERTY.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
            BONEREQ_BABY_PROPERTY.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
            MAXARROWDISTANCE_PROPERTY.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
        Overlord.syncConfig();
        GameRegistry.registerTileEntity(TileEntitySkeletonMaker.class, (String)"skeleton_maker");
        GameRegistry.registerTileEntity(TileEntityBabySkeletonMaker.class, (String)"baby_skeleton_maker");
        int eid = -1;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("overlord:skeleton_warrior"), EntitySkeletonWarrior.class, (String)"skeleton_warrior", (int)(++eid), (Object)instance, (int)128, (int)2, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("overlord:skeleton_baby"), EntityBabySkeleton.class, (String)"skeleton_baby", (int)(++eid), (Object)instance, (int)64, (int)2, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("overlord:milk_bottle"), EntityMilkBottle.class, (String)"milk_bottle", (int)(++eid), (Object)instance, (int)32, (int)10, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("overlord:skeleton_converted"), EntityConvertedSkeleton.class, (String)"skeleton_converted", (int)(++eid), (Object)instance, (int)116, (int)2, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("overlord:skeleton_curing"), EntityCuringSkeleton.class, (String)"skeleton_curing", (int)(++eid), (Object)instance, (int)48, (int)2, (boolean)false);
        proxy.registerClient();
        DataSerializers.func_187189_a(CustomDataSerializers.UNIQUE_ID);
        new CriterionRegistry();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        AugmentRegistry.registerAugment(new ItemStack(Items.field_151153_ao), new AugmentSlowRegen());
        AugmentRegistry.registerAugment(new ItemStack(Items.field_151153_ao, 1, 1), new AugmentFastRegen());
        AugmentRegistry.registerAugment(new ItemStack(Items.field_151042_j), new AugmentIron());
        AugmentRegistry.registerAugment(new ItemStack(Blocks.field_150343_Z), new AugmentObsidian());
        AugmentRegistry.registerAugment(new ItemStack(Blocks.field_150467_bQ), new AugmentAnvil());
        AugmentRegistry.registerAugment(new ItemStack(Items.field_151144_bL, 1, 1), new AugmentWither());
        AugmentRegistry.registerAugment(new ItemStack(Items.field_151102_aT), new AugmentJitters());
        AugmentRegistry.registerAugment(new ItemStack(skinsuit_mummy), new AugmentMummy());
        OreDictionary.registerOre((String)"book", (Item)squad_editor);
        MilkRegistry.getInstance().registerMilk(new ItemStack(Items.field_151117_aB), new ItemStack(Items.field_151133_ar));
        MilkRegistry.getInstance().registerMilk(new ItemStack(milk_bottle), new ItemStack(Items.field_151069_bo));
        BlockDispenser.field_149943_a.func_82595_a((Object)keychain_occupied, (Object)new DispenseBehaviorKeychain());
        BlockDispenser.field_149943_a.func_82595_a((Object)milk_bottle, (Object)new BehaviorProjectileDispense(){

            @Nonnull
            protected IProjectile func_82499_a(@Nonnull World worldIn, @Nonnull IPosition position, @Nonnull ItemStack stackIn) {
                return new EntityMilkBottle(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
        if (Loader.isModLoaded((String)"ic2")) {
            modCompat = new IC2Compat();
            modCompat.init(event);
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager serverCommand = (ServerCommandManager)command;
        serverCommand.func_71560_a((ICommand)new CommandAlly());
        serverCommand.func_71560_a((ICommand)new CommandAllyAccept());
        serverCommand.func_71560_a((ICommand)new CommandAllyList());
        serverCommand.func_71560_a((ICommand)new CommandAllyReject());
        serverCommand.func_71560_a((ICommand)new CommandAllyRemove());
        serverCommand.func_71560_a((ICommand)new CommandEnemy());
        serverCommand.func_71560_a((ICommand)new CommandEnemyList());
        serverCommand.func_71560_a((ICommand)new CommandEnemyRemove());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        Alliances.load();
        Enemies.load();
        Squads.load();
    }

    public static void registerBlock(Block block) {
        if (blockRegistry == null) {
            Overlord.logError("Block registry was null, could not register: " + block.func_149739_a(), new Object[0]);
            return;
        }
        blockRegistry.register(block.setRegistryName(block.func_149739_a().substring(5)));
    }

    public static void registerItem(Item item) {
        if (itemRegistry == null) {
            Overlord.logError("Item registry was null, could not register: " + item.func_77658_a(), new Object[0]);
            return;
        }
        itemRegistry.register(item.setRegistryName(item.func_77658_a().substring(5)));
    }

    public static void registerItemForBlock(Block block) {
        if (itemRegistry == null) {
            Overlord.logError("Item registry was null, could not register: " + block.func_149739_a(), new Object[0]);
            return;
        }
        itemRegistry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    public static void registerItemBlock(ItemBlock itemBlock) {
        if (itemRegistry == null) {
            Overlord.logError("Item registry was null, could not register: " + itemBlock.func_77658_a(), new Object[0]);
            return;
        }
        itemRegistry.register(itemBlock.setRegistryName(itemBlock.func_179223_d().func_149739_a().substring(5)));
    }

    @SubscribeEvent
    public static void itemRegistry(RegistryEvent.Register<Item> event) {
        itemRegistry = event.getRegistry();
        Overlord.registerItem(overlords_seal);
        Overlord.registerItem(overlords_stamp);
        Overlord.registerItem(squad_editor);
        Overlord.registerItem(sans_mask);
        Overlord.registerItem(skinsuit);
        Overlord.registerItem(skinsuit_mummy);
        Overlord.registerItem(warrior_spawner);
        Overlord.registerItem(baby_spawner);
        Overlord.registerItem(converted_spawner);
        Overlord.registerItem(milk_bottle);
        Overlord.registerItem(keychain);
        Overlord.registerItem(keychain_occupied);
        Overlord.registerItem(crown);
        Overlord.registerItem(rallying_horn);
        Overlord.registerItemForBlock(skeleton_maker);
        Overlord.registerItemForBlock(baby_skeleton_maker);
    }

    @SubscribeEvent
    public static void blockRegistry(RegistryEvent.Register<Block> event) {
        blockRegistry = event.getRegistry();
        Overlord.registerBlock(skeleton_maker);
        Overlord.registerBlock(baby_skeleton_maker);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenders() {
        Overlord.rmm(skeleton_maker);
        Overlord.rmm(baby_skeleton_maker);
        Overlord.rmm(overlords_seal);
        Overlord.rmm(overlords_stamp);
        Overlord.rmm(squad_editor);
        Overlord.rmm(sans_mask);
        Overlord.rmm(skinsuit);
        Overlord.rmm(skinsuit_mummy);
        Overlord.rmm(warrior_spawner);
        Overlord.rmm(baby_spawner);
        Overlord.rmm(converted_spawner);
        Overlord.rmm(milk_bottle);
        Overlord.rmm(keychain);
        Overlord.rmm(keychain_occupied);
        Overlord.rmm(crown);
        Overlord.rmm(rallying_horn);
        StateMap skeleton_maker_mapper = new StateMap.Builder().func_178442_a(new IProperty[]{BlockSkeletonMaker.TRIGGERED}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)skeleton_maker, (IStateMapper)skeleton_maker_mapper);
        ModelLoader.setCustomStateMapper((Block)baby_skeleton_maker, (IStateMapper)skeleton_maker_mapper);
    }

    @SideOnly(value=Side.CLIENT)
    private static void rmm(Block b) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)b), (int)0, (ModelResourceLocation)new ModelResourceLocation("overlord:" + b.func_149739_a().substring(5), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void rmm(Item i) {
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)new ModelResourceLocation("overlord:" + i.func_77658_a().substring(5), "inventory"));
    }

    @SubscribeEvent
    public static void soundRegistry(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register(HORN_SOUND.setRegistryName(hornSoundLoc));
        event.getRegistry().register(CREATE_SKELETON_SOUND.setRegistryName(createSkeletonSoundLoc));
        event.getRegistry().register(CREATE_SKELETON_2_SOUND.setRegistryName(createSkeleton2SoundLoc));
    }

    public static ItemStack crusaderShield() {
        ItemStack shieldStack = new ItemStack(Items.field_185159_cQ);
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagCompound bet = shieldStack.func_179543_a("BlockEntityTag");
        if (bet == null) {
            bet = new NBTTagCompound();
        }
        bet.func_74768_a("Base", 15);
        NBTTagList nbttaglist = new NBTTagList();
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("Pattern", "sc");
        nbttagcompound.func_74768_a("Color", 1);
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        bet.func_74782_a("Patterns", (NBTBase)nbttaglist);
        tagCompound.func_74782_a("BlockEntityTag", (NBTBase)bet);
        shieldStack.func_77982_d(tagCompound);
        return shieldStack;
    }

    public static void logInfo(String log, Object ... params) {
        LOGGER.log(Level.INFO, log, params);
    }

    public static void logDebug(String log, Object ... params) {
        LOGGER.log(Level.DEBUG, log, params);
    }

    public static void logError(String log, Object ... params) {
        LOGGER.log(Level.ERROR, log, params);
    }

    public static void logTrace(String log, Object ... params) {
        LOGGER.log(Level.TRACE, log, params);
    }

    public static void logWarn(String log, Object ... params) {
        LOGGER.log(Level.WARN, log, params);
    }

    static {
        tabOverlord = new CreativeTabs(MODID){

            @Nonnull
            public ItemStack func_78016_d() {
                return new ItemStack(skeleton_maker);
            }
        };
        hornSoundLoc = new ResourceLocation(MODID, "horn");
        HORN_SOUND = new SoundEvent(hornSoundLoc);
        createSkeletonSoundLoc = new ResourceLocation(MODID, "skeleton_construct");
        CREATE_SKELETON_SOUND = new SoundEvent(createSkeletonSoundLoc);
        createSkeleton2SoundLoc = new ResourceLocation(MODID, "skeleton_construct_2");
        CREATE_SKELETON_2_SOUND = new SoundEvent(createSkeleton2SoundLoc);
        sans = EnumHelper.addArmorMaterial((String)"SANS", (String)"sans_mask", (int)20, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f);
        skeleton_maker = new BlockSkeletonMaker("skeleton_maker").func_149711_c(5.0f).func_149752_b(15.0f);
        baby_skeleton_maker = new BlockSkeletonMaker("baby_skeleton_maker").func_149711_c(4.0f).func_149752_b(10.0f);
        overlords_seal = new ItemOverlordsSeal().func_77655_b("overlords_seal").func_77637_a(tabOverlord).func_77625_d(1);
        overlords_stamp = new ItemOverlordsSeal(false, true).func_77655_b("overlords_stamp").func_77637_a(tabOverlord);
        squad_editor = new ItemSquadEditor().func_77655_b("squad_editor").func_77637_a(tabOverlord).func_77625_d(1);
        sans_mask = new ItemSansMask(sans);
        skinsuit = new ItemSkinsuit(SkinType.PLAYER).func_77655_b("skinsuit").func_77637_a(tabOverlord).func_77625_d(1);
        skinsuit_mummy = new ItemSkinsuit(SkinType.MUMMY).func_77655_b("skinsuit_mummy").func_77637_a(tabOverlord).func_77625_d(1);
        warrior_spawner = new ItemWarriorSpawner().func_77655_b("warrior_spawner").func_77637_a(tabOverlord).func_77625_d(1);
        baby_spawner = new ItemBabySpawner().func_77655_b("baby_spawner").func_77637_a(tabOverlord).func_77625_d(1);
        converted_spawner = new ItemConvertedSpawner().func_77655_b("converted_spawner").func_77637_a(tabOverlord).func_77625_d(1);
        milk_bottle = new ItemMilkBottle().func_77625_d(16);
        keychain = new ItemKeychain(false).func_77655_b("keychain_empty");
        keychain_occupied = new ItemKeychain(true).func_77655_b("keychain_occupied");
        crown = new ItemCrown(ItemArmor.ArmorMaterial.GOLD);
        rallying_horn = new ItemRallyingHorn().func_77655_b("rallying_horn").func_77625_d(1).func_77637_a(tabOverlord);
        LOGGER = FMLLog.getLogger();
        blockRegistry = null;
        itemRegistry = null;
    }
}

