/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.world;

import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.roots.ConfigManager;
import teamroots.roots.RegistryManager;
import teamroots.roots.network.PacketHandler;
import teamroots.roots.network.message.MessageTEUpdate;
import teamroots.roots.util.Misc;
import teamroots.roots.util.NoiseGenUtil;
import teamroots.roots.world.StructureBase;

public class WorldGenHut
extends StructureBase
implements IWorldGenerator {
    public WorldGenHut() {
        super(7, 7);
        this.addBlockMapping("L", Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X));
        this.addBlockMapping("l", Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z));
        this.addBlockMapping("W", Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
        this.addBlockMapping(" ", Blocks.field_150350_a.func_176223_P());
        this.addBlockMapping("F", Blocks.field_180407_aO.func_176223_P());
        this.addBlockMapping("T", RegistryManager.thatch.func_176223_P());
        this.addBlockMapping("P", Blocks.field_150457_bL.func_176223_P().func_177226_a((IProperty)BlockFlowerPot.field_176443_b, (Comparable)BlockFlowerPot.EnumFlowerType.ORANGE_TULIP));
        this.addBlockMapping("M", RegistryManager.mortar.func_176223_P());
        this.addBlockMapping("C", Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.WEST));
        this.addBlockMapping("c", Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.EAST));
        this.addBlockMapping("K", Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.NORTH));
        this.addLayer(new String[]{"       ", "  LlL  ", " LlLLl ", " lLllL ", " LlLLl ", "  lLl  ", "       "});
        this.addLayer(new String[]{"       ", "  lLL  ", " lWWWl ", " lWWWL ", " LWWWl ", "  lLL  ", "       "});
        this.addLayer(new String[]{"       ", "  WWW  ", " WcKPW ", "     W ", " WCCMW ", "  WWW  ", "       "});
        this.addLayer(new String[]{" TTTTT ", "  WWW  ", " W   W ", "     W ", " W   W ", "  WWW  ", " TTTTT "});
        this.addLayer(new String[]{"       ", "TTTTTTT", " W   W ", " FW WF ", " W   W ", "TTTTTTT", "       "});
        this.addLayer(new String[]{"       ", "       ", "TTTTTTT", " W   W ", "TTTTTTT", "       ", "       "});
        this.addLayer(new String[]{"       ", "       ", "       ", "TTTTTTT", "       ", "       ", "       "});
    }

    @Override
    public void placeBlock(World world, BlockPos pos, IBlockState state) {
        super.placeBlock(world, pos, state);
        if (state.func_177230_c() == Blocks.field_150486_ae) {
            if (state.func_177229_b((IProperty)BlockChest.field_176459_a) == EnumFacing.WEST) {
                if (world.func_175625_s(pos) != null) {
                    TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
                    chest.func_189404_a(new ResourceLocation("roots:hut"), NoiseGenUtil.getSeed((int)world.func_72905_C(), pos.func_177958_n(), pos.func_177952_p()));
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate((TileEntity)chest));
                    chest.func_70296_d();
                }
            } else if (state.func_177229_b((IProperty)BlockChest.field_176459_a) == EnumFacing.EAST) {
                if (world.func_175625_s(pos) != null) {
                    TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
                    chest.func_189404_a(new ResourceLocation("roots:hut_book1"), NoiseGenUtil.getSeed((int)world.func_72905_C(), pos.func_177958_n(), pos.func_177952_p()));
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate((TileEntity)chest));
                    chest.func_70296_d();
                }
            } else if (state.func_177229_b((IProperty)BlockChest.field_176459_a) == EnumFacing.NORTH && world.func_175625_s(pos) != null) {
                TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
                chest.func_189404_a(new ResourceLocation("roots:hut_book2"), NoiseGenUtil.getSeed((int)world.func_72905_C(), pos.func_177958_n(), pos.func_177952_p()));
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate((TileEntity)chest));
                chest.func_70296_d();
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ConfigManager.hutChance <= 0) {
            return;
        }
        if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a() && !world.field_72995_K) {
            int height;
            int xx = chunkX * 16 + 12 + Misc.random.nextInt(8);
            int zz = chunkZ * 16 + 12 + Misc.random.nextInt(8);
            if (random.nextInt(ConfigManager.hutChance) == 0 && (height = world.func_189649_b(xx, zz) - 1) > 0 && world.func_180495_p(new BlockPos(xx, height, zz)).func_177230_c() instanceof BlockGrass) {
                int j;
                int i;
                boolean canGenerate = true;
                for (i = -2; i < 3; ++i) {
                    for (j = -2; j < 3; ++j) {
                        if (world.func_180495_p(new BlockPos(xx + i, height, zz + j)).func_177230_c() != Blocks.field_150350_a) continue;
                        canGenerate = false;
                    }
                }
                for (i = -4; i < 5; ++i) {
                    for (j = -4; j < 5; ++j) {
                        if (world.func_180495_p(new BlockPos(xx + i, height + 3, zz + j)).func_177230_c() == Blocks.field_150350_a) continue;
                        canGenerate = false;
                    }
                }
                if (canGenerate) {
                    this.generateIn(world, xx, height - 1, zz);
                    for (i = 0; i < 20; ++i) {
                        int tx = xx + (random.nextInt(20) - 10);
                        int tz = zz + (random.nextInt(20) - 10);
                        int ty = world.func_189649_b(xx, zz) - 1;
                        if (!(world.func_180495_p(new BlockPos(tx, ty, tz)).func_177230_c() instanceof BlockGrass) || !world.func_180495_p(new BlockPos(tx, ty + 1, tz)).func_177230_c().func_176200_f((IBlockAccess)world, new BlockPos(tx, ty + 1, tz))) continue;
                        world.func_175656_a(new BlockPos(tx, ty + 1, tz), Blocks.field_150328_O.func_176203_a(random.nextInt(9)));
                    }
                }
            }
        }
    }
}

