/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.world;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import teamroots.roots.ConfigManager;
import teamroots.roots.entity.EntitySprout;
import teamroots.roots.util.Misc;

public class WorldGenGarden
implements IWorldGenerator {
    ArrayList<IBlockState> blocks = new ArrayList();

    public WorldGenGarden() {
        this.blocks.add(Blocks.field_150464_aj.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7)));
        this.blocks.add(Blocks.field_185773_cZ.func_176223_P().func_177226_a((IProperty)BlockBeetroot.field_185531_a, (Comparable)Integer.valueOf(3)));
        this.blocks.add(Blocks.field_150469_bN.func_176223_P().func_177226_a((IProperty)BlockPotato.field_176488_a, (Comparable)Integer.valueOf(7)));
        this.blocks.add(Blocks.field_150459_bM.func_176223_P().func_177226_a((IProperty)BlockCarrot.field_176488_a, (Comparable)Integer.valueOf(7)));
        this.blocks.add(Blocks.field_180407_aO.func_176223_P());
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ConfigManager.gardenChance <= 0) {
            return;
        }
        if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
            int xx = chunkX * 16 + 8 + Misc.random.nextInt(16);
            int zz = chunkZ * 16 + 8 + Misc.random.nextInt(16);
            if (random.nextInt(ConfigManager.gardenChance) == 0 && world.func_189649_b(xx, zz) - 1 > 0 && world.func_180495_p(new BlockPos(xx, world.func_189649_b(xx, zz) - 1, zz)).func_177230_c() instanceof BlockGrass) {
                for (int i = 0; i < 360; i += random.nextInt(36)) {
                    int tz;
                    if (random.nextInt(3) == 0) continue;
                    int height = random.nextInt(3) + 4;
                    int tx = (int)((double)xx + random.nextDouble() * 5.0 * Math.sin(Math.toRadians(i)));
                    BlockPos pos = world.func_175672_r(new BlockPos(tx, world.func_189649_b(tx, tz = (int)((double)zz + random.nextDouble() * 5.0 * Math.cos(Math.toRadians(i)))), tz)).func_177977_b();
                    if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockGrass)) continue;
                    IBlockState state = this.blocks.get(random.nextInt(this.blocks.size()));
                    if (!(state.func_177230_c() instanceof BlockFence)) {
                        if (random.nextBoolean() && !world.field_72995_K) {
                            EntitySprout sprout = new EntitySprout(world);
                            sprout.func_180482_a(world.func_175649_E(pos), null);
                            sprout.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
                            world.func_72838_d((Entity)sprout);
                        }
                        world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                    }
                    world.func_175656_a(pos.func_177984_a(), state);
                }
            }
        }
    }
}

