/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.world;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import teamroots.roots.ConfigManager;
import teamroots.roots.entity.EntityFairyCircle;
import teamroots.roots.util.Misc;

public class WorldGenFairyPool
implements IWorldGenerator {
    ArrayList<IBlockState> saplings = new ArrayList();

    public WorldGenFairyPool() {
        this.saplings.add(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.OAK));
        this.saplings.add(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.BIRCH));
    }

    public int getDropForLocation(BlockPos center, BlockPos test) {
        return Math.min(Math.round((5.0f + Misc.random.nextFloat() * 0.5f) * Math.max(0.0f, 1.0f - MathHelper.func_76133_a((double)center.func_177951_i((Vec3i)test)) / 9.0f)), 5);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int zz;
        if (ConfigManager.fairyPoolChance <= 0) {
            return;
        }
        int xx = chunkX * 16 + 8 + Misc.random.nextInt(16);
        BlockPos centerPos = world.func_175672_r(new BlockPos(xx, 0, zz = chunkZ * 16 + 8 + Misc.random.nextInt(16)));
        if (centerPos.func_177956_o() > 2 && world.func_180495_p(centerPos.func_177977_b()).func_177230_c() instanceof BlockGrass) {
            boolean canGenerate = true;
            for (int i = -6; i < 7; ++i) {
                for (int j = -6; j < 7; ++j) {
                    if (world.func_180495_p(new BlockPos(xx + i, centerPos.func_177956_o() - 2, zz + j)).func_177230_c() != Blocks.field_150350_a) continue;
                    canGenerate = false;
                }
            }
            IBlockState grassState = world.func_180495_p(centerPos.func_177977_b());
            if (canGenerate && random.nextInt(ConfigManager.fairyPoolChance) == 0) {
                BlockPos pos;
                int j;
                int i;
                int minY = -1;
                for (i = -8; i < 9; ++i) {
                    for (j = -8; j < 9; ++j) {
                        pos = world.func_175672_r(centerPos.func_177982_a(i, 0, j)).func_177977_b();
                        if (pos.func_177956_o() >= minY && minY != -1) continue;
                        minY = pos.func_177956_o();
                    }
                }
                if ((minY = Math.max(1, minY)) != -1) {
                    for (i = -8; i < 9; ++i) {
                        for (j = -8; j < 9; ++j) {
                            pos = world.func_175672_r(centerPos.func_177982_a(i, 0, j)).func_177977_b();
                            while (pos.func_177956_o() > minY && pos.func_177956_o() < minY + 8 && this.getDropForLocation(centerPos, pos) > 0) {
                                world.func_175698_g(pos);
                                pos = pos.func_177977_b();
                            }
                        }
                    }
                    for (i = -8; i < 9; ++i) {
                        for (j = -8; j < 9; ++j) {
                            pos = world.func_175672_r(centerPos.func_177982_a(i, 0, j)).func_177977_b();
                            int y = this.getDropForLocation(centerPos, pos);
                            for (int k = 0; k < y && k <= minY && !(world.func_180495_p(pos.func_177979_c(k)).func_177230_c() instanceof BlockLog); ++k) {
                                world.func_175656_a(pos.func_177979_c(k), Blocks.field_150355_j.func_176223_P());
                                if (world.func_175623_d(pos.func_177979_c(k).func_177974_f())) {
                                    world.func_175656_a(pos.func_177979_c(k).func_177974_f(), Blocks.field_150358_i.func_176203_a(7));
                                }
                                if (world.func_175623_d(pos.func_177979_c(k).func_177976_e())) {
                                    world.func_175656_a(pos.func_177979_c(k).func_177976_e(), Blocks.field_150358_i.func_176203_a(7));
                                }
                                if (world.func_175623_d(pos.func_177979_c(k).func_177978_c())) {
                                    world.func_175656_a(pos.func_177979_c(k).func_177978_c(), Blocks.field_150358_i.func_176203_a(7));
                                }
                                if (!world.func_175623_d(pos.func_177979_c(k).func_177968_d())) continue;
                                world.func_175656_a(pos.func_177979_c(k).func_177968_d(), Blocks.field_150358_i.func_176203_a(7));
                            }
                        }
                    }
                }
                for (i = 0; i < 360; i += 3) {
                    int tz;
                    if (random.nextInt(3) == 0) continue;
                    int height = random.nextInt(3) + 4;
                    int tx = (int)((double)xx + 19.0 * random.nextDouble() * Math.sin(Math.toRadians(i)));
                    BlockPos pos2 = new BlockPos(tx, world.func_189649_b(tx, tz = (int)((double)zz + 19.0 * random.nextDouble() * Math.cos(Math.toRadians(i)))), tz);
                    if (!(world.func_180495_p(pos2.func_177977_b()).func_177230_c() instanceof BlockGrass)) continue;
                    int index = random.nextInt(this.saplings.size());
                    ((BlockSapling)this.saplings.get(index).func_177230_c()).func_176476_e(world, pos2, this.saplings.get(index), random);
                }
                EntityFairyCircle entity = new EntityFairyCircle(world);
                entity.func_70107_b(centerPos.func_177981_b(4).func_177958_n(), centerPos.func_177981_b(4).func_177956_o(), centerPos.func_177981_b(4).func_177952_p());
                world.func_72838_d((Entity)entity);
            }
        }
    }
}

