/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.item;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.roots.item.ItemBase;
import teamroots.roots.util.Misc;

public class ItemPouch
extends ItemBase {
    public static final double capacity = 128.0;

    public ItemPouch(String name, boolean addToTab) {
        super(name, addToTab);
        this.func_77625_d(1);
    }

    public static ItemStack createData(ItemStack stack, String plantName, double quantity) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("plant", plantName);
        stack.func_77978_p().func_74780_a("quantity", quantity);
        return stack;
    }

    public static double getQuantity(ItemStack stack, String plantName) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("quantity")) {
            return stack.func_77978_p().func_74769_h("quantity");
        }
        return 0.0;
    }

    public static void setQuantity(ItemStack stack, String plantName, double quantity) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("quantity")) {
            stack.func_77978_p().func_74780_a("quantity", Math.min(128.0, quantity));
            if (stack.func_77978_p().func_74769_h("quantity") <= 0.0) {
                stack.func_77978_p().func_82580_o("quantity");
                stack.func_77978_p().func_82580_o("plant");
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("quantity");
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Misc.intColor(96, 255, 96);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("quantity")) {
            return 1.0 - stack.func_77978_p().func_74769_h("quantity") / 128.0;
        }
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("quantity")) {
            tooltip.add(I18n.func_135052_a((String)(stack.func_77978_p().func_74779_i("plant") + ".name"), (Object[])new Object[0]) + I18n.func_135052_a((String)"roots.tooltip.pouch_divider", (Object[])new Object[0]) + (int)Math.ceil(stack.func_77978_p().func_74769_h("quantity")));
        }
    }
}

