/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.items.ItemLawSword;
import com.rwtema.extrautils2.utils.PositionPool;
import com.rwtema.extrautils2.utils.helpers.WorldHelper;
import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFireAxe
extends ItemAxe
implements IXUItem {
    static final int MAX_DESTROY = 512;
    static final Vec3i[] ORDERED_SIDES = new Vec3i[]{new Vec3i(0, 1, 0), new Vec3i(0, -1, 0), new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 1, 1), new Vec3i(0, 1, -1), new Vec3i(1, 1, 0), new Vec3i(-1, 1, 0), new Vec3i(0, 1, 1), new Vec3i(0, 1, -1), new Vec3i(1, 1, 0), new Vec3i(-1, 1, 0), new Vec3i(1, 0, 1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, -1), new Vec3i(1, 1, 1), new Vec3i(1, 1, -1), new Vec3i(-1, 1, 1), new Vec3i(-1, 1, -1), new Vec3i(1, 0, 1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, -1)};
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite sprite;

    public ItemFireAxe() {
        super(ItemLawSword.material, 10.0f, -3.0f);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("extrautils2:fireaxe");
        MinecraftForge.EVENT_BUS.register((Object)new ItemLawSword.OPAnvilHandler((Item)this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register("fire_axe");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createModel(int metadata) {
        return new PassthruModelItem(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseTexture() {
        return this.sprite;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack) {
        model.addSprite(this.sprite);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postTextureRegister() {
        this.sprite = Textures.getSprite("fire_axe");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsTool() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clearCaches() {
        this.sprite = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean allowOverride() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxMetadata() {
        return 0;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (state.func_185904_a() == Material.field_151584_j) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return false;
        }
        World world = player.field_70170_p;
        IBlockState initState = world.func_180495_p(pos);
        if (initState.func_177230_c().isWood((IBlockAccess)world, pos)) {
            BlockPos nextPos;
            IBlockState blockState;
            PositionPool positionPool = new PositionPool();
            BlockPos topPoint = pos = positionPool.intern(pos);
            HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
            HashSet<BlockPos> toDestroy = new HashSet<BlockPos>();
            LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
            do {
                checkedPositions.add(topPoint);
                for (EnumFacing horizontalSide : EnumFacing.field_176754_o) {
                    toCheck.add(positionPool.offset(topPoint, horizontalSide));
                }
                toDestroy.add(topPoint);
            } while ((blockState = world.func_180495_p(topPoint = positionPool.offset(topPoint, EnumFacing.UP))).func_177230_c().isWood((IBlockAccess)world, topPoint));
            if (!blockState.func_177230_c().isLeaves(blockState, (IBlockAccess)world, topPoint)) {
                return false;
            }
            while (toDestroy.size() < 512 && (nextPos = (BlockPos)toCheck.poll()) != null) {
                for (Vec3i orderedSide : ORDERED_SIDES) {
                    BlockPos offsetPos = positionPool.add(nextPos, orderedSide);
                    if (!checkedPositions.add(offsetPos)) continue;
                    IBlockState state = world.func_180495_p(offsetPos);
                    if (state.func_177230_c().isWood((IBlockAccess)world, offsetPos)) {
                        toDestroy.add(offsetPos);
                        toCheck.add(offsetPos);
                        continue;
                    }
                    if (!state.func_177230_c().isLeaves(state, (IBlockAccess)world, offsetPos)) continue;
                    world.func_180497_b(nextPos, blockState.func_177230_c(), world.field_73012_v.nextInt(40), 0);
                }
            }
            for (BlockPos blockPos : toDestroy) {
                if (!player.field_71075_bZ.field_75098_d) {
                    IBlockState state = world.func_180495_p(blockPos);
                    state.func_177230_c().func_180657_a(world, player, blockPos, state, world.func_175625_s(blockPos), itemstack);
                }
                world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
                WorldHelper.markBlockForUpdate(world, blockPos);
            }
            return false;
        }
        return false;
    }
}

