/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.XUItemFlat;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.enchants.BoomerangEnchantment;
import com.rwtema.extrautils2.enchants.XUEnchantment;
import com.rwtema.extrautils2.entity.EntityBoomerang;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoomerang
extends XUItemFlat {
    public static final String TEXTURE_NAME = "boomerang";
    public static final String TEXTURE_NAME_EMPTY = "boomerang_missing";
    public static final BoomerangEnchantment EXPLODE = new BoomerangEnchantment("Kaboomerang", 3, Enchantment.Rarity.COMMON);
    public static final BoomerangEnchantment SPEED = new BoomerangEnchantment("Zoomerang", 3, Enchantment.Rarity.COMMON);
    public static final BoomerangEnchantment FLAMING = new BoomerangEnchantment("Burnerang", 1, Enchantment.Rarity.COMMON);
    public static final BoomerangEnchantment SHARPNESS = new BoomerangEnchantment("Bladerang", 5, Enchantment.Rarity.COMMON);
    public static final BoomerangEnchantment DIGGING = new BoomerangEnchantment("Boomereaperang", 1, Enchantment.Rarity.COMMON);

    public ItemBoomerang() {
        this.func_77625_d(1);
        this.func_77656_e(64);
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register(TEXTURE_NAME, TEXTURE_NAME_EMPTY);
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        if (!this.canThrowBoomerang((EntityPlayer)Minecraft.func_71410_x().field_71439_g, EntityBoomerang.boomerangOwnersClient)) {
            InventoryPlayer inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
            if (inventory.func_70445_o() == itemStack) {
                return TEXTURE_NAME_EMPTY;
            }
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i) != itemStack) continue;
                return TEXTURE_NAME_EMPTY;
            }
        }
        return TEXTURE_NAME;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> onItemRightClickBase(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            if (!this.canThrowBoomerang(playerIn, EntityBoomerang.boomerangOwners)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
            }
            EntityBoomerang boomerang = new EntityBoomerang(worldIn, (EntityLivingBase)playerIn, itemStackIn.func_77946_l());
            List potionEffects = PotionUtils.func_185189_a((ItemStack)itemStackIn);
            if (!potionEffects.isEmpty()) {
                CompatHelper112.damage(itemStackIn, 1, playerIn.func_70681_au());
                int damage = itemStackIn.func_77952_i();
                if (damage >= this.func_77612_l()) {
                    itemStackIn.func_77964_b(0);
                    NBTTagCompound nbt = itemStackIn.func_77978_p();
                    if (nbt != null) {
                        nbt.func_82580_o("Potion");
                        nbt.func_82580_o("CustomPotionEffects");
                        if (nbt.func_82582_d()) {
                            itemStackIn.func_77982_d(null);
                        }
                    }
                } else {
                    itemStackIn.func_77964_b(damage);
                }
            }
            worldIn.func_72838_d((Entity)boomerang);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public boolean canThrowBoomerang(EntityPlayer playerIn, WeakHashMap<Object, WeakReference<EntityBoomerang>> boomerangOwners) {
        EntityBoomerang boomerang;
        WeakReference<EntityBoomerang> reference;
        return playerIn == null || playerIn.field_71075_bZ.field_75098_d || (reference = boomerangOwners.get(playerIn)) == null || (boomerang = (EntityBoomerang)((Object)reference.get())) == null || boomerang.field_70128_L;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        List list = PotionUtils.func_185189_a((ItemStack)stack);
        if (!list.isEmpty()) {
            PotionUtils.func_185182_a((ItemStack)stack, tooltip, (float)0.125f);
        }
    }

    static {
        XUEnchantment.makeMutuallyExclusive(DIGGING, EXPLODE);
    }
}

