/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.power.ClientPower;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.player.IPlayerPowerCreator;
import com.rwtema.extrautils2.power.player.PlayerPower;
import com.rwtema.extrautils2.utils.Lang;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAngelRing
extends XUItemFlatMetadata
implements IPlayerPowerCreator {
    public static final String[] textures = new String[]{"angelring_base", "angelring_feather", "angelring_butterfly", "angelring_demon", "angelring_golden", "angelring_bat"};
    public static final int POWER = 32;
    public static TObjectIntHashMap<String> serverFlyingPlayers = new TObjectIntHashMap(5, 0.5f, -1);
    public static TObjectIntHashMap<String> clientFlyingPlayers = new TObjectIntHashMap(5, 0.5f, -1);

    public ItemAngelRing() {
        super(textures);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Override
    public void getSubItemsBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i < 6; ++i) {
            subItems.add(new ItemStack(itemIn, 1, i));
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 0x3FFFFFFE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, playerIn, tooltip, advanced);
        tooltip.add(Lang.translateArgs("Uses %s GP", 32));
        tooltip.add(ClientPower.powerStatusString());
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nonnull
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        NBTTagCompound tag = new NBTTagCompound();
        location.func_189511_e(tag);
        tag.func_74757_a("Invulnerable", true);
        location.func_70020_e(tag);
        return null;
    }

    @Override
    public PlayerPower createPower(EntityPlayer player, ItemStack params) {
        return new PlayerPowerAngelRing(player, params.func_77952_i());
    }

    @NetworkHandler.XUPacket
    public static class PacketAngelRingNotifier
    extends XUPacketServerToClient {
        String username;
        int wingType;

        public PacketAngelRingNotifier() {
        }

        public PacketAngelRingNotifier(String player, int wing) {
            this.username = player;
            this.wingType = wing;
        }

        @Override
        public void writeData() throws Exception {
            this.writeString(this.username);
            this.data.writeByte(this.wingType);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.username = this.readString();
            this.wingType = this.data.readByte();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Runnable doStuffClient() {
            return new Runnable(){

                @Override
                public void run() {
                    if (wingType > 0) {
                        clientFlyingPlayers.put((Object)username, wingType);
                    } else {
                        clientFlyingPlayers.remove((Object)username);
                    }
                }
            };
        }
    }

    public static class PlayerPowerAngelRing
    extends PlayerPower {
        int type;
        boolean wasFlying = false;
        String name;
        int power;

        public PlayerPowerAngelRing(EntityPlayer referent, int type) {
            super(referent);
            this.name = referent.func_146103_bH().getName();
            this.type = type;
        }

        @Override
        public float power(EntityPlayer playerMP) {
            return this.power;
        }

        @Override
        public void powerChanged(boolean powered) {
            if (this.invalid) {
                return;
            }
            EntityPlayerMP entityPlayerMP = this.getPlayerMP();
            if (entityPlayerMP.func_175149_v()) {
                return;
            }
            if (entityPlayerMP.field_71075_bZ.field_75098_d) {
                powered = true;
            }
            if (entityPlayerMP.field_71075_bZ.field_75101_c != powered) {
                entityPlayerMP.field_71075_bZ.field_75101_c = powered;
                if (!powered) {
                    entityPlayerMP.field_71075_bZ.field_75100_b = false;
                }
                entityPlayerMP.func_71016_p();
            }
        }

        @Override
        @Nonnull
        public String getName() {
            return ((ItemAngelRing)XU2Entries.angelRing.value).func_77658_a() + ".name";
        }

        @Override
        public void onAdd() {
            if (!this.getPlayer().func_175149_v()) {
                if (PowerManager.instance.isPowered(this.getPlayerMP())) {
                    this.getPlayer().field_71075_bZ.field_75101_c = true;
                }
                this.getPlayer().func_71016_p();
            }
            serverFlyingPlayers.put((Object)this.name, this.type);
            NetworkHandler.sendToAllPlayers(new PacketAngelRingNotifier(this.name, this.type));
        }

        @Override
        public void onRemove() {
            EntityPlayer player = this.getPlayer();
            if (!this.getPlayer().func_175149_v() && !player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
                player.func_71016_p();
            }
            serverFlyingPlayers.remove((Object)this.name);
            NetworkHandler.sendToAllPlayers(new PacketAngelRingNotifier(this.name, 0));
        }

        @Override
        public void update(boolean selected, ItemStack params) {
            if (this.invalid) {
                return;
            }
            int t = params.func_77952_i();
            if (!serverFlyingPlayers.containsKey((Object)this.name) || selected && serverFlyingPlayers.get((Object)this.name) != t) {
                serverFlyingPlayers.put((Object)this.name, this.type);
                NetworkHandler.sendToAllPlayers(new PacketAngelRingNotifier(this.name, t));
            }
            EntityPlayerMP player = this.getPlayerMP();
            if (this.getPlayer().func_175149_v()) {
                return;
            }
            if (!player.field_71075_bZ.field_75101_c && PowerManager.instance.isPowered(player)) {
                player.field_71075_bZ.field_75101_c = true;
                player.func_71016_p();
            }
            if (player.field_71075_bZ.field_75100_b) {
                this.wasFlying = true;
                this.power = 32;
            }
            if (this.wasFlying) {
                if (player.field_70122_E) {
                    this.wasFlying = false;
                    this.power = 0;
                }
                this.power = 32;
            } else {
                this.power = 0;
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void tickClient() {
        }
    }
}

