/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.dimensions.workhousedim;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.save.SaveManager;
import com.rwtema.extrautils2.backend.save.SaveModule;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.SpecialDimCompat;
import com.rwtema.extrautils2.dimensions.XUWorldProvider;
import com.rwtema.extrautils2.dimensions.workhousedim.ChunkProviderSpecialDim;
import com.rwtema.extrautils2.utils.XURandom;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.NullHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldProviderSpecialDim
extends XUWorldProvider {
    public static final int DIST_BETWEEN_CHUNKS = 6;
    public static final NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> diggingChunks = new NBTSerializable.NBTCollection<ChunkPos, HashSet<ChunkPos>, NBTTagLong>(new HashSet(), chunkPos -> new NBTTagLong((long)chunkPos.field_77276_a << 32 | (long)chunkPos.field_77275_b & 0xFFFFFFFFL), nbtTagLong -> {
        long c = nbtTagLong.func_150291_c();
        return new ChunkPos((int)(c >> 32), (int)c);
    });
    static final Set<BiomeDictionary.Type> blacklist = ImmutableSet.of((Object)BiomeDictionary.Type.NETHER, (Object)BiomeDictionary.Type.END);
    public static Biome biome = null;
    public static boolean isEnd = false;
    public static boolean isNether = false;
    public static Long seedOverride = null;
    static List<Biome> suitableBiomes = null;
    static WorldProvider tempWorldHolder;
    static IBlockState BORDER_STATE;
    private ChunkProviderSpecialDim chunkProviderSpecialDim;

    public WorldProviderSpecialDim() {
        super(XU2Entries.specialdim);
        this.field_76576_e = true;
        SaveManager.saveModules.add(new DigLocationsSaveModule());
        MinecraftForge.EVENT_BUS.register(WorldProviderSpecialDim.class);
    }

    @Nonnull
    private static List<Biome> buildBiomesList() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        block0: for (Biome biome : Biome.field_185377_q) {
            for (BiomeDictionary.Type type : CompatHelper.getTypesForBiome(biome)) {
                if (!blacklist.contains(type)) continue;
                continue block0;
            }
            biomes.add(biome);
        }
        return biomes;
    }

    @SubscribeEvent
    public static void preventTeleportation(EntityTravelToDimensionEvent event) {
    }

    @SubscribeEvent
    public static void preventSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getWorld().field_73011_w instanceof WorldProviderSpecialDim) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void preventSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getWorld().field_73011_w instanceof WorldProviderSpecialDim) {
            event.setCanceled(true);
        }
    }

    private static void resetChunkBlocks(World world, int x, int z) {
        Chunk chunk = world.func_72964_e(x, z);
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        for (ClassInheritanceMultiMap entityList : entityLists) {
            for (Entity entity : entityList) {
                if (entity instanceof EntityPlayer) continue;
                entity.func_70106_y();
            }
        }
        for (TileEntity tileEntity : CollectionHelper.wrapConcurrentErrorReport(chunk.func_177434_r().values())) {
            tileEntity.func_145843_s();
        }
        chunk.func_177434_r().clear();
        WorldProviderSpecialDim provider = (WorldProviderSpecialDim)WorldProviderSpecialDim.getWorld().field_73011_w;
        chunk.func_76602_a(provider.chunkProviderSpecialDim.func_185932_a(x, z).func_76587_i());
        for (ExtendedBlockStorage extendedBlockStorage : chunk.func_76587_i()) {
            if (extendedBlockStorage == null || extendedBlockStorage.func_76661_k() != null) continue;
            extendedBlockStorage.func_76659_c(new NibbleArray());
        }
        chunk.func_177446_d(true);
        chunk.func_76630_e();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseChunk(ChunkPos pos) {
        NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> nBTCollection = diggingChunks;
        synchronized (nBTCollection) {
            ((Set)WorldProviderSpecialDim.diggingChunks.collection).remove(pos);
            ChunkPos chunkPos = WorldProviderSpecialDim.adjustChunkRef(pos);
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    WorldProviderSpecialDim.resetChunkBlocks((World)WorldProviderSpecialDim.getWorld(), chunkPos.field_77276_a + dx, chunkPos.field_77275_b + dz);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChunkPos prepareNewChunk(Biome targetBiome) {
        NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> nBTCollection = diggingChunks;
        synchronized (nBTCollection) {
            ChunkPos pos = new ChunkPos(0, 0);
            int i = 0;
            int n = 1;
            boolean z = false;
            Dir d = Dir.RIGHT;
            while (((Set)WorldProviderSpecialDim.diggingChunks.collection).contains(pos)) {
                pos = new ChunkPos(pos.field_77276_a + d.dx, pos.field_77275_b + d.dz);
                if (++i != n) continue;
                i = 0;
                if (z) {
                    ++n;
                }
                z = !z;
                d = d.getNext();
            }
            ((Set)WorldProviderSpecialDim.diggingChunks.collection).add(pos);
            WorldServer world = WorldProviderSpecialDim.getWorld();
            WorldProvider provider = world.field_73011_w;
            ChunkPos chunkPos = WorldProviderSpecialDim.adjustChunkRef(pos);
            ChunkProviderServer chunkProvider = world.func_72863_F();
            Object generator = chunkProvider.field_186029_c;
            try {
                isEnd = false;
                isNether = false;
                if (targetBiome != null) {
                    if (CompatHelper.isBiomeOfType(targetBiome, BiomeDictionary.Type.END)) {
                        generator = SpecialDimCompat.getEndGenerator(targetBiome, world);
                        isEnd = true;
                    } else if (CompatHelper.isBiomeOfType(targetBiome, BiomeDictionary.Type.NETHER)) {
                        isNether = true;
                        generator = SpecialDimCompat.getNetherGen(targetBiome, world);
                    }
                }
                seedOverride = XURandom.rand.nextLong();
                if (targetBiome == null) {
                    if (suitableBiomes == null) {
                        suitableBiomes = WorldProviderSpecialDim.buildBiomesList();
                    }
                    biome = XURandom.getRandomElement(suitableBiomes);
                } else {
                    biome = targetBiome;
                }
                if (isNether || isEnd) {
                    for (int dx = -2; dx <= 2; ++dx) {
                        for (int dz = -2; dz <= 2; ++dz) {
                            Chunk chunk = chunkProvider.func_186025_d(chunkPos.field_77276_a + dx, chunkPos.field_77275_b + dz);
                            BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
                            if (isEnd) {
                                IBlockState end_stone = Blocks.field_150377_bs.func_176223_P();
                                for (int ddx = 0; ddx < 16; ++ddx) {
                                    for (int ddz = 0; ddz < 16; ++ddz) {
                                        for (int ddy = 39; ddy < 60; ++ddy) {
                                            blockPos.func_181079_c(ddx, ddy, ddz);
                                            chunk.func_177436_a((BlockPos)blockPos, end_stone);
                                        }
                                    }
                                }
                                continue;
                            }
                            if (!isNether) continue;
                            IBlockState lava = Blocks.field_150353_l.func_176223_P();
                            IBlockState bedrock = Blocks.field_150357_h.func_176223_P();
                            IBlockState netherrack = Blocks.field_150424_aL.func_176223_P();
                            IBlockState soulsand = Blocks.field_150425_aM.func_176223_P();
                            for (int ddx = 0; ddx < 16; ++ddx) {
                                for (int ddz = 0; ddz < 16; ++ddz) {
                                    int dy;
                                    blockPos.func_181079_c(ddx, 0, ddz);
                                    chunk.func_177436_a((BlockPos)blockPos, bedrock);
                                    for (int dy2 = 1; dy2 < 20; ++dy2) {
                                        chunk.func_177436_a((BlockPos)blockPos, netherrack);
                                    }
                                    IBlockState lava1 = ddx == 0 || ddx == 15 || ddz == 0 || ddz == 15 ? lava : netherrack;
                                    for (dy = 20; dy < 30; ++dy) {
                                        blockPos.func_181079_c(ddx, dy, ddz);
                                        chunk.func_177436_a((BlockPos)blockPos, lava1);
                                    }
                                    blockPos.func_181079_c(ddx, 60, ddz);
                                    chunk.func_177436_a((BlockPos)blockPos, netherrack);
                                    blockPos.func_181079_c(ddx, 61, ddz);
                                    chunk.func_177436_a((BlockPos)blockPos, soulsand);
                                    for (dy = 90; dy < 255; ++dy) {
                                        blockPos.func_181079_c(ddx, dy, ddz);
                                        chunk.func_177436_a((BlockPos)blockPos, netherrack);
                                    }
                                    blockPos.func_181079_c(ddx, 255, ddz);
                                    chunk.func_177436_a((BlockPos)blockPos, bedrock);
                                }
                            }
                        }
                    }
                }
                WorldProviderSpecialDim.generate(chunkPos.field_77276_a, chunkPos.field_77275_b, chunkProvider, generator);
                WorldProviderSpecialDim.generate(chunkPos.field_77276_a, chunkPos.field_77275_b - 1, chunkProvider, generator);
                WorldProviderSpecialDim.generate(chunkPos.field_77276_a - 1, chunkPos.field_77275_b, chunkProvider, generator);
                WorldProviderSpecialDim.generate(chunkPos.field_77276_a - 1, chunkPos.field_77275_b - 1, chunkProvider, generator);
                if (isEnd || isNether) {
                    int x0 = (chunkPos.field_77276_a - 1 << 4) - 1;
                    int x1 = (chunkPos.field_77276_a - 1 << 4) + 32;
                    int z0 = (chunkPos.field_77275_b - 1 << 4) - 1;
                    int z1 = (chunkPos.field_77275_b - 1 << 4) + 32;
                    WorldProviderSpecialDim.addBorderColumnLine((World)world, x0, x0, z0, z1 - 1);
                    WorldProviderSpecialDim.addBorderColumnLine((World)world, x1, x1, z0, z1 - 1);
                    WorldProviderSpecialDim.addBorderColumnLine((World)world, x0, x1, z0, z0);
                    WorldProviderSpecialDim.addBorderColumnLine((World)world, x0, x1, z1, z1);
                }
            }
            catch (Exception e) {
                if (isEnd) {
                    throw new RuntimeException("Error while simulating End dimension with Quantum Quarry", e);
                }
                if (isNether) {
                    throw new RuntimeException("Error while simulating Nether dimension with Quantum Quarry", e);
                }
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                seedOverride = null;
                biome = null;
                if (isEnd) {
                    SpecialDimCompat.clearEndData(world, provider);
                }
                if (isNether) {
                    SpecialDimCompat.clearNetherData(world, provider);
                }
            }
            return pos;
        }
    }

    public static void addBorderColumn(World world, BlockPos.MutableBlockPos pos) {
        Chunk chunk = world.func_175726_f((BlockPos)pos);
        for (int i = 0; i < 256; ++i) {
            pos.func_185336_p(i);
            chunk.func_177436_a((BlockPos)pos, BORDER_STATE);
        }
    }

    public static void addBorderColumnLine(World world, int x0, int x1, int z0, int z1) {
        for (BlockPos.MutableBlockPos pos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)new BlockPos(x0, 0, z0), (BlockPos)new BlockPos(x1, 0, z1))) {
            WorldProviderSpecialDim.addBorderColumn(world, pos);
            pos.func_185336_p(0);
        }
    }

    private static void generate(int x, int z, ChunkProviderServer chunkProvider, Object generator) {
        Chunk chunk = chunkProvider.func_186025_d(x, z);
        for (ExtendedBlockStorage extendedBlockStorage : chunk.func_76587_i()) {
            if (extendedBlockStorage == null || NullHelper.nullable(extendedBlockStorage.func_76661_k()) != null) continue;
            extendedBlockStorage.func_76659_c(new NibbleArray());
        }
        int idForBiome = Biome.func_185362_a((Biome)biome);
        Arrays.fill(chunk.func_76605_m(), (byte)idForBiome);
        chunk.func_177446_d(true);
        SpecialDimCompat.populate(chunk, generator);
        chunk.func_76630_e();
        chunk.func_177446_d(true);
        for (ExtendedBlockStorage extendedBlockStorage : chunk.func_76587_i()) {
            if (extendedBlockStorage == null || NullHelper.nullable(extendedBlockStorage.func_76661_k()) != null) continue;
            extendedBlockStorage.func_76659_c(new NibbleArray());
        }
    }

    public static WorldServer getWorld() {
        return DimensionManager.getWorld((int)((DimensionType)XU2Entries.specialdim.value).func_186068_a());
    }

    public static ChunkPos adjustChunkRef(ChunkPos pos) {
        return new ChunkPos(pos.field_77276_a * 6, pos.field_77275_b * 6);
    }

    public boolean func_76567_e() {
        return false;
    }

    @Nonnull
    public ChunkProviderSpecialDim createChunkGenerator() {
        this.chunkProviderSpecialDim = new ChunkProviderSpecialDim(this.field_76579_a);
        return this.chunkProviderSpecialDim;
    }

    @Nonnull
    public Biome getBiomeForCoords(@Nonnull BlockPos pos) {
        if (biome != null) {
            return biome;
        }
        return super.getBiomeForCoords(pos);
    }

    public long getSeed() {
        Long seedOverride = WorldProviderSpecialDim.seedOverride;
        if (seedOverride != null) {
            return seedOverride;
        }
        return super.getSeed();
    }

    static {
        BORDER_STATE = Blocks.field_150357_h.func_176223_P();
    }

    private static class DigLocationsSaveModule
    extends SaveModule {
        public DigLocationsSaveModule() {
            super("special_dim_dig_s");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> nBTCollection = diggingChunks;
            synchronized (nBTCollection) {
                diggingChunks.deserializeNBT(nbt.func_150295_c("s", 4));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            NBTSerializable.NBTCollection<ChunkPos, Set<ChunkPos>, NBTTagLong> nBTCollection = diggingChunks;
            synchronized (nBTCollection) {
                nbt.func_74782_a("s", (NBTBase)diggingChunks.serializeNBT());
            }
        }

        @Override
        public void reset() {
            ((Set)WorldProviderSpecialDim.diggingChunks.collection).clear();
        }
    }

    static enum Dir {
        RIGHT(1, 0),
        UP(0, 1),
        LEFT(-1, 0),
        DOWN(0, -1);

        final int dx;
        final int dz;
        Dir next;

        private Dir(int dx, int dz) {
            this.dx = dx;
            this.dz = dz;
        }

        public Dir getNext() {
            if (this.next == null) {
                this.next = Dir.values()[(this.ordinal() + 1) % 4];
            }
            return this.next;
        }
    }
}

