/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.dimensions.deep_dark;

import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.dimensions.XUWorldProvider;
import com.rwtema.extrautils2.dimensions.deep_dark.ChunkProviderDeepDark;
import com.rwtema.extrautils2.utils.Lang;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class WorldProviderDeepDark
extends XUWorldProvider {
    ChunkProviderDeepDark chunkProviderDeepDark;

    public WorldProviderDeepDark() {
        super(XU2Entries.deep_dark);
        this.field_76575_d = false;
        this.field_76576_e = false;
        this.field_76576_e = true;
    }

    @SubscribeEvent
    public static void tickStart(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        World worldObj = event.player.field_70170_p;
        if (!worldObj.field_72995_K && worldObj.func_82737_E() % 10L == 0L && worldObj.field_73011_w instanceof WorldProviderDeepDark && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int time = 0;
            NBTTagCompound entityData = player.getEntityData();
            if (entityData.func_74764_b("XU2|DarkTimer")) {
                time = entityData.func_74762_e("XU2|DarkTimer");
            }
            if ((double)CompatHelper.getBrightness((Entity)player) < 0.03) {
                if (time > 100) {
                    player.func_70097_a((DamageSource)DamageSourceDarkness.darkness, 1.0f);
                } else {
                    ++time;
                }
            } else if (time > 0) {
                --time;
            }
            if (time > 0) {
                entityData.func_74768_a("XU2|DarkTimer", time);
            } else {
                entityData.func_82580_o("XU2|DarkTimer");
            }
        }
    }

    @SubscribeEvent
    public static void noMobs(LivingSpawnEvent.CheckSpawn event) {
        EntityLivingBase eventEntity;
        if (event.getResult() == Event.Result.DEFAULT && event.getWorld().field_73011_w instanceof WorldProviderDeepDark && (eventEntity = event.getEntityLiving()) instanceof EntityMob) {
            if (event.getWorld().field_73012_v.nextDouble() < Math.min(0.95, eventEntity.field_70163_u / 80.0)) {
                event.setResult(Event.Result.DENY);
            } else {
                EntityMob entity = (EntityMob)eventEntity;
                IAttributeInstance t = entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
                t.func_111128_a(t.func_111125_b() * 2.0);
                entity.func_70691_i((float)t.func_111126_e());
                t = entity.func_110148_a(SharedMonsterAttributes.field_111264_e);
                t.func_111128_a(t.func_111125_b() * 2.0);
            }
        }
    }

    public long getSeed() {
        int i;
        if (this.chunkProviderDeepDark != null && (i = this.chunkProviderDeepDark.seedOffset) != 0) {
            return super.getSeed() * 31L + (long)i;
        }
        return super.getSeed();
    }

    public int func_76557_i() {
        return 81;
    }

    public boolean func_76568_b(int x, int z) {
        return true;
    }

    public boolean func_76561_g() {
        return false;
    }

    public boolean func_76567_e() {
        return false;
    }

    public boolean func_76569_d() {
        return false;
    }

    public boolean func_76566_a(int x, int z) {
        return false;
    }

    @Nullable
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        return null;
    }

    @Nonnull
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return new Vec3d(1.0E-5, 1.0E-5, 1.0E-5);
    }

    public float func_76563_a(long par1, float par3) {
        int j = 18000;
        float f1 = ((float)j + par3) / 24000.0f - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    @Override
    @Nonnull
    public String getWelcomeMessage() {
        return Lang.translate("Entering the Deep Dark!");
    }

    @Nonnull
    public ChunkProviderDeepDark createChunkGenerator() {
        this.chunkProviderDeepDark = new ChunkProviderDeepDark(this.field_76579_a, this.getSeed());
        return this.chunkProviderDeepDark;
    }

    protected void func_76556_a() {
        float f = 0.0f;
        for (int i = 0; i <= 15; ++i) {
            float p = (float)i / 15.0f;
            float f1 = 1.0f - p;
            this.field_76573_f[i] = p / (f1 * 3.0f + 1.0f);
            if (!(this.field_76573_f[i] < 0.2f)) continue;
            int n = i;
            this.field_76573_f[n] = this.field_76573_f[n] * (this.field_76573_f[i] / 0.2f);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(WorldProviderDeepDark.class);
    }

    public static class DamageSourceDarkness
    extends DamageSource {
        public static DamageSourceDarkness darkness = new DamageSourceDarkness();

        protected DamageSourceDarkness() {
            super("darkness");
            this.func_76348_h();
        }
    }
}

