/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.compatibility;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.backend.entries.EntryHandler;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.compatibility.NonNullListWrapper;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MyCreativeTabs
extends CreativeTabs
implements Comparator<ItemStack> {
    public MyCreativeTabs() {
        super("extrautils2");
    }

    @SideOnly(value=Side.CLIENT)
    @ItemStackNonNull
    public ItemStack func_151244_d() {
        if (XU2Entries.angelBlock.enabled) {
            return super.func_151244_d();
        }
        return this.func_78016_d();
    }

    @Nonnull
    public ItemStack func_78016_d() {
        if (XU2Entries.angelBlock.enabled) {
            return XU2Entries.angelBlock.newStack();
        }
        ArrayList stacks = Lists.newArrayList();
        for (Entry activeEntry : EntryHandler.activeEntries) {
            stacks.addAll(activeEntry.getCreativeStacks());
        }
        int n = stacks.size();
        if (n == 0) {
            throw new IllegalStateException("No active entries");
        }
        Random random = new Random(Minecraft.func_71386_F() / 1024L / 4L);
        int i = random.nextInt(n);
        return (ItemStack)stacks.get(i);
    }

    public boolean func_78023_l() {
        return super.func_78023_l();
    }

    public void func_78018_a(@Nonnull NonNullList<ItemStack> itemStacks) {
        ArrayList newList = Lists.newArrayList();
        super.func_78018_a(new NonNullListWrapper(newList));
        newList.sort(this);
        itemStacks.addAll((Collection)newList);
    }

    @Override
    public int compare(ItemStack o1, ItemStack o2) {
        int i = -Boolean.compare(this.isBlock(o1), this.isBlock(o2));
        if (i != 0) {
            return i;
        }
        i = new ItemStack(o1.func_77973_b()).func_82833_r().compareTo(new ItemStack(o2.func_77973_b()).func_82833_r());
        if (i != 0) {
            return i;
        }
        return o1.func_82833_r().compareTo(o2.func_82833_r());
    }

    public boolean isBlock(ItemStack a) {
        return a.func_77973_b() instanceof ItemBlock;
    }
}

