/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.compatibility.ICompatPerspectiveAwareModel;
import com.rwtema.extrautils2.utils.client.GLState;
import com.rwtema.extrautils2.utils.helpers.NullHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class MutableModel
implements ICompatPerspectiveAwareModel {
    public final List<BakedQuad> generalQuads = Lists.newArrayList();
    public final ImmutableList<ArrayList<BakedQuad>> sidedQuads = ImmutableList.of((Object)Lists.newArrayList(), (Object)Lists.newArrayList(), (Object)Lists.newArrayList(), (Object)Lists.newArrayList(), (Object)Lists.newArrayList(), (Object)Lists.newArrayList());
    public final EnumMap<ItemCameraTransforms.TransformType, Pair<? extends IBakedModel, Matrix4f>> transformMap;
    public boolean ambientOcclusion;
    public TextureAtlasSprite tex;
    public boolean isGui3D;
    ItemOverrideList overrideList = new ItemOverrideList((List)ImmutableList.of()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            return originalModel;
        }
    };
    private List<GLState<?>> states;

    public MutableModel(EnumMap<ItemCameraTransforms.TransformType, Matrix4f> type) {
        this.transformMap = Transforms.createMap(this, type);
    }

    public void clear() {
        this.tex = null;
        this.states = null;
        this.generalQuads.clear();
        for (ArrayList sidedQuad : this.sidedQuads) {
            sidedQuad.clear();
        }
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == null) {
            return ImmutableList.copyOf(this.generalQuads);
        }
        return ImmutableList.copyOf((Collection)((Collection)this.sidedQuads.get(side.func_176745_a())));
    }

    public boolean func_177555_b() {
        return this.ambientOcclusion;
    }

    public void addGLState(GLState<?> state) {
        if (this.states == null) {
            this.states = new ArrayList();
        }
        this.states.add(state);
    }

    public boolean func_177556_c() {
        return this.isGui3D;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        TextureAtlasSprite tex = this.tex;
        if (tex == null) {
            for (BakedQuad quad : this.generalQuads) {
                tex = NullHelper.nullable(quad.func_187508_a());
                if (tex == null) continue;
                return tex;
            }
            for (ArrayList sidedQuad : this.sidedQuads) {
                for (BakedQuad quad : sidedQuad) {
                    tex = NullHelper.nullable(quad.func_187508_a());
                    if (tex == null) continue;
                    return tex;
                }
            }
        }
        return tex == null ? Textures.MISSING_SPRITE : tex;
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.handleGLStates();
        return this.transformMap.get(cameraTransformType);
    }

    public void handleGLStates() {
        if (this.states != null && "Client thread".equals(Thread.currentThread().getName())) {
            for (GLState<?> state : this.states) {
                state.setValue();
            }
        }
    }

    public Iterable<BakedQuad> getAllQuads() {
        return Iterables.concat(this.generalQuads, (Iterable)Iterables.concat(this.sidedQuads));
    }

    public void rotateY(float x, float z, float t) {
        float c = MathHelper.func_76134_b((float)t);
        float s = MathHelper.func_76126_a((float)t);
        for (BakedQuad quad : this.getAllQuads()) {
            int[] data = quad.func_178209_a();
            for (int i = 0; i < 28; i += 7) {
                float ax = Float.intBitsToFloat(data[i]) - x;
                float az = Float.intBitsToFloat(data[i + 2]) - z;
                data[i] = Float.floatToRawIntBits(x + ax * c - az * s);
                data[i + 2] = Float.floatToRawIntBits(z + ax * s + az * c);
            }
        }
    }
}

