/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.metal;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice1;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import flaxbeard.immersivepetroleum.common.Config;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.MultiblockPumpjack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPumpjack
extends TileEntityMultiblockMetal<TileEntityPumpjack, IMultiblockRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IGuiTile {
    public FluidTank fakeTank = new FluidTank(0);
    public boolean wasActive = false;
    public float activeTicks = 0.0f;
    private int pipeTicks = 0;
    private boolean lastHadPipes = true;
    public IBlockState state = null;

    public TileEntityPumpjack() {
        super((MultiblockHandler.IMultiblock)MultiblockPumpjack.instance, new int[]{4, 6, 3}, 16000, true);
    }

    public boolean canExtract() {
        return true;
    }

    public int availableOil() {
        return PumpjackHandler.getFluidAmount(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    public Fluid availableFluid() {
        return PumpjackHandler.getFluid(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    public int getResidualOil() {
        return PumpjackHandler.getResidualFluid(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    public void extractOil(int amount) {
        PumpjackHandler.depleteFluid(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4, amount);
    }

    private boolean hasPipes() {
        if (!Config.IPConfig.Extraction.req_pipes) {
            return true;
        }
        BlockPos basePos = this.func_174877_v().func_177967_a(this.getFacing(), 4);
        for (int y = basePos.func_177956_o() - 2; y > 0; --y) {
            BlockPos pos = new BlockPos(basePos.func_177958_n(), y, basePos.func_177952_p());
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_150357_h) {
                return true;
            }
            if (Utils.isBlockAt((World)this.field_145850_b, (BlockPos)pos, (Block)IEContent.blockMetalDevice1, (int)BlockTypes_MetalDevice1.FLUID_PIPE.getMeta())) continue;
            return false;
        }
        return true;
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        ItemStack stack;
        super.readCustomNBT(nbt, descPacket);
        boolean lastActive = this.wasActive;
        this.wasActive = nbt.func_74767_n("wasActive");
        this.lastHadPipes = nbt.func_74767_n("lastHadPipes");
        if (!this.wasActive && lastActive) {
            this.activeTicks += 1.0f;
        }
        this.state = null;
        if (nbt.func_74764_b("comp") && !(stack = new ItemStack(nbt.func_74775_l("comp"))).func_190926_b()) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            this.state = block.func_176223_P();
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("wasActive", this.wasActive);
        nbt.func_74757_a("lastHadPipes", this.lastHadPipes);
        if (this.availableFluid() != null && this.availableFluid().getBlock() != null) {
            ItemStack stack = new ItemStack(this.availableFluid().getBlock());
            NBTTagCompound comp = new NBTTagCompound();
            stack.func_77955_b(comp);
            nbt.func_74782_a("comp", (NBTBase)comp);
        }
    }

    public void func_73660_a() {
        this.update(true);
    }

    public void update(boolean consumePower) {
        int extracted;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || this.isDummy()) {
            if (this.field_145850_b.field_72995_K && !this.isDummy() && this.state != null && this.wasActive) {
                BlockPos particlePos = this.func_174877_v().func_177967_a(this.facing, 4);
                float r1 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                float r2 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 2.0f;
                this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)((float)particlePos.func_177958_n() + 0.5f), (double)particlePos.func_177956_o(), (double)((float)particlePos.func_177952_p() + 0.5f), (double)(r1 * 0.04f), 0.25, (double)(r2 * 0.025f), new int[]{Block.func_176210_f((IBlockState)this.state)});
            }
            if (this.wasActive && consumePower) {
                this.activeTicks += 1.0f;
            }
            return;
        }
        boolean active = false;
        int consumed = Config.IPConfig.Extraction.pumpjack_consumption;
        int n = extracted = consumePower ? this.energyStorage.extractEnergy(consumed, true) : consumed;
        if (extracted >= consumed && this.canExtract() && !this.isRSDisabled()) {
            if ((this.func_174877_v().func_177958_n() + this.func_174877_v().func_177952_p()) % Config.IPConfig.Extraction.pipe_check_ticks == this.pipeTicks) {
                this.lastHadPipes = this.hasPipes();
            }
            if (this.lastHadPipes) {
                int residual = this.getResidualOil();
                if (this.availableOil() > 0 || residual > 0) {
                    int drained;
                    int accepted;
                    int oilAmnt = this.availableOil() <= 0 ? residual : this.availableOil();
                    this.energyStorage.extractEnergy(consumed, false);
                    active = true;
                    FluidStack out = new FluidStack(this.availableFluid(), Math.min(Config.IPConfig.Extraction.pumpjack_speed, oilAmnt));
                    BlockPos outputPos = this.func_174877_v().func_177967_a(this.facing, 2).func_177967_a(this.facing.func_176746_e().func_176734_d(), 2).func_177967_a(EnumFacing.DOWN, 1);
                    IFluidHandler output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outputPos, (EnumFacing)this.facing);
                    if (output != null && (accepted = output.fill(out, false)) > 0) {
                        drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
                        this.extractOil(drained);
                        out = Utils.copyFluidStackWithAmount((FluidStack)out, (int)(out.amount - drained), (boolean)false);
                    }
                    if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)(outputPos = this.func_174877_v().func_177967_a(this.facing, 2).func_177967_a(this.facing.func_176746_e(), 2).func_177967_a(EnumFacing.DOWN, 1)), (EnumFacing)this.facing)) != null && (accepted = output.fill(out, false)) > 0) {
                        drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
                        this.extractOil(drained);
                    }
                    this.activeTicks += 1.0f;
                }
            }
            this.pipeTicks = (this.pipeTicks + 1) % Config.IPConfig.Extraction.pipe_check_ticks;
        }
        if (active != this.wasActive) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        this.wasActive = active;
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.func_176746_e();
        if (this.mirrored) {
            fw = fw.func_176734_d();
        }
        int y = this.field_174879_c / 16;
        int x = this.field_174879_c % 16 / 4;
        int z = this.field_174879_c % 4;
        if (this.field_174879_c == 0) {
            float minZ;
            float maxX;
            float minX;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            float f = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.125f : (minX = fl == EnumFacing.WEST ? 0.625f : 0.125f);
            float f2 = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.25f : (maxX = fl == EnumFacing.WEST ? 0.875f : 0.375f);
            float f3 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.125f : (minZ = fl == EnumFacing.NORTH ? 0.625f : 0.125f);
            float maxZ = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.25f : (fl == EnumFacing.NORTH ? 0.875f : 0.375f);
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            minX = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.75f : minX;
            maxX = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.875f : maxX;
            minZ = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.75f : minZ;
            maxZ = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.875f : maxZ;
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 18) {
            float minZ;
            float maxX;
            float minX;
            float f = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : (minX = fl == EnumFacing.WEST ? 0.5f : 0.0f);
            float f4 = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : (maxX = fl == EnumFacing.WEST ? 1.0f : 0.5f);
            float f5 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : (minZ = fl == EnumFacing.NORTH ? 0.5f : 0.0f);
            float maxZ = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : (fl == EnumFacing.NORTH ? 1.0f : 0.5f);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c >= 3 && this.field_174879_c <= 14 && this.field_174879_c != 10 && this.field_174879_c != 13 && this.field_174879_c != 11 && this.field_174879_c != 9 || this.field_174879_c == 1) {
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 13) {
            float minX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : 0.3125f;
            float maxX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : 0.685f;
            float minZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : 0.3125f;
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : 0.685f;
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.875, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 10) {
            float minZ;
            float maxX;
            float minX;
            float f = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.3125f : (minX = fl == EnumFacing.EAST ? 0.6875f : 0.0f);
            float f6 = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.685f : (maxX = fl == EnumFacing.EAST ? 1.0f : 0.3125f);
            float f7 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.3125f : (minZ = fl == EnumFacing.SOUTH ? 0.6875f : 0.0f);
            float maxZ = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.685f : (fl == EnumFacing.SOUTH ? 1.0f : 0.3125f);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.875, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            minX = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : 0.3125f;
            maxX = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : 0.6875f;
            minZ = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : 0.3125f;
            maxZ = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : 0.6875f;
            list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.875, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 16) {
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 22) {
            float minX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : 0.25f;
            float maxX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : 0.75f;
            float minZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : 0.25f;
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : 0.75f;
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, -0.75, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 40) {
            float minX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : 0.25f;
            float maxX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : 0.75f;
            float minZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : 0.25f;
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : 0.75f;
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 0.25, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 27) {
            float minZ;
            float maxX;
            float minX;
            EnumFacing enumFacing = fl = this.mirrored ? this.facing.func_176734_d() : this.facing;
            float f = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.7f : (minX = fl == EnumFacing.NORTH ? 0.6f : -0.1f);
            float f8 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.4f : (maxX = fl == EnumFacing.NORTH ? 1.1f : 0.4f);
            float f9 = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.7f : (minZ = fl == EnumFacing.EAST ? 0.6f : -0.1f);
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.4f : (fl == EnumFacing.EAST ? 1.1f : 0.4f);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, -0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            float f10 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? -0.4f : (minX = fl == EnumFacing.NORTH ? 0.6f : -0.1f);
            float f11 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.3f : (maxX = fl == EnumFacing.NORTH ? 1.1f : 0.4f);
            float f12 = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? -0.4f : (minZ = fl == EnumFacing.EAST ? 0.6f : -0.1f);
            maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.3f : (fl == EnumFacing.EAST ? 1.1f : 0.4f);
            list.add(new AxisAlignedBB((double)minX, -0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 29) {
            float minZ;
            float maxX;
            float minX;
            EnumFacing enumFacing = fl = this.mirrored ? this.facing.func_176734_d() : this.facing;
            float f = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.7f : (minX = fl == EnumFacing.SOUTH ? 0.6f : -0.1f);
            float f13 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.4f : (maxX = fl == EnumFacing.SOUTH ? 1.1f : 0.4f);
            float f14 = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.7f : (minZ = fl == EnumFacing.WEST ? 0.6f : -0.1f);
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.4f : (fl == EnumFacing.WEST ? 1.1f : 0.4f);
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, -0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            float f15 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? -0.4f : (minX = fl == EnumFacing.SOUTH ? 0.6f : -0.1f);
            float f16 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.3f : (maxX = fl == EnumFacing.SOUTH ? 1.1f : 0.4f);
            float f17 = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? -0.4f : (minZ = fl == EnumFacing.WEST ? 0.6f : -0.1f);
            maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.3f : (fl == EnumFacing.WEST ? 1.1f : 0.4f);
            list.add(new AxisAlignedBB((double)minX, -0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 45) {
            float minZ;
            float maxX;
            float minX;
            EnumFacing enumFacing = fl = this.mirrored ? this.facing.func_176734_d() : this.facing;
            float f = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : (minX = fl == EnumFacing.NORTH ? 0.8f : -0.2f);
            float f18 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : (maxX = fl == EnumFacing.NORTH ? 1.2f : 0.2f);
            float f19 = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : (minZ = fl == EnumFacing.EAST ? 0.8f : -0.2f);
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.EAST ? 1.2f : 0.2f);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 47) {
            float minZ;
            float maxX;
            float minX;
            EnumFacing enumFacing = fl = this.mirrored ? this.facing.func_176734_d() : this.facing;
            float f = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : (minX = fl == EnumFacing.NORTH ? -0.2f : 0.8f);
            float f20 = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : (maxX = fl == EnumFacing.NORTH ? 0.2f : 1.2f);
            float f21 = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : (minZ = fl == EnumFacing.EAST ? -0.2f : 0.8f);
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.EAST ? 0.2f : 1.2f);
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 63 || this.field_174879_c == 65) {
            return new ArrayList<AxisAlignedBB>();
        }
        if (this.field_174879_c == 58 || this.field_174879_c == 61 || this.field_174879_c == 64 || this.field_174879_c == 67) {
            float minX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : 0.25f;
            float maxX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : 0.75f;
            float minZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : 0.25f;
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : 0.75f;
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, -0.25, (double)minZ, (double)maxX, 0.75, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 70) {
            float minX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : 0.125f;
            float maxX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : 0.875f;
            float minZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : 0.125f;
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : 0.875f;
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.25, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 52) {
            float minX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 0.0f : 0.125f;
            float maxX = fl == EnumFacing.EAST || fl == EnumFacing.WEST ? 1.0f : 0.875f;
            float minZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 0.0f : 0.125f;
            float maxZ = fl == EnumFacing.NORTH || fl == EnumFacing.SOUTH ? 1.0f : 0.875f;
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.25, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        return list;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        ArrayList list = new ArrayList();
        return this.getAdvancedSelectionBounds();
    }

    public int[] getEnergyPos() {
        return new int[]{20};
    }

    public int[] getRedstonePos() {
        return new int[]{18};
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return new int[]{1};
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return 0;
    }

    public TileEntity getGuiMaster() {
        return this.master();
    }

    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    public IFluidTank[] getInternalTanks() {
        return null;
    }

    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityPumpjack master = this.master();
        if (master != null) {
            if (this.field_174879_c == 9 && (side == null || side == this.facing.func_176746_e() || side == this.facing.func_176734_d().func_176746_e())) {
                return new FluidTank[]{this.fakeTank};
            }
            if (this.field_174879_c == 11 && (side == null || side == this.facing.func_176746_e() || side == this.facing.func_176734_d().func_176746_e())) {
                return new FluidTank[]{this.fakeTank};
            }
            if (this.field_174879_c == 16 && Config.IPConfig.Extraction.req_pipes && (side == null || side == EnumFacing.DOWN)) {
                return new FluidTank[]{this.fakeTank};
            }
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    public boolean isDummy() {
        return true;
    }

    public TileEntityPumpjack master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return this;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(-this.offset[0], -this.offset[1], -this.offset[2]));
        return ((Object)((Object)this)).getClass().isInstance(te) ? (TileEntityPumpjack)te : null;
    }

    public TileEntityPumpjack getTileForPos(int targetPos) {
        BlockPos target = this.getBlockPosForPos(targetPos);
        TileEntity tile = this.field_145850_b.func_175625_s(target);
        return tile instanceof TileEntityPumpjack ? (TileEntityPumpjack)tile : null;
    }

    public static class TileEntityPumpjackParent
    extends TileEntityPumpjack {
        @SideOnly(value=Side.CLIENT)
        public AxisAlignedBB getRenderBoundingBox() {
            BlockPos nullPos = this.func_174877_v();
            return new AxisAlignedBB(nullPos.func_177967_a(this.facing, -2).func_177967_a(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e(), -1).func_177979_c(1), nullPos.func_177967_a(this.facing, 5).func_177967_a(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e(), 2).func_177981_b(3));
        }

        @Override
        public boolean isDummy() {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public double func_145833_n() {
            return super.func_145833_n() * Config.IEConfig.increasedTileRenderdistance;
        }
    }
}

