/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.items.ItemIPBase;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemOilCan
extends ItemIPBase {
    public ItemOilCan(String name) {
        super(name, 1, new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        if (fs != null) {
            TextFormatting rarity = fs.getFluid().getRarity() == EnumRarity.COMMON ? TextFormatting.GRAY : fs.getFluid().getRarity().field_77937_e;
            tooltip.add(rarity + fs.getLocalizedName() + TextFormatting.GRAY + ": " + fs.amount + "/" + 8000 + "mB");
        } else {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.empty", (Object[])new Object[0]));
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target instanceof EntityIronGolem) {
            int amountNeeded;
            EntityIronGolem golem = (EntityIronGolem)target;
            FluidHandlerItemStack handler = (FluidHandlerItemStack)FluidUtil.getFluidHandler((ItemStack)stack);
            if (handler.getFluid() != null && LubricantHandler.isValidLube(handler.getFluid().getFluid()) && handler.getFluid().amount >= (amountNeeded = LubricantHandler.getLubeAmount(handler.getFluid().getFluid()) * 5 * 20)) {
                player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
                golem.func_70606_j(Math.max(golem.func_110143_aJ() + 2.0f, golem.func_110138_aP()));
                golem.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 1200, 1));
                golem.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 1200, 1));
                if (!player.func_184812_l_()) {
                    handler.drain(amountNeeded, true);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        this.func_111207_a(stack, null, target, EnumHand.MAIN_HAND);
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EnumActionResult ret = EnumActionResult.PASS;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            ret = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null))) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        } else {
            int amountNeeded;
            FluidHandlerItemStack handler = (FluidHandlerItemStack)FluidUtil.getFluidHandler((ItemStack)stack);
            if (handler.getFluid() != null && LubricantHandler.isValidLube(handler.getFluid().getFluid()) && handler.getFluid().amount >= (amountNeeded = LubricantHandler.getLubeAmount(handler.getFluid().getFluid()) * 5 * 20) && LubricatedHandler.lubricateTile(world.func_175625_s(pos), 600)) {
                player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    handler.drain(amountNeeded, true);
                }
            }
        }
        return ret;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"jerrycanDrain") || FluidUtil.getFluidContained((ItemStack)stack) != null;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"jerrycanDrain")) {
            ItemStack ret = stack.func_77946_l();
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ret);
            handler.drain(ItemNBTHelper.getInt((ItemStack)ret, (String)"jerrycanDrain"), true);
            ItemNBTHelper.remove((ItemStack)ret, (String)"jerrycanDrain");
            return ret;
        }
        if (FluidUtil.getFluidContained((ItemStack)stack) != null) {
            ItemStack ret = stack.func_77946_l();
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ret);
            handler.drain(1000, true);
            return ret;
        }
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, 8000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && LubricantHandler.isValidLube(fluid.getFluid());
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

