/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.lighting.LC;
import codechicken.lib.lighting.LightMatrix;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.CCRenderPipeline;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.ColourAttribute;
import codechicken.lib.render.pipeline.attribute.LightCoordAttribute;
import codechicken.lib.render.pipeline.attribute.LightingAttribute;
import codechicken.lib.render.pipeline.attribute.NormalAttribute;
import codechicken.lib.render.pipeline.attribute.SideAttribute;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CCRenderState {
    private static int nextOperationIndex;
    public final VertexAttribute<Vector3[]> normalAttrib = new NormalAttribute();
    public final VertexAttribute<int[]> colourAttrib = new ColourAttribute();
    public final VertexAttribute<int[]> lightingAttrib = new LightingAttribute();
    public final VertexAttribute<int[]> sideAttrib = new SideAttribute();
    public final VertexAttribute<LC[]> lightCoordAttrib = new LightCoordAttribute();
    private static final ThreadLocal<CCRenderState> instances;
    private static final CCRenderState bakingRenderState;
    public IVertexSource model;
    public int firstVertexIndex;
    public int lastVertexIndex;
    public int vertexIndex;
    public CCRenderPipeline pipeline;
    @SideOnly(value=Side.CLIENT)
    public BufferBuilder r;
    @SideOnly(value=Side.CLIENT)
    public VertexFormat fmt;
    public int baseColour;
    public int alphaOverride;
    public boolean computeLighting;
    public LightMatrix lightMatrix = new LightMatrix();
    public final Vertex5 vert = new Vertex5();
    public final Vector3 normal = new Vector3();
    public int colour;
    public int brightness;
    public int side;
    public LC lc = new LC();
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite sprite;

    public static int registerOperation() {
        return nextOperationIndex++;
    }

    public static int operationCount() {
        return nextOperationIndex;
    }

    private CCRenderState() {
        this.pipeline = new CCRenderPipeline(this);
    }

    public static CCRenderState instance() {
        return instances.get();
    }

    public static CCRenderState getBakingRenderState() {
        return bakingRenderState;
    }

    public void reset() {
        this.model = null;
        this.pipeline.reset();
        this.computeLighting = true;
        this.alphaOverride = -1;
        this.baseColour = -1;
    }

    public void preRenderWorld(IBlockAccess world, BlockPos pos) {
        this.reset();
        this.colour = -1;
        this.setBrightness(world, pos);
    }

    public void setPipeline(IVertexOperation ... ops) {
        this.pipeline.setPipeline(ops);
    }

    public void setPipeline(IVertexSource model, int start, int end, IVertexOperation ... ops) {
        this.pipeline.reset();
        this.pipeline.forceFormatAttributes = false;
        this.setModel(model, start, end);
        this.pipeline.forceFormatAttributes = true;
        this.pipeline.setPipeline(ops);
    }

    public void bindModel(IVertexSource model) {
        if (this.model != model) {
            this.model = model;
            this.pipeline.rebuild();
        }
    }

    public void setModel(IVertexSource source) {
        this.setModel(source, 0, source.getVertices().length);
    }

    public void setModel(IVertexSource source, int start, int end) {
        this.bindModel(source);
        this.setVertexRange(start, end);
    }

    public void setVertexRange(int start, int end) {
        this.firstVertexIndex = start;
        this.lastVertexIndex = end;
    }

    public void renderQuads(List<BakedQuad> quads) {
        BufferBuilder buffer = this.startDrawing(7, quads.get(0).getFormat());
        for (BakedQuad quad : quads) {
            buffer.func_178981_a(quad.func_178209_a());
        }
        this.draw();
    }

    public void render(IVertexOperation ... ops) {
        this.setPipeline(ops);
        this.render();
    }

    public void render() {
        Vertex5[] verts = this.model.getVertices();
        this.vertexIndex = this.firstVertexIndex;
        while (this.vertexIndex < this.lastVertexIndex) {
            this.model.prepareVertex(this);
            this.vert.set(verts[this.vertexIndex]);
            this.runPipeline();
            this.writeVert();
            ++this.vertexIndex;
        }
    }

    public void runPipeline() {
        this.pipeline.operate();
    }

    public void writeVert() {
        if (this.r instanceof BakingVertexBuffer) {
            ((BakingVertexBuffer)this.r).setSprite(this.sprite);
        }
        block7: for (int e = 0; e < this.fmt.func_177345_h(); ++e) {
            VertexFormatElement fmte = this.fmt.func_177348_c(e);
            switch (fmte.func_177375_c()) {
                case POSITION: {
                    this.r.func_181662_b(this.vert.vec.x, this.vert.vec.y, this.vert.vec.z);
                    continue block7;
                }
                case UV: {
                    if (fmte.func_177369_e() == 0) {
                        this.r.func_187315_a(this.vert.uv.u, this.vert.uv.v);
                        continue block7;
                    }
                    this.r.func_187314_a(this.brightness >> 16 & 0xFFFF, this.brightness & 0xFFFF);
                    continue block7;
                }
                case COLOR: {
                    if (this.r.isColorDisabled()) {
                        this.r.func_181667_k();
                        continue block7;
                    }
                    this.r.func_181669_b(this.colour >>> 24, this.colour >> 16 & 0xFF, this.colour >> 8 & 0xFF, this.alphaOverride >= 0 ? this.alphaOverride : this.colour & 0xFF);
                    continue block7;
                }
                case NORMAL: {
                    this.r.func_181663_c((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
                    continue block7;
                }
                case PADDING: {
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException("Generic vertex format element");
                }
            }
        }
        this.r.func_181675_d();
    }

    public void pushColour() {
        GlStateManager.func_179131_c((float)((float)(this.colour >>> 24) / 255.0f), (float)((float)(this.colour >> 16 & 0xFF) / 255.0f), (float)((float)(this.colour >> 8 & 0xFF) / 255.0f), (float)((float)(this.alphaOverride >= 0 ? this.alphaOverride : this.colour & 0xFF) / 255.0f));
    }

    public void setBrightness(IBlockAccess world, BlockPos pos) {
        this.brightness = world.func_180495_p(pos).func_177230_c().func_185484_c(world.func_180495_p(pos), world, pos);
    }

    public void pullLightmap() {
        this.brightness = (int)OpenGlHelper.lastBrightnessY << 16 | (int)OpenGlHelper.lastBrightnessX;
    }

    public void pushLightmap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(this.brightness & 0xFFFF), (float)(this.brightness >>> 16));
    }

    public void setFluidColour(FluidStack fluidStack) {
        this.setFluidColour(fluidStack, 255);
    }

    public void setFluidColour(FluidStack fluidStack, int alpha) {
        this.baseColour = fluidStack.getFluid().getColor(fluidStack) << 8 | alpha;
    }

    public void setColour(Colour colour) {
        this.colour = colour.rgba();
    }

    public ColourRGBA getColour() {
        return new ColourRGBA(this.colour);
    }

    @SideOnly(value=Side.CLIENT)
    public BufferBuilder startDrawing(int mode, VertexFormat format) {
        BufferBuilder r = Tessellator.func_178181_a().func_178180_c();
        r.func_181668_a(mode, format);
        this.bind(r);
        return r;
    }

    @SideOnly(value=Side.CLIENT)
    public BufferBuilder startDrawing(int mode, VertexFormat format, BufferBuilder buffer) {
        buffer.func_181668_a(mode, format);
        this.bind(buffer);
        return buffer;
    }

    @SideOnly(value=Side.CLIENT)
    public void bind(BufferBuilder r) {
        this.r = r;
        this.fmt = r.func_178973_g();
    }

    @SideOnly(value=Side.CLIENT)
    public BufferBuilder getBuffer() {
        return this.r;
    }

    @SideOnly(value=Side.CLIENT)
    public VertexFormat getVertexFormat() {
        return this.fmt;
    }

    public void draw() {
        Tessellator.func_178181_a().func_78381_a();
    }

    public boolean isDrawing() {
        if (this.r != null) {
            return this.r.field_179010_r;
        }
        return Tessellator.func_178181_a().func_178180_c().field_179010_r;
    }

    static {
        instances = ThreadLocal.withInitial(CCRenderState::new);
        bakingRenderState = new CCRenderState();
    }
}

