/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.reflect;

import codechicken.lib.reflect.ObfMapping;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.objectweb.asm.Type;

public class ReflectionManager {
    private static Field modifiersField;

    public static boolean isStatic(int modifiers) {
        return (modifiers & 8) != 0;
    }

    public static boolean isStatic(Method method) {
        return ReflectionManager.isStatic(method.getModifiers());
    }

    public static boolean isStatic(Field field) {
        return ReflectionManager.isStatic(field.getModifiers());
    }

    public static Class<?> findClass(ObfMapping mapping, boolean init) {
        try {
            return Class.forName(mapping.javaClass(), init, ReflectionManager.class.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> findClass(ObfMapping mapping) {
        return ReflectionManager.findClass(mapping, true);
    }

    public static boolean classExists(ObfMapping mapping) {
        return ReflectionManager.findClass(mapping, false) != null;
    }

    public static Class<?> findClass(String name) {
        return ReflectionManager.findClass(new ObfMapping(name.replace(".", "/")), true);
    }

    public static void setField(ObfMapping mapping, Object instance, Object value) {
        try {
            Field field = ReflectionManager.getField(mapping);
            field.setAccessible(true);
            ReflectionManager.removeFinal(field);
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callMethod(ObfMapping mapping, Class<R> returnType, Object instance, Object ... params) {
        try {
            return ReflectionManager.callMethod_Unsafe(mapping, returnType, instance, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callMethod_Unsafe(ObfMapping mapping, Class<R> returnType, Object instance, Object ... params) throws InvocationTargetException, IllegalAccessException {
        mapping.toRuntime();
        Class<?> clazz = ReflectionManager.findClass(mapping);
        Method method = null;
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.getName().equals(mapping.s_name) || !Type.getMethodDescriptor((Method)m).equals(mapping.s_desc)) continue;
            method = m;
            break;
        }
        if (method != null) {
            method.setAccessible(true);
            return (R)method.invoke(instance, params);
        }
        return null;
    }

    public static <R> R newInstance(ObfMapping mapping, Class<R> returnType, Object ... params) {
        try {
            return ReflectionManager.newInstance_Unsafe(mapping, returnType, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R newInstance_Unsafe(ObfMapping mapping, Class<R> returnType, Object ... params) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> clazz = ReflectionManager.findClass(mapping);
        Constructor<?> constructor = null;
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            if (!Type.getConstructorDescriptor(c).equals(mapping.s_desc)) continue;
            constructor = c;
            break;
        }
        if (constructor != null) {
            constructor.setAccessible(true);
            return (R)constructor.newInstance(params);
        }
        return null;
    }

    public static boolean hasField(ObfMapping mapping) {
        try {
            ReflectionManager.getField_Unsafe(mapping);
            return true;
        }
        catch (NoSuchFieldException nfe) {
            return false;
        }
    }

    public static <R> R getField(ObfMapping mapping, Object instance, Class<R> clazz) {
        try {
            Field field = ReflectionManager.getField(mapping);
            return (R)field.get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(ObfMapping mapping) {
        mapping.toRuntime();
        try {
            return ReflectionManager.getField_Unsafe(mapping);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField_Unsafe(ObfMapping mapping) throws NoSuchFieldException {
        mapping.toRuntime();
        Class<?> clazz = ReflectionManager.findClass(mapping);
        Field field = clazz.getDeclaredField(mapping.s_name);
        field.setAccessible(true);
        ReflectionManager.removeFinal(field);
        return field;
    }

    public static void removeFinal(Field field) {
        if ((field.getModifiers() & 0x10) == 0) {
            return;
        }
        try {
            if (modifiersField == null) {
                modifiersField = ReflectionManager.getField(new ObfMapping("java/lang/reflect/Field", "modifiers"));
                modifiersField.setAccessible(true);
            }
            modifiersField.set(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

