/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.loader.blockstate;

import codechicken.lib.internal.CCLLog;
import codechicken.lib.model.loader.blockstate.CCFinalMultiVariant;
import codechicken.lib.model.loader.blockstate.CCFinalVariant;
import codechicken.lib.model.loader.blockstate.CCVariant;
import codechicken.lib.reflect.ObfMapping;
import codechicken.lib.reflect.ReflectionManager;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.TransformUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class CCBlockStateLoader {
    public static final Gson VARIANT_GSON = new GsonBuilder().registerTypeAdapter(CCVariant.class, (Object)new CCVariant.Deserializer()).create();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    public static CCBlockStateLoader INSTANCE = new CCBlockStateLoader();
    public Map<ResourceLocation, ModelBlockDefinition> blockDefinitions = new HashMap<ResourceLocation, ModelBlockDefinition>();
    public Map<ModelResourceLocation, IModel> toBake = new LinkedHashMap<ModelResourceLocation, IModel>();
    public VariantLoader VARIANT_LOADER = new VariantLoader();
    private Map<ResourceLocation, Exception> exceptions;
    private ModelLoader modelLoader;

    public static void initialize() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        Loader.instance().getActiveModList().forEach(CCBlockStateLoader::loadFactories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFactories(ModContainer mod) {
        BufferedReader reader;
        FileSystem fs;
        block9: {
            fs = null;
            reader = null;
            try {
                Path filePath = null;
                String toResolve = "/assets/" + mod.getModId() + "/cc_blockstates/_factories.json";
                if (mod.getSource().isFile()) {
                    fs = FileSystems.newFileSystem(mod.getSource().toPath(), null);
                    filePath = fs.getPath(toResolve, new String[0]);
                } else if (mod.getSource().isDirectory()) {
                    filePath = mod.getSource().toPath().resolve(toResolve);
                }
                if (filePath == null || !Files.exists(filePath, new LinkOption[0])) break block9;
                reader = Files.newBufferedReader(filePath);
                try {
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    JsonObject object = (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
                    CCBlockStateLoader.parseFactory(mod, object);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read Factories Json!", e);
                }
            }
            catch (IOException e) {
                try {
                    CCLLog.log(Level.ERROR, e, "Failed to load Factories Json for mod %s!", mod.getModId());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((Closeable[])new Closeable[]{fs, reader});
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable[])new Closeable[]{fs, reader});
            }
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{fs, reader});
    }

    private static void parseFactory(ModContainer mod, JsonObject object) {
        if (object.has("transforms")) {
            TransformUtils.loadTransformFactory(mod, object.getAsJsonObject("transforms"));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (!event.getMap().getBasePath().equals("textures")) {
            CCLLog.log(Level.WARN, "Someone is calling the TextureStitchEvent.Pre for a texture map that is NOT vanillas.");
            CCLLog.log(Level.WARN, "This is a bug. There is no sense of different atlas's in vanilla so this event is NOT generic and specific to the vanilla atlas.");
            CCLLog.log(Level.WARN, "Im catching this so things don't explode. Fix your shit!");
            CCLLog.big(Level.WARN, 100, "", new Object[0]);
            return;
        }
        this.grabLoader();
        this.loadBakery(this.modelLoader.field_177610_k.func_178120_a(), this.modelLoader.field_177598_f);
        this.toBake.values().forEach(model -> model.getTextures().forEach(arg_0 -> ((TextureMap)event.getMap()).func_174942_a(arg_0)));
    }

    public void loadBakery(BlockStateMapper mapper, IResourceManager manager) {
        this.blockDefinitions.clear();
        this.toBake.clear();
        List blocks = StreamSupport.stream(ForgeRegistries.BLOCKS.spliterator(), false).filter(block -> block.getRegistryName() != null).collect(Collectors.toList());
        blocks.sort(Comparator.comparing(b -> b.getRegistryName().toString()));
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"CCL ModelLoading: Blocks", (int)blocks.size());
        for (Block block2 : blocks) {
            bar.step(block2.getRegistryName().toString());
            for (ResourceLocation location : mapper.func_188182_a(block2)) {
                ModelBlockDefinition definition;
                if (!CCBlockStateLoader.canLoad(manager, location) || (definition = this.getMBD(location)) == null) continue;
                if (definition.func_188002_b()) {
                    throw new RuntimeException("BlockState file parsed by CCL appears to have Multipart data.. " + location.toString());
                }
                Map map = mapper.func_188181_b(block2);
                for (Map.Entry entry : map.entrySet()) {
                    IModel model;
                    ModelResourceLocation modelLocation = (ModelResourceLocation)entry.getValue();
                    if (!location.equals((Object)modelLocation)) continue;
                    WrappedMRL wrapped = WrappedMRL.from(modelLocation);
                    try {
                        model = this.VARIANT_LOADER.loadModel(wrapped);
                    }
                    catch (Exception e) {
                        model = ModelLoaderRegistry.getMissingModel();
                        this.storeException((ResourceLocation)modelLocation, e);
                    }
                    this.toBake.put(modelLocation, model);
                }
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        List items = StreamSupport.stream(ForgeRegistries.ITEMS.spliterator(), false).filter(block -> block.getRegistryName() != null).collect(Collectors.toList());
        items.sort(Comparator.comparing(item -> item.getRegistryName().toString()));
        bar = ProgressManager.push((String)"CCL ModelLoading: Items", (int)items.size());
        for (Item item2 : items) {
            bar.step(item2.getRegistryName().toString());
            for (String s : this.modelLoader.func_177596_a(item2)) {
                IModel model;
                ModelResourceLocation invLoc = ModelLoader.getInventoryVariant((String)s);
                if (!CCBlockStateLoader.canLoad(manager, (ResourceLocation)invLoc)) continue;
                WrappedMRL wrapped = WrappedMRL.from(invLoc);
                try {
                    model = this.VARIANT_LOADER.loadModel(wrapped);
                }
                catch (Exception e) {
                    model = ModelLoaderRegistry.getMissingModel();
                    this.storeException(wrapped, e);
                }
                this.toBake.put(wrapped.to(), model);
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onModelBake(ModelBakeEvent event) {
        IModel missingIModel = ModelLoaderRegistry.getMissingModel();
        IBakedModel missingModel = missingIModel.bake(missingIModel.getDefaultState(), DefaultVertexFormats.field_176599_b, TextureUtils.bakedTextureGetter);
        HashMap<IModel, IBakedModel> bakedModels = new HashMap<IModel, IBakedModel>();
        HashMultimap models = HashMultimap.create();
        Multimaps.invertFrom((Multimap)Multimaps.forMap(this.toBake), (Multimap)models);
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"CCL ModelLoading: Baking", (int)models.keySet().size());
        for (IModel iModel : models.keySet()) {
            bar.step(String.format("[%s]", Joiner.on((String)", ").join((Iterable)models.get((Object)iModel))));
            if (iModel == missingIModel) {
                bakedModels.put(iModel, missingModel);
                continue;
            }
            bakedModels.put(iModel, iModel.bake(iModel.getDefaultState(), DefaultVertexFormats.field_176599_b, TextureUtils.bakedTextureGetter));
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        for (Map.Entry entry : this.toBake.entrySet()) {
            event.getModelRegistry().func_82595_a(entry.getKey(), bakedModels.get(entry.getValue()));
        }
    }

    private void storeException(ResourceLocation location, Exception exception) {
        this.exceptions.put(location, exception);
    }

    private void grabLoader() {
        ObfMapping mapping = new ObfMapping("net/minecraftforge/client/model/ModelLoader$VanillaLoader", "INSTANCE");
        Object object = ReflectionManager.getField(mapping, null, Object.class);
        mapping = new ObfMapping("net/minecraftforge/client/model/ModelLoader$VanillaLoader", "getLoader", "()Lnet/minecraftforge/client/model/ModelLoader;");
        this.modelLoader = ReflectionManager.callMethod(mapping, ModelLoader.class, object, new Object[0]);
        mapping = new ObfMapping("net/minecraftforge/client/model/ModelLoader", "loadingExceptions");
        this.exceptions = ReflectionManager.getField(mapping, this.modelLoader, Map.class);
    }

    private static ResourceLocation getBlockStateLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "cc_blockstates/" + location.func_110623_a() + ".json");
    }

    private static boolean canLoad(IResourceManager resourceManager, ResourceLocation location) {
        ResourceLocation fileLocation = CCBlockStateLoader.getBlockStateLocation(location);
        if (!fileLocation.toString().endsWith("_factories.json")) {
            try {
                resourceManager.func_135056_b(fileLocation);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public ModelBlockDefinition getMBD(ResourceLocation location) {
        return this.blockDefinitions.computeIfAbsent(CCBlockStateLoader.getBlockStateLocation(location), this::loadMBD);
    }

    public ModelBlockDefinition loadMBD(ResourceLocation file) {
        ArrayList<ModelBlockDefinition> list = new ArrayList<ModelBlockDefinition>();
        try {
            for (IResource resource : this.modelLoader.field_177598_f.func_135056_b(file)) {
                list.add(CCBlockStateLoader.load(resource.func_110527_b()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered an exception when loading model definition of model " + file, e);
        }
        if (list.isEmpty()) {
            return null;
        }
        return new ModelBlockDefinition(list);
    }

    public static ModelBlockDefinition load(InputStream stream) {
        try {
            int marker;
            JsonParser parser = new JsonParser();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
            reader.setLenient(true);
            JsonObject object = parser.parse(reader).getAsJsonObject();
            if (JsonUtils.func_151204_g((JsonObject)object, (String)"ccl_marker") && (marker = JsonUtils.func_151203_m((JsonObject)object, (String)"ccl_marker")) == 1) {
                HashSet<String> variantSets = new HashSet<String>();
                HashSet<String> missingVariants = new HashSet<String>();
                LinkedHashMap<String, Map<String, CCVariant>> variants = new LinkedHashMap<String, Map<String, CCVariant>>();
                LinkedHashMap<String, Map<String, Map<String, CCVariant>>> subModels = new LinkedHashMap<String, Map<String, Map<String, CCVariant>>>();
                LinkedHashMap<String, CCVariant> compiledVariants = new LinkedHashMap<String, CCVariant>();
                LinkedHashMap<String, Map<String, CCVariant>> compiledSubModelVariants = new LinkedHashMap<String, Map<String, CCVariant>>();
                HashSet<String> possibleCombos = new HashSet<String>();
                for (JsonElement element : object.getAsJsonArray("variant_sets")) {
                    variantSets.add(element.getAsString());
                }
                if (object.has("missing_variants")) {
                    for (JsonElement element : object.getAsJsonArray("missing_variants")) {
                        missingVariants.add(element.getAsString());
                    }
                }
                String textureDomain = "";
                if (object.has("texture_domain")) {
                    textureDomain = object.get("texture_domain").getAsString();
                }
                CCVariant defaultVariant = null;
                if (object.has("defaults")) {
                    defaultVariant = (CCVariant)VARIANT_GSON.fromJson(object.get("defaults"), CCVariant.class);
                }
                for (String string : missingVariants) {
                    String[] split = string.split("=");
                    Map valueMap = variants.computeIfAbsent(split[0], s -> new LinkedHashMap());
                    valueMap.put(split[1], new CCVariant());
                }
                CCBlockStateLoader.parseVariants(variants, object.getAsJsonObject("variants"));
                subModels.putAll(CCBlockStateLoader.parseSubModels(object.getAsJsonObject("sub_model")));
                for (String string : variantSets) {
                    Map<String, List<String>> variantValueMap = CCBlockStateLoader.generateVariantValueMap(Arrays.asList(string.split(",")), variants, subModels);
                    possibleCombos.addAll(CCBlockStateLoader.generatePossibleCombos(variantValueMap));
                }
                for (String string : possibleCombos) {
                    Map<String, String> kvArray = ArrayUtils.convertKeyValueArrayToMap(string.split(","));
                    Object finalVariant = new CCVariant();
                    if (defaultVariant != null) {
                        finalVariant = defaultVariant.copy();
                    }
                    compiledVariants.put(string, CCBlockStateLoader.compileVariant(((CCVariant)finalVariant).copy(), kvArray, variants));
                }
                for (Map.Entry entry : subModels.entrySet()) {
                    LinkedHashMap<String, CCVariant> compiledVariants2 = new LinkedHashMap<String, CCVariant>();
                    for (String var : possibleCombos) {
                        Map<String, String> kvArray = ArrayUtils.convertKeyValueArrayToMap(var.split(","));
                        CCVariant finalVariant = new CCVariant();
                        if (defaultVariant != null) {
                            finalVariant = defaultVariant.copy();
                        }
                        compiledVariants2.put(var, CCBlockStateLoader.compileVariant(finalVariant.copy(), kvArray, (Map)entry.getValue()));
                    }
                    compiledSubModelVariants.put((String)entry.getKey(), (Map<String, CCVariant>)compiledVariants2);
                }
                HashMap variantList = new HashMap();
                for (Map.Entry entry : compiledVariants.entrySet()) {
                    Map<String, CCVariant> subModelVariants = CCBlockStateLoader.getSubModelsForKey((String)entry.getKey(), compiledSubModelVariants);
                    ArrayList<Variant> vars = new ArrayList<Variant>();
                    CCVariant variant = (CCVariant)entry.getValue();
                    boolean hasSubModels = subModelVariants.size() != 0;
                    boolean uvLock = variant.uvLock.orElse(false);
                    boolean smooth = variant.smooth.orElse(true);
                    boolean gui3d = variant.gui3d.orElse(true);
                    int weight = variant.weight.orElse(1);
                    if (variant.hasModel() && !hasSubModels && !variant.hasTextures() && !variant.hasCustomData() && variant.state.get() instanceof ModelRotation) {
                        vars.add(new Variant(variant.model, (ModelRotation)variant.state.get(), uvLock, weight));
                    } else if (!hasSubModels) {
                        vars.add(new CCFinalVariant(variant.model, variant.state, uvLock, smooth, gui3d, weight, variant.textures, textureDomain, variant.customData));
                    } else {
                        vars.add(new CCFinalMultiVariant(variant, textureDomain, subModelVariants));
                    }
                    variantList.put(entry.getKey(), new VariantList(vars));
                }
                return new ModelBlockDefinition(variantList, null);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static Map<String, Map<String, CCVariant>> parseVariants(Map<String, Map<String, CCVariant>> variants, JsonObject variantElement) {
        for (Map.Entry variantsEntry : variantElement.entrySet()) {
            String variantName = (String)variantsEntry.getKey();
            Map variantValues = variants.computeIfAbsent(variantName, k -> new LinkedHashMap());
            for (Map.Entry variantEntry : ((JsonElement)variantsEntry.getValue()).getAsJsonObject().entrySet()) {
                String variantValue = (String)variantEntry.getKey();
                CCVariant variant = (CCVariant)VARIANT_GSON.fromJson((JsonElement)variantEntry.getValue(), CCVariant.class);
                variantValues.put(variantValue, variant);
            }
        }
        return variants;
    }

    public static Map<String, Map<String, Map<String, CCVariant>>> parseSubModels(JsonObject object) {
        LinkedHashMap<String, Map<String, Map<String, CCVariant>>> subModels = new LinkedHashMap<String, Map<String, Map<String, CCVariant>>>();
        if (object != null) {
            for (Map.Entry subModelEntry : object.entrySet()) {
                JsonObject variantObject = ((JsonElement)subModelEntry.getValue()).getAsJsonObject();
                Map variants = subModels.computeIfAbsent((String)subModelEntry.getKey(), (Function<String, Map<String, Map<String, CCVariant>>>)((Function<String, Map>)s -> new LinkedHashMap()));
                subModels.put((String)subModelEntry.getKey(), CCBlockStateLoader.parseVariants(variants, variantObject.getAsJsonObject("variants")));
            }
        }
        return subModels;
    }

    public static CCVariant compileVariant(CCVariant finalVariant, Map<String, String> kvArray, Map<String, Map<String, CCVariant>> variants) {
        Map<String, CCVariant> variantMap;
        for (Map.Entry<String, String> entry : kvArray.entrySet()) {
            for (Map.Entry<String, Map<String, CCVariant>> variantsEntry : variants.entrySet()) {
                if (!entry.getKey().equals(variantsEntry.getKey()) || !(variantMap = variantsEntry.getValue()).containsKey(entry.getValue())) continue;
                finalVariant = finalVariant.with(variantMap.get(entry.getValue()));
            }
        }
        for (Map.Entry<String, String> entry : kvArray.entrySet()) {
            for (Map.Entry<String, Map<String, CCVariant>> variantsEntry : variants.entrySet()) {
                if (!entry.getKey().equals(variantsEntry.getKey()) || !(variantMap = variantsEntry.getValue()).containsKey(entry.getValue())) continue;
                finalVariant = variantMap.get(entry.getValue()).applySubOverrides(finalVariant, kvArray);
            }
        }
        return finalVariant;
    }

    public static Map<String, CCVariant> getSubModelsForKey(String key, Map<String, Map<String, CCVariant>> subModels) {
        LinkedHashMap<String, CCVariant> subModelVariants = new LinkedHashMap<String, CCVariant>();
        for (Map.Entry<String, Map<String, CCVariant>> subModelEntry : subModels.entrySet()) {
            for (Map.Entry<String, CCVariant> variantEntry : subModelEntry.getValue().entrySet()) {
                if (!variantEntry.getKey().equals(key)) continue;
                subModelVariants.put(subModelEntry.getKey(), variantEntry.getValue());
            }
        }
        return subModelVariants;
    }

    public static Set<String> generatePossibleCombos(Map<String, List<String>> variantValueMap) {
        HashSet<String> possibleCombos = new HashSet<String>();
        ArrayList keys = Lists.newArrayList(variantValueMap.keySet());
        int comboCount = 1;
        for (String key : variantValueMap.keySet()) {
            comboCount *= variantValueMap.get(key).size();
        }
        int[] indexes = new int[variantValueMap.size()];
        for (int l = 0; l < comboCount; ++l) {
            for (int in = 0; in < indexes.length; ++in) {
                int n = in;
                indexes[n] = indexes[n] + 1;
                if (indexes[in] < variantValueMap.get(keys.get(in)).size()) break;
                indexes[in] = 0;
            }
            StringBuilder combo = new StringBuilder();
            for (int i = 0; i < indexes.length; ++i) {
                combo.append((String)keys.get(i)).append("=").append(variantValueMap.get(keys.get(i)).get(indexes[i])).append(",");
            }
            possibleCombos.add(combo.substring(0, combo.length() - 1));
        }
        return possibleCombos;
    }

    public static Map<String, List<String>> generateVariantValueMap(List<String> keys, Map<String, Map<String, CCVariant>> variants, Map<String, Map<String, Map<String, CCVariant>>> subModels) {
        LinkedHashMap<String, List<String>> variantValueMap = new LinkedHashMap<String, List<String>>();
        for (String variant : keys) {
            ArrayList<String> variantValues = new ArrayList<String>();
            for (String string : variants.keySet()) {
                if (string.equals(variant) && variants.containsKey(variant)) {
                    variantValues.addAll(variants.get(variant).keySet());
                }
                for (CCVariant subVariant : variants.get(string).values()) {
                    variantValues.addAll(subVariant.getPossibleVariantValues(variant));
                }
            }
            for (Map map : subModels.values()) {
                for (String variantName : map.keySet()) {
                    if (variantName.equals(variant) && map.containsKey(variant)) {
                        variantValues.addAll(((Map)map.get(variant)).keySet());
                    }
                    for (CCVariant subVariant : ((Map)map.get(variantName)).values()) {
                        variantValues.addAll(subVariant.getPossibleVariantValues(variant));
                    }
                }
            }
            variantValueMap.put(variant, variantValues);
        }
        return variantValueMap;
    }

    public static final class WeightedRandomModel
    implements IModel {
        private final List<Variant> variants;
        private final List<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        private final Set<ResourceLocation> textures = Sets.newHashSet();
        private final List<IModel> models = new ArrayList<IModel>();
        private final IModelState defaultState;

        public WeightedRandomModel(VariantList variants) throws Exception {
            this.variants = variants.func_188114_a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Variant v : this.variants) {
                ResourceLocation loc = v.func_188046_a();
                this.locations.add(loc);
                IModel model = loc.equals((Object)ModelBakery.field_177604_a) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel((ResourceLocation)loc);
                model = v.process(model);
                for (ResourceLocation location : model.getDependencies()) {
                    ModelLoaderRegistry.getModelOrMissing((ResourceLocation)location);
                }
                this.textures.addAll(model.getTextures());
                this.models.add(model);
                builder.add((Object)Pair.of((Object)model, (Object)v.getState()));
            }
            if (this.models.size() == 0) {
                IModel missing = ModelLoaderRegistry.getMissingModel();
                this.models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            this.defaultState = new MultiModelState(builder.build());
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        public Collection<ResourceLocation> getTextures() {
            return ImmutableSet.copyOf(this.textures);
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            if (!Attributes.moreSpecific((VertexFormat)format, (VertexFormat)Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
            }
            if (this.variants.size() == 1) {
                IModel model = this.models.get(0);
                return model.bake(MultiModelState.getPartState((IModelState)state, (IModel)model, (int)0), format, bakedTextureGetter);
            }
            WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
            for (int i = 0; i < this.variants.size(); ++i) {
                IModel model = this.models.get(i);
                builder.func_177677_a(model.bake(MultiModelState.getPartState((IModelState)state, (IModel)model, (int)i), format, bakedTextureGetter), this.variants.get(i).func_188047_d());
            }
            return builder.func_177676_a();
        }

        public IModelState getDefaultState() {
            return this.defaultState;
        }
    }

    private class VariantLoader
    implements ICustomModelLoader {
        private VariantLoader() {
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation instanceof WrappedMRL;
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            ModelResourceLocation location = ((WrappedMRL)modelLocation).to();
            ModelBlockDefinition definition = CCBlockStateLoader.this.getMBD((ResourceLocation)location);
            VariantList variants = definition.func_188004_c(location.func_177518_c());
            return new WeightedRandomModel(variants);
        }
    }

    private static class WrappedMRL
    extends ResourceLocation {
        private final String variant;

        public WrappedMRL(ModelResourceLocation modelResourceLocation) {
            super(modelResourceLocation.func_110624_b(), modelResourceLocation.func_110623_a());
            this.variant = modelResourceLocation.func_177518_c();
        }

        public ModelResourceLocation to() {
            return new ModelResourceLocation(this.func_110624_b() + ":" + this.func_110623_a(), this.variant);
        }

        public static WrappedMRL from(ModelResourceLocation loc) {
            return new WrappedMRL(loc);
        }

        public String getVariant() {
            return this.variant;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ModelResourceLocation && super.equals(other)) {
                ModelResourceLocation modelresourcelocation = (ModelResourceLocation)other;
                return this.variant.equals(modelresourcelocation.func_177518_c());
            }
            if (other instanceof WrappedMRL && super.equals(other)) {
                WrappedMRL modelResourceLocation = (WrappedMRL)((Object)other);
                return this.variant.equalsIgnoreCase(modelResourceLocation.variant);
            }
            return false;
        }

        public int hashCode() {
            return 31 * super.hashCode() + this.variant.hashCode();
        }

        public String toString() {
            return super.toString() + '#' + this.variant;
        }
    }
}

