/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery;

import codechicken.lib.internal.CCLLog;
import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.PlanarFaceBakery;
import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareBakedModel;
import codechicken.lib.model.bakedmodels.PerspectiveAwareLayeredModel;
import codechicken.lib.model.bakery.BlockBakeryProperties;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.model.bakery.generation.IBlockBakery;
import codechicken.lib.model.bakery.generation.IItemBakery;
import codechicken.lib.model.bakery.generation.ILayeredBlockBakery;
import codechicken.lib.model.bakery.generation.ISimpleBlockBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import codechicken.lib.model.bakery.key.IItemStackKeyGenerator;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.texture.IItemBlockTextureProvider;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.ResourceUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.util.VertexDataUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ModelBakery {
    private static boolean DEBUG = Boolean.parseBoolean(System.getProperty("ccl.debugBakeryLogging"));
    private static Cache<String, IBakedModel> keyModelCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static Map<Item, IItemStackKeyGenerator> itemKeyGeneratorMap = new HashMap<Item, IItemStackKeyGenerator>();
    private static Map<Block, IBlockStateKeyGenerator> blockKeyGeneratorMap = new HashMap<Block, IBlockStateKeyGenerator>();
    private static IBakedModel missingModel;
    public static final IBlockStateKeyGenerator defaultBlockKeyGenerator;
    public static final IItemStackKeyGenerator defaultItemKeyGenerator;

    public static void init() {
        ResourceUtils.registerReloadListener(resourceManager -> ModelBakery.nukeModelCache());
        ModelRegistryHelper.registerCallback(modelRegistry -> {
            missingModel = ModelLoaderRegistry.getMissingModel().bake((IModelState)TransformUtils.DEFAULT_BLOCK, DefaultVertexFormats.field_176599_b, TextureUtils.bakedTextureGetter);
        });
    }

    public static IBlockStateKeyGenerator getKeyGenerator(Block block) {
        if (blockKeyGeneratorMap.containsKey(block)) {
            return blockKeyGeneratorMap.get(block);
        }
        return defaultBlockKeyGenerator;
    }

    public static IItemStackKeyGenerator getKeyGenerator(Item item) {
        if (itemKeyGeneratorMap.containsKey(item)) {
            return itemKeyGeneratorMap.get(item);
        }
        return defaultItemKeyGenerator;
    }

    public static void registerBlockKeyGenerator(Block block, IBlockStateKeyGenerator generator) {
        if (blockKeyGeneratorMap.containsKey(block)) {
            throw new IllegalArgumentException("Unable to register IBlockStateKeyGenerator as one is already registered for block:" + block.getRegistryName());
        }
        blockKeyGeneratorMap.put(block, generator);
    }

    public static void registerItemKeyGenerator(Item item, IItemStackKeyGenerator generator) {
        if (itemKeyGeneratorMap.containsKey(item)) {
            throw new IllegalArgumentException("Unable to register IItemStackKeyGenerator as one is already registered for item: " + item.getRegistryName());
        }
        itemKeyGeneratorMap.put(item, generator);
    }

    public static IBlockState handleExtendedState(IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof IBakeryProvider) {
            IBakery bakery = ((IBakeryProvider)block).getBakery();
            if (bakery instanceof IBlockBakery) {
                return ((IBlockBakery)bakery).handleState(state, world, pos);
            }
            throw new IllegalStateException("ModelBakery.handleExtendedState called for block that implements IBakeryProvider but does not return a IBlockBakery in IBakeryProvider.getBakery()!");
        }
        if (block instanceof IWorldBlockTextureProvider) {
            IWorldBlockTextureProvider provider = (IWorldBlockTextureProvider)block;
            HashMap layerFaceSpriteMap = new HashMap();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!block.canRenderInLayer((IBlockState)state, layer)) continue;
                HashMap<EnumFacing, TextureAtlasSprite> faceSpriteMap = new HashMap<EnumFacing, TextureAtlasSprite>();
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    TextureAtlasSprite sprite = provider.getTexture(face, (IBlockState)state, layer, world, pos);
                    if (sprite == null) continue;
                    faceSpriteMap.put(face, sprite);
                }
                layerFaceSpriteMap.put(layer, faceSpriteMap);
            }
            state = state.withProperty((IUnlistedProperty)BlockBakeryProperties.LAYER_FACE_SPRITE_MAP, layerFaceSpriteMap);
        }
        return state;
    }

    public static IBakedModel getCachedItemModel(ItemStack stack) {
        IItemStackKeyGenerator generator = ModelBakery.getKeyGenerator(stack.func_77973_b());
        String key = generator.generateKey(stack);
        IBakedModel model = (IBakedModel)keyModelCache.getIfPresent((Object)key);
        if (model == null) {
            block5: {
                try {
                    model = ModelBakery.generateItemModel(stack);
                }
                catch (Throwable t) {
                    CCLLog.errorOnce(t, "ItemBaking", "Fatal exception thrown whilst baking item model for: " + stack, new Object[0]);
                    BakingVertexBuffer buffer = BakingVertexBuffer.create();
                    if (!buffer.field_179010_r) break block5;
                    buffer.func_178977_d();
                    buffer.func_178965_a();
                }
            }
            if (DEBUG) {
                CCLLog.log(Level.INFO, "Baking item model: " + key);
            }
            if (model != missingModel) {
                keyModelCache.put((Object)key, (Object)model);
            }
        }
        return model;
    }

    public static IBakedModel generateItemModel(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            if (block instanceof IBakeryProvider) {
                IBakery bakery = ((IBakeryProvider)block).getBakery();
                LinkedList<BakedQuad> generalQuads = new LinkedList<BakedQuad>();
                HashMap<EnumFacing, List<BakedQuad>> hashMap = new HashMap<EnumFacing, List<BakedQuad>>();
                generalQuads.addAll(((IItemBakery)bakery).bakeItemQuads(null, stack));
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                    quads.addAll(VertexDataUtils.shadeQuadFaces(((IItemBakery)bakery).bakeItemQuads(face, stack)));
                    hashMap.put(face, quads);
                }
                ModelProperties.PerspectiveProperties properties = ((IItemBakery)bakery).getModelProperties(stack);
                return new PerspectiveAwareBakedModel(hashMap, generalQuads, properties);
            }
            if (block instanceof IItemBlockTextureProvider) {
                IItemBlockTextureProvider provider = (IItemBlockTextureProvider)block;
                HashMap<EnumFacing, List<BakedQuad>> faceQuadMap = new HashMap<EnumFacing, List<BakedQuad>>();
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    LinkedList<BakedQuad> faceQuads = new LinkedList<BakedQuad>();
                    faceQuads.addAll(VertexDataUtils.shadeQuadFaces(PlanarFaceBakery.bakeFace(face, provider.getTexture(face, stack), DefaultVertexFormats.field_176599_b)));
                    faceQuadMap.put(face, faceQuads);
                }
                ModelProperties modelProperties = new ModelProperties(true, true, null);
                return new PerspectiveAwareBakedModel(faceQuadMap, (IModelState)TransformUtils.DEFAULT_BLOCK, modelProperties);
            }
        } else if (item instanceof IBakeryProvider) {
            IItemBakery bakery = (IItemBakery)((IBakeryProvider)item).getBakery();
            LinkedList<BakedQuad> generalQuads = new LinkedList<BakedQuad>();
            HashMap<EnumFacing, List<BakedQuad>> faceQuads = new HashMap<EnumFacing, List<BakedQuad>>();
            generalQuads.addAll(bakery.bakeItemQuads(null, stack));
            for (EnumFacing face : EnumFacing.field_82609_l) {
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                quads.addAll(bakery.bakeItemQuads(face, stack));
                faceQuads.put(face, quads);
            }
            ModelProperties.PerspectiveProperties perspectiveProperties = bakery.getModelProperties(stack);
            return new PerspectiveAwareBakedModel(faceQuads, generalQuads, perspectiveProperties);
        }
        return missingModel;
    }

    public static IBakedModel getCachedModel(IExtendedBlockState state) {
        if (state == null) {
            return missingModel;
        }
        IBlockStateKeyGenerator keyGenerator = ModelBakery.getKeyGenerator(state.func_177230_c());
        String key = keyGenerator.generateKey(state);
        IBakedModel model = (IBakedModel)keyModelCache.getIfPresent((Object)key);
        if (model == null) {
            block6: {
                try {
                    model = ModelBakery.generateModel(state);
                }
                catch (Throwable t) {
                    CCLLog.errorOnce(t, "BlockBaking", "Fatal exception thrown whilst baking block model for: " + state, new Object[0]);
                    BakingVertexBuffer buffer = BakingVertexBuffer.create();
                    if (!buffer.field_179010_r) break block6;
                    buffer.func_178977_d();
                    buffer.func_178965_a();
                }
            }
            if (DEBUG) {
                CCLLog.log(Level.INFO, "Baking block model: " + key);
            }
            if (model != missingModel) {
                keyModelCache.put((Object)key, (Object)model);
            }
        }
        return model;
    }

    public static IBakedModel generateModel(IExtendedBlockState state) {
        if (state.func_177230_c() instanceof IBakeryProvider) {
            IBlockBakery bakery = (IBlockBakery)((IBakeryProvider)state.func_177230_c()).getBakery();
            if (bakery instanceof ISimpleBlockBakery) {
                ISimpleBlockBakery simpleBakery = (ISimpleBlockBakery)bakery;
                LinkedList<BakedQuad> generalQuads = new LinkedList<BakedQuad>();
                HashMap<EnumFacing, List<BakedQuad>> faceQuads = new HashMap<EnumFacing, List<BakedQuad>>();
                generalQuads.addAll(simpleBakery.bakeQuads(null, state));
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                    quads.addAll(simpleBakery.bakeQuads(face, state));
                    faceQuads.put(face, quads);
                }
                ModelProperties modelProperties = new ModelProperties(true, true, null);
                return new PerspectiveAwareBakedModel(faceQuads, generalQuads, TransformUtils.DEFAULT_BLOCK, modelProperties);
            }
            if (bakery instanceof ILayeredBlockBakery) {
                ILayeredBlockBakery layeredBakery = (ILayeredBlockBakery)bakery;
                HashMap<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> layerFaceQuadMap = new HashMap<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>>();
                HashMap<BlockRenderLayer, List<BakedQuad>> layerGeneralQuads = new HashMap<BlockRenderLayer, List<BakedQuad>>();
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!state.func_177230_c().canRenderInLayer((IBlockState)state, layer)) continue;
                    LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                    quads.addAll(layeredBakery.bakeLayerFace(null, layer, state));
                    layerGeneralQuads.put(layer, quads);
                }
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!state.func_177230_c().canRenderInLayer((IBlockState)state, layer)) continue;
                    HashMap faceQuadMap = new HashMap();
                    for (EnumFacing face : EnumFacing.field_82609_l) {
                        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                        quads.addAll(layeredBakery.bakeLayerFace(face, layer, state));
                        faceQuadMap.put(face, quads);
                    }
                    layerFaceQuadMap.put(layer, faceQuadMap);
                }
                ModelProperties modelProperties = new ModelProperties(true, true, null);
                return new PerspectiveAwareLayeredModel(layerFaceQuadMap, layerGeneralQuads, new ModelProperties.PerspectiveProperties(TransformUtils.DEFAULT_BLOCK, modelProperties), BlockRenderLayer.SOLID);
            }
        }
        if (state.func_177230_c() instanceof IWorldBlockTextureProvider) {
            Map<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> layerFaceQuadMap = ModelBakery.generateLayerFaceQuadMap(state);
            ModelProperties properties = new ModelProperties(true, true, null);
            return new PerspectiveAwareLayeredModel(layerFaceQuadMap, new ModelProperties.PerspectiveProperties(TransformUtils.DEFAULT_BLOCK, properties));
        }
        return missingModel;
    }

    public static Map<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> generateLayerFaceQuadMap(IExtendedBlockState state) {
        Map layerFaceSpriteMap = (Map)state.getValue((IUnlistedProperty)BlockBakeryProperties.LAYER_FACE_SPRITE_MAP);
        HashMap<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> layerFaceQuadMap = new HashMap<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>>();
        for (BlockRenderLayer layer : layerFaceSpriteMap.keySet()) {
            Map faceSpriteMap = (Map)layerFaceSpriteMap.get(layer);
            HashMap faceQuadMap = new HashMap();
            for (EnumFacing face : faceSpriteMap.keySet()) {
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                quads.add(PlanarFaceBakery.bakeFace(face, (TextureAtlasSprite)faceSpriteMap.get(face)));
                faceQuadMap.put(face, quads);
            }
            layerFaceQuadMap.put(layer, faceQuadMap);
        }
        return layerFaceQuadMap;
    }

    public static void nukeModelCache() {
        keyModelCache.invalidateAll();
    }

    static {
        defaultBlockKeyGenerator = state -> {
            if (state.func_177230_c() instanceof IWorldBlockTextureProvider) {
                Map layerFaceSpriteMap = (Map)state.getValue((IUnlistedProperty)BlockBakeryProperties.LAYER_FACE_SPRITE_MAP);
                StringBuilder builder = new StringBuilder(state.func_177230_c().getRegistryName() + ",");
                for (Map.Entry layerEntry : layerFaceSpriteMap.entrySet()) {
                    builder.append(((BlockRenderLayer)layerEntry.getKey()).toString()).append(",");
                    for (Map.Entry faceSpriteEntry : ((Map)layerEntry.getValue()).entrySet()) {
                        builder.append(faceSpriteEntry.getKey()).append(",").append(((TextureAtlasSprite)faceSpriteEntry.getValue()).func_94215_i()).append(",");
                    }
                }
                return builder.toString();
            }
            return state.func_177230_c().getRegistryName().toString() + "|" + state.func_177230_c().func_176201_c((IBlockState)state);
        };
        defaultItemKeyGenerator = stack -> stack.func_77973_b().getRegistryName().toString() + "|" + stack.func_77960_j();
    }
}

