/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui;

import codechicken.lib.colour.Colour;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Mouse;

public class GuiDraw {
    public static final GuiHook gui = new GuiHook();
    public static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;

    public static void drawRect(int x, int y, int w, int h, int colour) {
        GuiDraw.drawGradientRect(x, y, w, h, colour, colour);
    }

    public static void drawGradientRectDirect(int left, int top, int right, int bottom, int colour1, int colour2) {
        gui.func_73733_a(left, top, right, bottom, colour1, colour2);
    }

    public static void drawGradientRect(int x, int y, int w, int h, int colour1, int colour2) {
        gui.func_73733_a(x, y, x + w, y + h, colour1, colour2);
    }

    public static void drawTexturedModalRect(int x, int y, int tx, int ty, int w, int h) {
        gui.func_73729_b(x, y, tx, ty, w, h);
    }

    public static void drawLine(int x1, int y1, int x2, int y2, float thickness, int colour) {
        GlStateManager.func_187441_d((float)thickness);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Colour.glColourARGB(colour);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        vb.func_181662_b((double)x1, (double)y1, (double)gui.getZLevel()).func_181675_d();
        vb.func_181662_b((double)x2, (double)y2, (double)gui.getZLevel()).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179117_G();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    public static void drawString(String text, int x, int y, int colour, boolean shadow) {
        if (shadow) {
            fontRenderer.func_175063_a(text, (float)x, (float)y, colour);
        } else {
            fontRenderer.func_78276_b(text, x, y, colour);
        }
    }

    public static void drawString(String text, int x, int y, int colour) {
        GuiDraw.drawString(text, x, y, colour, true);
    }

    public static void drawStringC(String text, int x, int y, int w, int h, int colour, boolean shadow) {
        GuiDraw.drawString(text, x + (w - GuiDraw.getStringWidth(text)) / 2, y + (h - 8) / 2, colour, shadow);
    }

    public static void drawStringC(String text, int x, int y, int w, int h, int colour) {
        GuiDraw.drawStringC(text, x, y, w, h, colour, true);
    }

    public static void drawStringC(String text, int x, int y, int colour, boolean shadow) {
        GuiDraw.drawString(text, x - GuiDraw.getStringWidth(text) / 2, y, colour, shadow);
    }

    public static void drawStringC(String text, int x, int y, int colour) {
        GuiDraw.drawStringC(text, x, y, colour, true);
    }

    public static void drawStringR(String text, int x, int y, int colour, boolean shadow) {
        GuiDraw.drawString(text, x - GuiDraw.getStringWidth(text), y, colour, shadow);
    }

    public static void drawStringR(String text, int x, int y, int colour) {
        GuiDraw.drawStringR(text, x, y, colour, true);
    }

    public static int getStringWidth(String s) {
        if (s == null || s.equals("")) {
            return 0;
        }
        return fontRenderer.func_78256_a(TextFormatting.func_110646_a((String)s));
    }

    public static Dimension getDisplaySize() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        return new Dimension(res.func_78326_a(), res.func_78328_b());
    }

    public static Dimension getDisplayRes() {
        Minecraft mc = Minecraft.func_71410_x();
        return new Dimension(mc.field_71443_c, mc.field_71440_d);
    }

    public static Point getMousePosition(int eventX, int eventY) {
        Dimension size = GuiDraw.getDisplaySize();
        Dimension res = GuiDraw.getDisplayRes();
        return new Point(eventX * size.width / res.width, size.height - eventY * size.height / res.height - 1);
    }

    public static Point getMousePosition() {
        return GuiDraw.getMousePosition(Mouse.getX(), Mouse.getY());
    }

    public static void drawTip(int x, int y, String text) {
        GuiDraw.drawMultiLineTip(x, y, Collections.singletonList(text));
    }

    public static void drawMultiLineTip(int x, int y, List<String> list) {
        GuiDraw.drawMultiLineTip(null, x, y, list);
    }

    public static void drawMultiLineTip(@Nullable ItemStack stack, int x, int y, List<String> lines) {
        int screenHeight;
        if (lines.isEmpty()) {
            return;
        }
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        int screenWidth = res.func_78326_a();
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, lines, x, y, screenWidth, screenHeight = res.func_78328_b(), -1, fontRenderer);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        x = event.getX();
        y = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        int maxTextWidth = event.getMaxWidth();
        FontRenderer font = event.getFontRenderer();
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        int tooltipTextWidth = 0;
        for (String textLine : lines) {
            int textLineWidth = font.func_78256_a(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        int titleLinesCount = 1;
        int tooltipX = x + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = x - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = x > screenWidth / 2 ? x - 12 - 8 : screenWidth - 16 - x;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<String> wrappedTextLines = new ArrayList<String>();
            for (int i = 0; i < lines.size(); ++i) {
                String textLine = lines.get(i);
                List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (String line : wrappedLine) {
                    int lineWidth = font.func_78256_a(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            lines = wrappedTextLines;
            tooltipX = x > screenWidth / 2 ? x - 16 - tooltipTextWidth : x;
        }
        int tooltipY = y;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += (lines.size() - 1) * 10;
            if (lines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        if ((tooltipY = MathHelper.func_76125_a((int)tooltipY, (int)6, (int)(screenHeight - 6))) + tooltipHeight + 6 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 6;
        }
        int backgroundColor = -267386864;
        GuiDraw.drawGradientRectDirect(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        GuiDraw.drawGradientRectDirect(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
        GuiDraw.drawGradientRectDirect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiDraw.drawGradientRectDirect(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiDraw.drawGradientRectDirect(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        GuiDraw.drawGradientRectDirect(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiDraw.drawGradientRectDirect(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiDraw.drawGradientRectDirect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        GuiDraw.drawGradientRectDirect(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, lines, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
        int tooltipTop = tooltipY;
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber);
            font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, lines, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
    }

    public static class GuiHook
    extends Gui {
        public void setZLevel(float f) {
            this.field_73735_i = f;
        }

        public float getZLevel() {
            return this.field_73735_i;
        }

        public void incZLevel(float f) {
            this.field_73735_i += f;
        }

        public void func_73733_a(int par1, int par2, int par3, int par4, int par5, int par6) {
            super.func_73733_a(par1, par2, par3, par4, par5, par6);
        }
    }
}

