/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.configuration;

import codechicken.lib.configuration.ConfigFile;
import codechicken.lib.configuration.ConfigParseException;
import codechicken.lib.configuration.IConfigTag;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ConfigTag
implements IConfigTag {
    private static Pattern QUOTE_PATTERN = Pattern.compile("(?<=\")(.*)(?=\")");
    private static Pattern STRING_MATCHER = Pattern.compile("(?<=.:\")(.*)(\"=\")(.*)(?=\")");
    private static final Set<String> validTrue = Sets.newHashSet((Object[])new String[]{"true", "yes", "1"});
    private static final Set<String> validFalse = Sets.newHashSet((Object[])new String[]{"false", "no", "0"});
    protected String name;
    protected String version;
    protected Map<String, ConfigTag> children;
    protected ConfigTag parent;
    protected boolean dirty;
    protected List<String> comment;
    private IConfigTag.TagType type;
    protected IConfigTag.TagType listType;
    protected Object value;

    protected ConfigTag(String name, ConfigTag parent) {
        this.name = name;
        this.parent = parent;
        this.children = new LinkedHashMap<String, ConfigTag>();
        this.comment = new LinkedList<String>();
    }

    protected void parseTag(ConfigFile.ConfigReader reader) throws IOException {
        String line;
        block21: while ((line = ConfigTag.readLine(reader)) != null) {
            LinkedList<Object> list;
            ConfigTag tag;
            IConfigTag.TagType type;
            block32: {
                if (line.isEmpty() || line.startsWith("//") || line.startsWith("#")) continue;
                if (line.startsWith("}")) break;
                if (line.startsWith("~")) {
                    this.version = line.substring(1);
                    continue;
                }
                if (line.startsWith("\"") && line.endsWith("{")) {
                    Matcher matcher = QUOTE_PATTERN.matcher(line);
                    if (!matcher.find()) {
                        throw new ConfigParseException("Malformed line! @%s, %s", reader.getCurrLine(), line);
                    }
                    String name = matcher.group();
                    ConfigTag tag2 = this.getTag(name);
                    tag2.parseTag(reader);
                    continue;
                }
                boolean isList = line.endsWith("<");
                char first = line.charAt(0);
                type = IConfigTag.TagType.fromChar(first);
                if (type == null) {
                    throw new ConfigParseException("Invalid value type %s, @Line:%s, %s", Character.valueOf(first), reader.getCurrLine(), line);
                }
                Matcher matcher = (type != IConfigTag.TagType.STRING || isList ? QUOTE_PATTERN : STRING_MATCHER).matcher(line);
                if (!matcher.find()) {
                    throw new ConfigParseException("Malformed line! @%s, %s", reader.getCurrLine(), line);
                }
                String name = matcher.group(1);
                tag = this.getTag(name);
                if (!isList) {
                    String value;
                    if (type == IConfigTag.TagType.STRING) {
                        value = matcher.group(3);
                    } else {
                        int equals = line.indexOf(61);
                        value = line.substring(equals + 1);
                    }
                    switch (type) {
                        case BOOLEAN: {
                            tag.setBoolean(ConfigTag.parseBoolean(value, reader.getCurrLine()));
                            continue block21;
                        }
                        case STRING: {
                            tag.setString(value);
                            continue block21;
                        }
                        case INT: {
                            tag.setInt(Integer.parseInt(value));
                            continue block21;
                        }
                        case HEX: {
                            tag.setHex((int)Long.parseLong(value.replace("0x", ""), 16));
                            continue block21;
                        }
                        case DOUBLE: {
                            tag.setDouble(Double.parseDouble(value));
                            continue block21;
                        }
                    }
                }
                list = new LinkedList<Object>();
                block22: while (true) {
                    String listLine;
                    if ((listLine = ConfigTag.readLine(reader)) == null) {
                        throw new EOFException("End of line reached whilst parsing list?");
                    }
                    if (listLine.isEmpty() || line.startsWith("//") || line.startsWith("#")) continue;
                    if (listLine.startsWith(">")) break block32;
                    switch (type) {
                        case BOOLEAN: {
                            list.add(ConfigTag.parseBoolean(listLine, reader.getCurrLine()));
                            continue block22;
                        }
                        case STRING: {
                            list.add(listLine);
                            continue block22;
                        }
                        case INT: {
                            list.add(Integer.parseInt(listLine));
                            continue block22;
                        }
                        case HEX: {
                            list.add((int)Long.parseLong(listLine.replace("0x", ""), 16));
                            continue block22;
                        }
                        case DOUBLE: {
                            list.add(Double.parseDouble(listLine));
                            continue block22;
                        }
                    }
                    break;
                }
                throw new ConfigParseException("Invalid type state at list parsing?? %s", line);
            }
            switch (type) {
                case BOOLEAN: {
                    tag.setBooleanList(list);
                    break;
                }
                case STRING: {
                    tag.setStringList(list);
                    break;
                }
                case INT: {
                    tag.setIntList(list);
                    break;
                }
                case HEX: {
                    tag.setHexList(list);
                    break;
                }
                case DOUBLE: {
                    tag.setDoubleList(list);
                }
            }
        }
    }

    private static boolean parseBoolean(String value, int line) throws IOException {
        Boolean bool = null;
        if (validTrue.contains(value.toLowerCase(Locale.US))) {
            bool = true;
        } else if (validFalse.contains(value.toLowerCase(Locale.US))) {
            bool = false;
        }
        if (bool == null) {
            throw new ConfigParseException("Invalid Boolean qualifier! %s on line: %s, supported: %s", value, line, Joiner.on((String)", ").join(Iterables.concat(validTrue, validFalse)));
        }
        return bool;
    }

    protected static String readLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        return line == null ? null : line.replace("\t", "");
    }

    protected void writeTag(PrintWriter writer, int depth) {
        for (String string : this.comment) {
            this.writeLine(writer, depth, "#" + string, new Object[0]);
        }
        if (this.isCategory()) {
            if (this.version != null) {
                this.writeLine(writer, depth, "~%s", this.version);
            }
            for (Map.Entry entry : this.children.entrySet()) {
                int inc = 0;
                if (((ConfigTag)entry.getValue()).isCategory()) {
                    this.writeLine(writer, depth, "\"%s\" {", entry.getKey());
                    ++inc;
                }
                ((ConfigTag)entry.getValue()).writeTag(writer, depth + inc);
                if (((ConfigTag)entry.getValue()).isCategory()) {
                    this.writeLine(writer, depth, "}", new Object[0]);
                }
                writer.println();
            }
        } else if (this.isValue()) {
            switch (this.type) {
                case STRING: {
                    this.writeLine(writer, depth, "%s:\"%s\"=\"%s\"", Character.valueOf(this.type.getChar()), this.name, this.value);
                    break;
                }
                case BOOLEAN: 
                case INT: 
                case HEX: 
                case DOUBLE: {
                    this.writeLine(writer, depth, "%s:\"%s\"=%s", Character.valueOf(this.type.getChar()), this.name, this.type.processLine(this.value));
                    break;
                }
                case LIST: {
                    this.writeLine(writer, depth, "%s:\"%s\" <", Character.valueOf(this.listType.getChar()), this.name);
                    for (Object object : (List)this.value) {
                        this.writeLine(writer, depth + 1, "%s", this.listType.processLine(object));
                    }
                    this.writeLine(writer, depth, ">", new Object[0]);
                }
            }
        } else {
            throw new IllegalStateException("Somehow a tag is not a category or a value..");
        }
    }

    protected void writeLine(PrintWriter writer, int tabs, String line, Object ... data) {
        for (int i = 0; i < tabs; ++i) {
            writer.print('\t');
        }
        writer.println(String.format(line, data));
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    @Nullable
    public ConfigTag getParent() {
        return this.parent;
    }

    @Override
    public boolean isCategory() {
        return this.value == null || !this.children.isEmpty();
    }

    @Override
    public boolean isValue() {
        return this.children.isEmpty() && this.value != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirty() {
        return this.dirty || this.hasParent() && this.parent.isDirty();
    }

    @Override
    public ConfigTag markDirty() {
        this.dirty = true;
        if (this.hasParent()) {
            this.parent.markDirty();
        }
        return this;
    }

    @Override
    public void clear() {
        if (this.isCategory()) {
            this.children.clear();
            this.markDirty();
        }
    }

    protected void onSave() {
        this.dirty = false;
        this.children.values().forEach(ConfigTag::onSave);
    }

    @Override
    public boolean hasTag(String name) {
        return this.value == null && this.children.containsKey(name);
    }

    @Override
    public ConfigTag getTag(String name) {
        this.addTagCheck();
        return this.children.computeIfAbsent(name, s -> new ConfigTag((String)s, this));
    }

    @Override
    @Nullable
    public ConfigTag getTagIfPresent(String name) {
        this.addTagCheck();
        return this.children.get(name);
    }

    @Override
    public ConfigTag deleteTag(String name) {
        if (this.isCategory()) {
            this.children.remove(name);
        }
        return this;
    }

    @Override
    public String getTagVersion() {
        return this.version;
    }

    @Override
    public ConfigTag setTagVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public IConfigTag.TagType getTagType() {
        return this.type;
    }

    @Override
    public Object getRawValue() {
        return this.value;
    }

    @Override
    public ConfigTag setComment(String comment) {
        this.comment = new LinkedList<String>();
        this.comment.add(comment);
        return this;
    }

    @Override
    public ConfigTag setComment(List<String> lines) {
        this.comment = new LinkedList<String>(lines);
        return null;
    }

    @Override
    public boolean getBoolean(boolean defaultValue) {
        this.setValueCheck();
        if (this.value == null) {
            this.setBoolean(defaultValue);
        } else {
            if (this.type != IConfigTag.TagType.BOOLEAN) {
                throw new UnsupportedOperationException("ConfigTag is not of a Boolean type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof Boolean)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return (Boolean)this.value;
    }

    @Override
    public String getString(String defaultValue) {
        this.setValueCheck();
        if (this.value == null) {
            this.setString(defaultValue);
        } else {
            if (this.type != IConfigTag.TagType.STRING) {
                throw new UnsupportedOperationException("ConfigTag is not of a String type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof String)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return (String)this.value;
    }

    @Override
    public int getInt(int defaultValue) {
        this.setValueCheck();
        if (this.value == null) {
            this.setInt(defaultValue);
        } else {
            if (this.type != IConfigTag.TagType.INT) {
                throw new UnsupportedOperationException("ConfigTag is not of a Integer type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof Integer)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return (Integer)this.value;
    }

    @Override
    public int getHex(int defaultValue) {
        this.setValueCheck();
        if (this.value == null) {
            this.setHex(defaultValue);
        } else {
            if (this.type != IConfigTag.TagType.HEX) {
                throw new UnsupportedOperationException("ConfigTag is not of a Hex type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof String)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return (int)Long.parseLong(((String)this.value).replace("0x", ""), 16);
    }

    @Override
    public double getDouble(double defaultValue) {
        this.setValueCheck();
        if (this.value == null) {
            this.setDouble(defaultValue);
        } else {
            if (this.type != IConfigTag.TagType.DOUBLE) {
                throw new UnsupportedOperationException("ConfigTag is not of a Double type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof Double)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return ((Integer)this.value).intValue();
    }

    @Override
    public ConfigTag setBoolean(boolean value) {
        this.setValueCheck();
        this.type = IConfigTag.TagType.BOOLEAN;
        this.value = value;
        this.markDirty();
        return this;
    }

    @Override
    public ConfigTag setString(String value) {
        this.setValueCheck();
        this.type = IConfigTag.TagType.STRING;
        this.value = value;
        this.markDirty();
        return this;
    }

    @Override
    public ConfigTag setInt(int value) {
        this.setValueCheck();
        this.type = IConfigTag.TagType.INT;
        this.value = value;
        this.markDirty();
        return this;
    }

    @Override
    public ConfigTag setHex(int value) {
        this.setValueCheck();
        this.setString("0x" + Long.toString((long)value << 32 >>> 32, 16));
        this.type = IConfigTag.TagType.HEX;
        this.markDirty();
        return this;
    }

    @Override
    public ConfigTag setDouble(double value) {
        this.setValueCheck();
        this.type = IConfigTag.TagType.DOUBLE;
        this.value = value;
        this.markDirty();
        return this;
    }

    @Override
    public List<Boolean> getBooleanList(List<Boolean> defaultValues) {
        this.setValueCheck();
        if (this.value == null) {
            this.setBooleanList((List)defaultValues);
        } else {
            if (this.type != IConfigTag.TagType.LIST) {
                throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
            }
            if (this.listType != IConfigTag.TagType.BOOLEAN) {
                throw new UnsupportedOperationException("List is not of a Boolean type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof List)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return (List)this.value;
    }

    @Override
    public List<String> getStringList(List<String> defaultValues) {
        this.setValueCheck();
        if (this.value == null) {
            this.setStringList((List)defaultValues);
        } else {
            if (this.type != IConfigTag.TagType.LIST) {
                throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
            }
            if (this.listType != IConfigTag.TagType.STRING) {
                throw new UnsupportedOperationException("List is not of a String type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof List)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return (List)this.value;
    }

    @Override
    public List<Integer> getIntList(List<Integer> defaultValues) {
        this.setValueCheck();
        if (this.value == null) {
            this.setIntList((List)defaultValues);
        } else {
            if (this.type != IConfigTag.TagType.LIST) {
                throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
            }
            if (this.listType != IConfigTag.TagType.INT) {
                throw new UnsupportedOperationException("List is not of a Integer type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof List)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return (List)this.value;
    }

    @Override
    public List<Integer> getHexList(List<Integer> defaultValues) {
        this.setValueCheck();
        if (this.value == null) {
            this.setHexList((List)defaultValues);
        } else {
            if (this.type != IConfigTag.TagType.LIST) {
                throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
            }
            if (this.listType != IConfigTag.TagType.HEX) {
                throw new UnsupportedOperationException("List is not of a Hex type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof List)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return (List)this.value;
    }

    @Override
    public List<Double> getDoubleList(List<Double> defaultValues) {
        this.setValueCheck();
        if (this.value == null) {
            this.setDoubleList((List)defaultValues);
        } else {
            if (this.type != IConfigTag.TagType.LIST) {
                throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
            }
            if (this.listType != IConfigTag.TagType.DOUBLE) {
                throw new UnsupportedOperationException("List is not of a Double type, Actual: " + (Object)((Object)this.type));
            }
            if (!(this.value instanceof List)) {
                throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
            }
        }
        return (List)this.value;
    }

    protected void setList(List<?> value) {
        this.setValueCheck();
        this.type = IConfigTag.TagType.LIST;
        this.value = value;
        this.markDirty();
    }

    @Override
    public ConfigTag setBooleanList(List<Boolean> value) {
        this.setList(value);
        this.listType = IConfigTag.TagType.BOOLEAN;
        return this;
    }

    @Override
    public ConfigTag setStringList(List<String> value) {
        this.setList(value);
        this.listType = IConfigTag.TagType.STRING;
        return this;
    }

    @Override
    public ConfigTag setIntList(List<Integer> value) {
        this.setList(value);
        this.listType = IConfigTag.TagType.INT;
        return this;
    }

    @Override
    public ConfigTag setHexList(List<Integer> value) {
        this.setList(value);
        this.listType = IConfigTag.TagType.HEX;
        return this;
    }

    @Override
    public ConfigTag setDoubleList(List<Double> value) {
        this.setList(value);
        this.listType = IConfigTag.TagType.DOUBLE;
        return this;
    }

    protected void addTagCheck() {
        if (this.value != null) {
            throw new UnsupportedOperationException("Unable to get a sub tag for a tag that has a value");
        }
    }

    protected void setValueCheck() {
        if (!this.children.isEmpty()) {
            throw new UnsupportedOperationException("Unable to set the value for a tag that has children.");
        }
    }
}

